/*
 * Decompiled with CFR 0.152.
 */
package com.rikmuld.camping.misc;

import com.rikmuld.camping.core.lib.ConfigInfo;
import com.rikmuld.camping.core.util.LogUtil;
import java.io.File;
import java.util.Iterator;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class Config {
    public Configuration config;

    public Config(File file) {
        this.config = new Configuration(file);
        ConfigInfo.putAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll() {
        try {
            this.config.load();
            this.loadBooleanOptions();
            this.loadIntegerOptions();
            this.loadDoubleOptions();
        }
        catch (Exception e) {
            LogUtil.log(Level.ERROR, "The Camping Mod 2.0 could not load its configuration properly.");
        }
        finally {
            this.config.save();
        }
    }

    public void loadBooleanOptions() {
        Iterator<String> nameIDs = ConfigInfo.ConfigInfoBoolean.names.keySet().iterator();
        Iterator<String> gameNames = ConfigInfo.ConfigInfoBoolean.names.values().iterator();
        Iterator<Boolean> values = ConfigInfo.ConfigInfoBoolean.devValues.values().iterator();
        Iterator<String> types = ConfigInfo.ConfigInfoBoolean.catagories.values().iterator();
        while (nameIDs.hasNext()) {
            String type = types.next();
            boolean value = values.next();
            String name = nameIDs.next();
            String gameName = gameNames.next();
            ConfigInfo.ConfigInfoBoolean.values.put(name, this.config.get(type, gameName, value).getBoolean(value));
        }
    }

    public void loadDoubleOptions() {
        Iterator<String> nameIDs = ConfigInfo.ConfigInfoDouble.names.keySet().iterator();
        Iterator<String> gameNames = ConfigInfo.ConfigInfoDouble.names.values().iterator();
        Iterator<Double> values = ConfigInfo.ConfigInfoDouble.devValues.values().iterator();
        Iterator<String> types = ConfigInfo.ConfigInfoDouble.catagories.values().iterator();
        while (nameIDs.hasNext()) {
            String type = types.next();
            double value = values.next();
            String name = nameIDs.next();
            String gameName = gameNames.next();
            ConfigInfo.ConfigInfoDouble.values.put(name, this.config.get(type, gameName, value).getDouble(value));
        }
    }

    public void loadIntegerOptions() {
        Iterator<String> nameIDs = ConfigInfo.ConfigInfoInteger.names.keySet().iterator();
        Iterator<String> gameNames = ConfigInfo.ConfigInfoInteger.names.values().iterator();
        Iterator<Integer> values = ConfigInfo.ConfigInfoInteger.devValues.values().iterator();
        Iterator<String> types = ConfigInfo.ConfigInfoInteger.catagories.values().iterator();
        while (nameIDs.hasNext()) {
            String type = types.next();
            int value = values.next();
            String name = nameIDs.next();
            String gameName = gameNames.next();
            ConfigInfo.ConfigInfoInteger.values.put(name, this.config.get(type, gameName, value).getInt(value));
        }
    }
}

