/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.BetterHorses.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import thehippomaster.AnimationAPI.AnimationAPI;
import thehippomaster.AnimationAPI.IAnimatedEntity;
import thehippomaster.AnimationAPI.client.Animator;
import thehippomaster.AnimationAPI.client.ModelJoint;
import thehippomaster.BetterHorses.Horse;

@SideOnly(value=Side.CLIENT)
public class HorseModel
extends ModelBase {
    private ModelRenderer head;
    private ModelRenderer mouthTop;
    private ModelRenderer mouthBottom;
    private ModelRenderer horseLeftEar;
    private ModelRenderer horseRightEar;
    private ModelRenderer donkeyLeftEar;
    private ModelRenderer donkeyRightEar;
    private ModelRenderer neck;
    private ModelRenderer mane;
    private ModelRenderer body;
    private ModelRenderer tailBase;
    private ModelRenderer tailMiddle;
    private ModelRenderer tailTip;
    private ModelRenderer backLeftLeg;
    private ModelRenderer backLeftShin;
    private ModelRenderer backLeftHoof;
    private ModelRenderer backRightLeg;
    private ModelRenderer backRightShin;
    private ModelRenderer backRightHoof;
    private ModelRenderer frontLeftLeg;
    private ModelRenderer frontLeftShin;
    private ModelRenderer frontLeftHoof;
    private ModelRenderer frontRightLeg;
    private ModelRenderer frontRightShin;
    private ModelRenderer frontRightHoof;
    private ModelRenderer leftChest;
    private ModelRenderer rightChest;
    private ModelRenderer saddle;
    private ModelRenderer leftSaddleRope;
    private ModelRenderer rightSaddleRope;
    private ModelRenderer leftReinsMetal;
    private ModelRenderer rightReinsMetal;
    private ModelRenderer leftRein;
    private ModelRenderer rightRein;
    private ModelRenderer faceReins;
    private Animator animator;
    private static float PI = (float)Math.PI;

    public HorseModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.body = new ModelRenderer((ModelBase)this, 0, 34);
        this.body.func_78789_a(-5.0f, -10.0f, -19.0f, 10, 10, 24);
        this.body.func_78793_a(0.0f, 13.0f, 9.0f);
        this.tailBase = new ModelRenderer((ModelBase)this, 44, 0);
        this.tailBase.func_78789_a(-1.0f, -1.0f, 0.0f, 2, 2, 3);
        this.tailBase.func_78793_a(0.0f, -10.0f, 5.0f);
        this.body.func_78792_a(this.tailBase);
        this.tailMiddle = new ModelRenderer((ModelBase)this, 38, 7);
        this.tailMiddle.func_78789_a(-1.5f, -2.0f, 0.0f, 3, 4, 7);
        this.tailMiddle.func_78793_a(0.0f, 0.0f, 3.0f);
        this.tailBase.func_78792_a(this.tailMiddle);
        this.tailTip = new ModelRenderer((ModelBase)this, 24, 3);
        this.tailTip.func_78789_a(-1.5f, -2.0f, 0.0f, 3, 4, 7);
        this.tailTip.func_78793_a(0.0f, 0.0f, 6.0f);
        this.tailMiddle.func_78792_a(this.tailTip);
        this.backLeftLeg = new ModelRenderer((ModelBase)this, 78, 29);
        this.backLeftLeg.func_78789_a(-2.0f, 0.0f, -2.5f, 4, 9, 5);
        this.backLeftLeg.func_78793_a(3.5f, -6.0f, 2.0f);
        this.body.func_78792_a(this.backLeftLeg);
        this.backLeftShin = new ModelRenderer((ModelBase)this, 78, 43);
        this.backLeftShin.func_78789_a(-1.5f, 0.0f, -1.5f, 3, 5, 3);
        this.backLeftShin.func_78793_a(0.0f, 9.0f, 0.0f);
        this.backLeftLeg.func_78792_a(this.backLeftShin);
        this.backLeftHoof = new ModelRenderer((ModelBase)this, 78, 51);
        this.backLeftHoof.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 3, 4);
        this.backLeftHoof.func_78793_a(0.0f, 5.0f, 0.0f);
        this.backLeftShin.func_78792_a(this.backLeftHoof);
        this.backRightLeg = new ModelRenderer((ModelBase)this, 96, 29);
        this.backRightLeg.func_78789_a(-2.0f, 0.0f, -2.5f, 4, 9, 5);
        this.backRightLeg.func_78793_a(-3.5f, -6.0f, 2.0f);
        this.body.func_78792_a(this.backRightLeg);
        this.backRightShin = new ModelRenderer((ModelBase)this, 96, 43);
        this.backRightShin.func_78789_a(-1.5f, 0.0f, -1.5f, 3, 5, 3);
        this.backRightShin.func_78793_a(0.0f, 9.0f, 0.0f);
        this.backRightLeg.func_78792_a(this.backRightShin);
        this.backRightHoof = new ModelRenderer((ModelBase)this, 96, 51);
        this.backRightHoof.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 3, 4);
        this.backRightHoof.func_78793_a(0.0f, 5.0f, 0.0f);
        this.backRightShin.func_78792_a(this.backRightHoof);
        this.frontLeftLeg = new ModelRenderer((ModelBase)this, 44, 29);
        this.frontLeftLeg.func_78790_a(-1.5f, 0.0f, -2.0f, 3, 8, 4, 0.001f);
        this.frontLeftLeg.func_78793_a(3.6f, -5.0f, -17.1f);
        this.body.func_78792_a(this.frontLeftLeg);
        this.frontLeftShin = new ModelRenderer((ModelBase)this, 44, 41);
        this.frontLeftShin.func_78789_a(-1.5f, 0.0f, -1.5f, 3, 5, 3);
        this.frontLeftShin.func_78793_a(0.0f, 8.0f, 0.0f);
        this.frontLeftLeg.func_78792_a(this.frontLeftShin);
        this.frontLeftHoof = new ModelRenderer((ModelBase)this, 44, 51);
        this.frontLeftHoof.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 3, 4);
        this.frontLeftHoof.func_78793_a(0.0f, 5.0f, 0.0f);
        this.frontLeftShin.func_78792_a(this.frontLeftHoof);
        this.frontRightLeg = new ModelRenderer((ModelBase)this, 60, 29);
        this.frontRightLeg.func_78790_a(-1.5f, 0.0f, -2.0f, 3, 8, 4, 0.001f);
        this.frontRightLeg.func_78793_a(-3.6f, -5.0f, -17.1f);
        this.body.func_78792_a(this.frontRightLeg);
        this.frontRightShin = new ModelRenderer((ModelBase)this, 60, 41);
        this.frontRightShin.func_78789_a(-1.5f, 0.0f, -1.5f, 3, 5, 3);
        this.frontRightShin.func_78793_a(0.0f, 8.0f, 0.0f);
        this.frontRightLeg.func_78792_a(this.frontRightShin);
        this.frontRightHoof = new ModelRenderer((ModelBase)this, 60, 51);
        this.frontRightHoof.func_78789_a(-2.0f, 0.0f, -2.0f, 4, 3, 4);
        this.frontRightHoof.func_78793_a(0.0f, 5.0f, 0.0f);
        this.frontRightShin.func_78792_a(this.frontRightHoof);
        this.neck = new ModelJoint((ModelBase)this, 0, 12);
        this.neck.func_78789_a(-2.0f, -14.0f, -2.0f, 4, 14, 8);
        this.neck.func_78793_a(0.0f, -5.0f, -16.75f);
        this.body.func_78792_a(this.neck);
        this.mane = new ModelRenderer((ModelBase)this, 58, 0);
        this.mane.func_78789_a(-1.0f, -16.0f, -2.0f, 2, 16, 4);
        this.mane.func_78793_a(0.0f, -0.1f, 7.0f);
        this.neck.func_78792_a(this.mane);
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78789_a(-2.5f, -1.0f, -4.5f, 5, 5, 7);
        this.head.func_78793_a(0.0f, -13.5f, 3.0f);
        this.neck.func_78792_a(this.head);
        this.mouthTop = new ModelRenderer((ModelBase)this, 24, 18);
        this.mouthTop.func_78790_a(-2.0f, -3.0f, -6.0f, 4, 3, 6, 0.001f);
        this.mouthTop.func_78793_a(0.0f, 2.0f, -4.5f);
        this.head.func_78792_a(this.mouthTop);
        this.mouthBottom = new ModelRenderer((ModelBase)this, 24, 27);
        this.mouthBottom.func_78790_a(-2.0f, 0.0f, -6.0f, 4, 2, 5, 0.001f);
        this.mouthBottom.func_78793_a(0.0f, 2.0f, -4.0f);
        this.head.func_78792_a(this.mouthBottom);
        this.horseLeftEar = new ModelRenderer((ModelBase)this, 0, 0);
        this.horseLeftEar.func_78790_a(-1.0f, -3.0f, -0.5f, 2, 3, 1, -0.001f);
        this.horseLeftEar.func_78793_a(1.5f, 0.0f, 0.5f);
        this.head.func_78792_a(this.horseLeftEar);
        this.horseRightEar = new ModelRenderer((ModelBase)this, 0, 0);
        this.horseRightEar.func_78790_a(-1.0f, -3.0f, -0.5f, 2, 3, 1, -0.001f);
        this.horseRightEar.func_78793_a(-1.5f, 0.0f, 0.5f);
        this.head.func_78792_a(this.horseRightEar);
        this.donkeyLeftEar = new ModelRenderer((ModelBase)this, 0, 12);
        this.donkeyLeftEar.func_78789_a(-1.0f, -7.0f, -0.5f, 2, 7, 1);
        this.donkeyLeftEar.func_78793_a(1.5f, 0.0f, 0.5f);
        this.head.func_78792_a(this.donkeyLeftEar);
        this.donkeyRightEar = new ModelRenderer((ModelBase)this, 0, 12);
        this.donkeyRightEar.func_78789_a(-1.0f, -7.0f, -0.5f, 2, 7, 1);
        this.donkeyRightEar.func_78793_a(-1.5f, 0.0f, 0.5f);
        this.head.func_78792_a(this.donkeyRightEar);
        this.leftChest = new ModelRenderer((ModelBase)this, 0, 47);
        this.leftChest.func_78789_a(-4.0f, 0.0f, -0.5f, 8, 8, 3);
        this.leftChest.func_78793_a(5.0f, -10.1f, 0.0f);
        this.body.func_78792_a(this.leftChest);
        this.rightChest = new ModelRenderer((ModelBase)this, 0, 34);
        this.rightChest.func_78789_a(-4.0f, 0.0f, -2.5f, 8, 8, 3);
        this.rightChest.func_78793_a(-5.0f, -10.1f, 0.0f);
        this.body.func_78792_a(this.rightChest);
        this.saddle = new ModelRenderer((ModelBase)this, 80, 0);
        this.saddle.func_78784_a(80, 0).func_78789_a(-5.0f, -1.0f, -4.0f, 10, 1, 8);
        this.saddle.func_78784_a(106, 9).func_78789_a(-1.5f, -2.0f, -4.0f, 3, 1, 2);
        this.saddle.func_78784_a(80, 9).func_78789_a(-4.0f, -2.0f, 2.0f, 8, 1, 2);
        this.saddle.func_78793_a(0.0f, -10.0f, -6.0f);
        this.body.func_78792_a(this.saddle);
        this.leftSaddleRope = new ModelRenderer((ModelBase)this, 70, 0);
        this.leftSaddleRope.func_78784_a(70, 0).func_78789_a(-0.5f, 0.5f, -0.5f, 1, 6, 1);
        this.leftSaddleRope.func_78784_a(74, 0).func_78789_a(-0.5f, 6.5f, -1.0f, 1, 2, 2);
        this.leftSaddleRope.func_78793_a(5.0f, -1.6f, -0.5f);
        this.saddle.func_78792_a(this.leftSaddleRope);
        this.rightSaddleRope = new ModelRenderer((ModelBase)this, 80, 0);
        this.rightSaddleRope.func_78784_a(80, 0).func_78789_a(-0.5f, 0.5f, -0.5f, 1, 6, 1);
        this.rightSaddleRope.func_78784_a(74, 4).func_78789_a(-0.5f, 6.5f, -1.0f, 1, 2, 2);
        this.rightSaddleRope.func_78793_a(-5.0f, -1.6f, -0.5f);
        this.saddle.func_78792_a(this.rightSaddleRope);
        this.leftReinsMetal = new ModelRenderer((ModelBase)this, 74, 13);
        this.leftReinsMetal.func_78789_a(-0.5f, -2.0f, -4.0f, 1, 2, 2);
        this.leftReinsMetal.func_78793_a(2.0f, 3.0f, -4.0f);
        this.head.func_78792_a(this.leftReinsMetal);
        this.rightReinsMetal = new ModelRenderer((ModelBase)this, 74, 13);
        this.rightReinsMetal.func_78789_a(-0.5f, -2.0f, -4.0f, 1, 2, 2);
        this.rightReinsMetal.func_78793_a(-2.0f, 3.0f, -4.0f);
        this.head.func_78792_a(this.rightReinsMetal);
        this.leftRein = new ModelRenderer((ModelBase)this, 44, 10);
        this.leftRein.func_78789_a(0.0f, -3.0f, 0.0f, 0, 3, 16);
        this.leftRein.func_78793_a(2.6f, 4.0f, -8.0f);
        this.head.func_78792_a(this.leftRein);
        this.rightRein = new ModelRenderer((ModelBase)this, 44, 5);
        this.rightRein.func_78789_a(0.0f, -3.0f, 0.0f, 0, 3, 16);
        this.rightRein.func_78793_a(-2.6f, 4.0f, -8.0f);
        this.head.func_78792_a(this.rightRein);
        this.faceReins = new ModelRenderer((ModelBase)this, 80, 12);
        this.faceReins.func_78790_a(-2.5f, -5.0f, -7.0f, 5, 5, 12, 0.2f);
        this.faceReins.func_78793_a(0.0f, 4.0f, -4.0f);
        this.head.func_78792_a(this.faceReins);
        this.animator = new Animator((ModelBase)this);
    }

    private void setRotation(ModelRenderer renderer, float par2, float par3, float par4) {
        renderer.field_78795_f = par2;
        renderer.field_78796_g = par3;
        renderer.field_78808_h = par4;
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        Horse horse = (Horse)entity;
        int horseType = horse.func_110265_bP();
        boolean adult = horse.func_110228_bR();
        boolean saddled = adult && horse.func_110257_ck();
        boolean chested = adult && horse.func_110261_ca();
        boolean donkey = horseType == 1 || horseType == 2;
        float size = horse.func_110254_bY();
        boolean ridden = horse.field_70153_n != null;
        this.faceReins.field_78806_j = saddled;
        this.saddle.field_78806_j = saddled;
        this.leftSaddleRope.field_78806_j = saddled;
        this.rightSaddleRope.field_78806_j = saddled;
        this.leftReinsMetal.field_78806_j = saddled;
        this.rightReinsMetal.field_78806_j = saddled;
        this.leftRein.field_78806_j = saddled && ridden;
        this.rightRein.field_78806_j = saddled && ridden;
        this.horseLeftEar.field_78806_j = !donkey;
        this.horseRightEar.field_78806_j = !donkey;
        this.donkeyRightEar.field_78806_j = donkey;
        this.donkeyLeftEar.field_78806_j = donkey;
        this.rightChest.field_78806_j = chested;
        this.leftChest.field_78806_j = chested;
        this.animator.update((IAnimatedEntity)entity);
        this.setAngles();
        this.animate((Horse)entity, f, f1, f2, f3, f4, f5);
        this.body.func_78785_a(f5);
    }

    public void setAngles() {
        this.body.field_78797_d = 13.0f;
        this.mouthBottom.field_78798_e = -4.0f;
        this.setRotation(this.tailBase, -1.13f, 0.0f, 0.0f);
        this.setRotation(this.tailTip, -0.27f, 0.0f, 0.0f);
        this.setRotation(this.neck, 0.526f, 0.0f, 0.0f);
        this.setRotation(this.donkeyLeftEar, 0.0f, 0.0f, 0.262f);
        this.setRotation(this.donkeyRightEar, 0.0f, 0.0f, -0.262f);
        this.setRotation(this.leftChest, 0.0f, PI / 2.0f, 0.0f);
        this.setRotation(this.rightChest, 0.0f, PI / 2.0f, 0.0f);
        this.setRotation(this.leftRein, -0.526f, 0.0f, 0.0f);
        this.setRotation(this.rightRein, -0.526f, 0.0f, 0.0f);
    }

    private void getWalkAnimations(float[] walk1, float[] walk2, float[] walkSpeedAdd, float f) {
        float walkSpeed = 0.6f;
        float footOffset = PI / 4.0f;
        walkSpeedAdd[0] = MathHelper.func_76126_a((float)(f * 0.6f - footOffset)) * 0.5f;
        walkSpeedAdd[3] = MathHelper.func_76126_a((float)(f * 0.6f)) * 0.5f;
        walkSpeedAdd[2] = MathHelper.func_76126_a((float)(f * 0.6f - PI + footOffset)) * 0.5f;
        walkSpeedAdd[1] = MathHelper.func_76126_a((float)(f * 0.6f - PI - footOffset)) * 0.5f;
        walk1[0] = 0.2f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[0] - footOffset));
        walk1[3] = 0.2f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[3]));
        walk1[2] = 0.2f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[2] - PI + footOffset));
        walk1[1] = 0.2f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[1] - PI - footOffset));
        walk2[0] = -1.0f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[0] - footOffset - 1.4f));
        walk2[3] = -1.0f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[3] - 1.4f));
        walk2[2] = -1.0f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[2] - PI + footOffset - 1.4f));
        walk2[1] = -1.0f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[1] - PI - footOffset - 1.4f));
    }

    private void getWalkBackAnimations(float[] walk1, float[] walk2, float[] walkSpeedAdd, float f) {
        float walkSpeed = 0.6f;
        float footOffset = PI / 4.0f;
        walkSpeedAdd[2] = MathHelper.func_76126_a((float)(f * 0.6f - footOffset)) * 0.5f;
        walkSpeedAdd[0] = MathHelper.func_76126_a((float)(f * 0.6f)) * 0.5f;
        walkSpeedAdd[1] = MathHelper.func_76126_a((float)(f * 0.6f - PI + footOffset)) * 0.5f;
        walkSpeedAdd[3] = MathHelper.func_76126_a((float)(f * 0.6f - PI - footOffset)) * 0.5f;
        walk1[2] = 0.2f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[0] - footOffset));
        walk1[0] = 0.2f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[3]));
        walk1[1] = 0.2f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[2] - PI + footOffset));
        walk1[3] = 0.2f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[1] - PI - footOffset));
        walk2[2] = -1.0f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[0] - footOffset + 1.4f));
        walk2[0] = -1.0f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[3] + 1.4f));
        walk2[1] = -1.0f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[2] - PI + footOffset + 1.4f));
        walk2[3] = -1.0f + MathHelper.func_76126_a((float)(f * walkSpeed + walkSpeedAdd[1] - PI - footOffset + 1.4f));
    }

    private void getRunAnimations(float[] run1, float[] run2, float[] runSpeedAdd, float f) {
        float runSpeed = 0.8f;
        float footOffset = PI / 4.0f;
        runSpeedAdd[2] = -MathHelper.func_76126_a((float)(f * runSpeed)) * 0.4f;
        runSpeedAdd[3] = -MathHelper.func_76126_a((float)(f * runSpeed - footOffset)) * 0.4f;
        runSpeedAdd[0] = -MathHelper.func_76126_a((float)(f * runSpeed - PI / 2.0f + footOffset)) * 0.4f;
        runSpeedAdd[1] = -MathHelper.func_76126_a((float)(f * runSpeed - PI / 2.0f - footOffset)) * 0.4f;
        run1[2] = MathHelper.func_76126_a((float)(f * runSpeed + runSpeedAdd[2]));
        run1[3] = MathHelper.func_76126_a((float)(f * runSpeed + runSpeedAdd[3] - footOffset));
        run1[0] = 0.6f + MathHelper.func_76126_a((float)(f * runSpeed + runSpeedAdd[0] - PI / 2.0f + footOffset));
        run1[1] = 0.6f + MathHelper.func_76126_a((float)(f * runSpeed + runSpeedAdd[1] - PI / 2.0f - footOffset));
        run2[2] = -0.8f + MathHelper.func_76126_a((float)(f * runSpeed + runSpeedAdd[2] - 1.4f));
        run2[3] = -0.8f + MathHelper.func_76126_a((float)(f * runSpeed + runSpeedAdd[3] - footOffset - 1.4f));
        run2[0] = -1.2f + MathHelper.func_76126_a((float)(f * runSpeed + runSpeedAdd[0] - PI / 2.0f + footOffset - 1.4f));
        run2[1] = -1.2f + MathHelper.func_76126_a((float)(f * runSpeed + runSpeedAdd[1] - PI / 2.0f - footOffset - 1.4f));
    }

    public void animate(Horse horse, float f, float f1, float f2, float f3, float f4, float f5) {
        float scale;
        float partialTick = AnimationAPI.proxy.getPartialTick();
        float mouthOpen = horse.func_110201_q(partialTick);
        float[] walk1 = new float[4];
        float[] walk2 = new float[4];
        float[] walkSpeedAdd = new float[4];
        if (!horse.moveBackwards) {
            this.getWalkAnimations(walk1, walk2, walkSpeedAdd, f);
        } else {
            this.getWalkBackAnimations(walk1, walk2, walkSpeedAdd, f);
        }
        float[] run1 = new float[4];
        float[] run2 = new float[4];
        float[] runSpeedAdd = new float[4];
        this.getRunAnimations(run1, run2, runSpeedAdd, f);
        float breatheAnim = MathHelper.func_76134_b((float)(f2 * 0.11f));
        float breathe0 = MathHelper.func_76126_a((float)(f2 * 0.14f));
        float breathe1 = MathHelper.func_76126_a((float)(f2 * 0.14f - 1.0f));
        float breathe2 = MathHelper.func_76126_a((float)(f2 * 0.14f - 2.0f));
        float faceYaw = f3 * PI / 180.0f;
        float facePitch = f4 * PI / 180.0f;
        if (this.animator.setAnim(1)) {
            this.animateShakeTail(horse, partialTick);
        } else if (this.animator.setAnim(2)) {
            this.animateShakeHead();
            scale = 1.0f - MathHelper.func_76131_a((float)((float)horse.getAnimTick() / 4.0f), (float)0.0f, (float)1.0f);
            facePitch *= scale;
            faceYaw *= scale;
        } else if (this.animator.setAnim(3)) {
            this.animateEatGrass();
            scale = 1.0f - MathHelper.func_76131_a((float)((float)horse.getAnimTick() / 4.0f), (float)0.0f, (float)1.0f);
            facePitch *= scale;
            faceYaw *= scale;
        } else if (this.animator.setAnim(4)) {
            this.animateRearing(horse, partialTick);
            scale = 1.0f - MathHelper.func_76131_a((float)((float)horse.getAnimTick() / 4.0f), (float)0.0f, (float)1.0f);
            facePitch *= scale;
            faceYaw *= scale;
        }
        if (horse.field_70153_n != null && !horse.moveBackwards) {
            float runExp = (run1[2] + run1[3]) / 2.0f;
            runExp = runExp * runExp * runExp;
            float runS1 = MathHelper.func_76126_a((float)(f * 0.6f));
            float runS2 = MathHelper.func_76126_a((float)(f * 0.6f - 0.8f));
            float runS3 = MathHelper.func_76126_a((float)(f * 0.6f - 1.6f));
            this.body.field_78795_f += (0.03f + runExp * 0.03f) * f1;
            this.body.field_78797_d += runExp;
            this.head.field_78795_f -= (0.1f + runExp * 0.06f) * f1;
            this.neck.field_78795_f += (0.1f + runExp * 0.08f) * f1;
            this.mouthBottom.field_78798_e += 0.5f * f1;
            this.frontRightLeg.field_78795_f -= run1[0] * 0.8f * f1;
            this.frontLeftLeg.field_78795_f -= run1[1] * 0.8f * f1;
            this.backRightLeg.field_78795_f -= run1[2] * 0.9f * f1;
            this.backLeftLeg.field_78795_f -= run1[3] * 0.9f * f1;
            this.frontRightShin.field_78795_f -= run2[0] * 0.8f * f1;
            this.frontLeftShin.field_78795_f -= run2[1] * 0.8f * f1;
            this.backRightShin.field_78795_f -= run2[2] * 0.6f * f1;
            this.backLeftShin.field_78795_f -= run2[3] * 0.6f * f1;
            this.tailBase.field_78795_f -= (-0.7f + runS1 * 0.3f) * f1;
            this.tailMiddle.field_78795_f -= (-0.1f + runS2 * 0.3f) * f1;
            this.tailTip.field_78795_f -= (-0.1f + runS3 * 0.5f) * f1;
            this.rightChest.field_78795_f -= run1[3] * run1[3] * 0.4f * f1;
            this.leftChest.field_78795_f += run1[2] * run1[2] * 0.4f * f1;
            this.rightSaddleRope.field_78795_f += (0.2f + run2[3] * run2[3] * 0.15f) * f1;
            this.leftSaddleRope.field_78795_f += (0.2f + run2[2] * run2[2] * 0.15f) * f1;
        } else {
            float walkAvg;
            float walkExp = walkAvg = (walk1[0] + walk1[1]) / 2.0f;
            walkExp = 1.0f - walkExp;
            walkExp *= walkExp;
            walkExp *= walkExp;
            walkExp = 1.0f - walkExp;
            float walkS1 = MathHelper.func_76126_a((float)(f * 0.4f));
            float walkS2 = MathHelper.func_76126_a((float)(f * 0.4f - 0.8f));
            float walkS3 = MathHelper.func_76126_a((float)(f * 0.4f - 1.6f));
            this.body.field_78795_f += (0.02f + walkAvg * 0.02f) * f1;
            this.neck.field_78795_f += walkExp * 0.2f * f1;
            this.frontRightLeg.field_78795_f -= walk1[0] * 0.8f * f1;
            this.frontLeftLeg.field_78795_f -= walk1[1] * 0.8f * f1;
            this.backRightLeg.field_78795_f -= walk1[2] * 0.8f * f1;
            this.backLeftLeg.field_78795_f -= walk1[3] * 0.8f * f1;
            this.frontRightShin.field_78795_f -= walk2[0] * 0.5f * f1;
            this.frontLeftShin.field_78795_f -= walk2[1] * 0.5f * f1;
            this.backRightShin.field_78795_f -= walk2[2] * 0.5f * f1;
            this.backLeftShin.field_78795_f -= walk2[3] * 0.5f * f1;
            this.tailBase.field_78795_f -= (-0.0f + walkS1 * 0.2f) * f1;
            this.tailMiddle.field_78795_f -= (-0.1f + walkS2 * 0.3f) * f1;
            this.tailTip.field_78795_f -= (-0.1f + walkS3 * 0.5f) * f1;
        }
        if (horse.inAir()) {
            float air = ((float)horse.prevAirTick + (float)(horse.airTick - horse.prevAirTick) * partialTick) / 6.0f;
            float invAir = 1.0f - air;
            this.frontRightLeg.field_78795_f *= invAir;
            this.frontLeftLeg.field_78795_f *= invAir;
            this.backRightLeg.field_78795_f *= invAir;
            this.backLeftLeg.field_78795_f *= invAir;
            this.frontRightShin.field_78795_f *= invAir;
            this.frontLeftShin.field_78795_f *= invAir;
            this.backRightShin.field_78795_f *= invAir;
            this.backLeftShin.field_78795_f *= invAir;
            this.frontRightLeg.field_78795_f += -PI / 3.0f * air;
            this.frontLeftLeg.field_78795_f += -PI / 3.0f * air;
            this.backRightLeg.field_78795_f += PI / 3.0f * air;
            this.backLeftLeg.field_78795_f += PI / 3.0f * air;
            this.frontRightShin.field_78795_f += PI / 7.0f * air;
            this.frontLeftShin.field_78795_f += PI / 7.0f * air;
            this.backRightShin.field_78795_f += PI / 7.0f * air;
            this.backLeftShin.field_78795_f += PI / 7.0f * air;
        }
        this.mouthBottom.field_78795_f += mouthOpen * 0.2f;
        this.mouthBottom.field_78795_f += Math.max(0.0f, breatheAnim * 0.05f);
        this.head.field_78795_f -= breatheAnim * 0.015f;
        this.neck.field_78795_f -= breatheAnim * 0.015f;
        this.tailBase.field_78796_g += breathe0 * 0.06f;
        this.tailMiddle.field_78796_g += breathe1 * 0.1f;
        this.tailTip.field_78796_g += breathe2 * 0.15f;
        if (faceYaw < -1.0f) {
            faceYaw = -1.0f;
        }
        if (faceYaw > 1.0f) {
            faceYaw = 1.0f;
        }
        this.head.field_78796_g += (faceYaw *= 0.2f) * 0.4f;
        this.head.field_78808_h -= faceYaw * 0.4f;
        this.neck.field_78796_g += faceYaw * 0.6f;
        this.neck.field_78808_h -= faceYaw * 0.6f;
        this.head.field_78795_f += (facePitch *= 0.4f) * 0.4f;
        this.neck.field_78795_f += facePitch * 0.6f;
        if (facePitch < 0.0f) {
            this.mouthBottom.field_78798_e -= Math.min(1.0f, facePitch * 5.0f / PI);
        }
    }

    private float updateRotation(float angle, float target, float offset) {
        float f3;
        for (f3 = target - angle; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return angle + offset * f3;
    }

    protected void animateShakeTail(Horse horse, float partialTick) {
        int animTick = horse.getAnimTick();
        if (animTick < 2) {
            float tick = ((float)animTick + partialTick) / 2.0f;
            float f = MathHelper.func_76126_a((float)(tick * PI / 2.0f));
            float f1 = MathHelper.func_76126_a((float)(tick * PI / 2.0f - 0.8f));
            float f2 = MathHelper.func_76126_a((float)(tick * PI / 2.0f - 1.6f));
            this.tailBase.field_78795_f += f * 0.8f;
            this.tailMiddle.field_78795_f += f1 * 0.8f;
            this.tailTip.field_78795_f += f2 * 1.2f;
        } else if (animTick < 10) {
            float tick = ((float)(animTick - 2) + partialTick) / 8.0f;
            float f = MathHelper.func_76126_a((float)(PI / 2.0f + tick * PI * 3.0f / 2.0f));
            float f1 = MathHelper.func_76134_b((float)(tick * PI - 0.8f));
            float f2 = MathHelper.func_76134_b((float)(tick * PI - 1.6f));
            float scale = 1.0f;
            if (animTick >= 6) {
                scale = (10.0f - (float)animTick - partialTick) / 4.0f;
            }
            this.tailBase.field_78795_f += f * 0.8f * scale;
            this.tailMiddle.field_78795_f += f1 * 0.8f * scale;
            this.tailTip.field_78795_f += f2 * 1.2f * scale;
        }
    }

    protected void animateShakeHead() {
        this.animator.startPhase(2);
        this.animator.rotate(this.head, -PI / 10.0f, 0.0f, 0.0f);
        this.animator.rotate(((ModelJoint)this.neck).getModel(), 0.0f, -PI / 8.0f, 0.0f);
        this.animator.move(this.mouthBottom, 0.0f, 0.0f, 0.4f);
        this.animator.endPhase();
        this.animator.startPhase(2);
        this.animator.rotate(this.head, -PI / 8.0f, 0.0f, 0.0f);
        this.animator.rotate(((ModelJoint)this.neck).getModel(), 0.0f, PI / 8.0f, 0.0f);
        this.animator.move(this.mouthBottom, 0.0f, 0.0f, 0.6f);
        this.animator.endPhase();
        this.animator.startPhase(2);
        this.animator.rotate(this.head, -PI / 7.5f, 0.0f, 0.0f);
        this.animator.rotate(((ModelJoint)this.neck).getModel(), 0.0f, -PI / 8.0f, 0.0f);
        this.animator.move(this.mouthBottom, 0.0f, 0.0f, 0.7f);
        this.animator.endPhase();
        this.animator.startPhase(2);
        this.animator.rotate(this.head, -PI / 7.0f, 0.0f, 0.0f);
        this.animator.rotate(((ModelJoint)this.neck).getModel(), 0.0f, PI / 8.0f, 0.0f);
        this.animator.move(this.mouthBottom, 0.0f, 0.0f, 0.8f);
        this.animator.endPhase();
        this.animator.startPhase(2);
        this.animator.rotate(this.head, -PI / 7.0f, 0.0f, 0.0f);
        this.animator.rotate(((ModelJoint)this.neck).getModel(), 0.0f, -PI / 8.0f, 0.0f);
        this.animator.move(this.mouthBottom, 0.0f, 0.0f, 0.8f);
        this.animator.endPhase();
        this.animator.startPhase(2);
        this.animator.rotate(this.head, -PI / 7.0f, 0.0f, 0.0f);
        this.animator.rotate(((ModelJoint)this.neck).getModel(), 0.0f, PI / 8.0f, 0.0f);
        this.animator.move(this.mouthBottom, 0.0f, 0.0f, 0.8f);
        this.animator.endPhase();
        this.animator.resetPhase(3);
    }

    protected void animateEatGrass() {
        this.animator.startPhase(10);
        this.animator.rotate(this.head, -PI / 6.0f, 0.0f, 0.0f);
        this.animator.rotate(this.neck, PI / 1.9f, 0.0f, 0.0f);
        this.animator.move(this.mouthBottom, 0.0f, 0.0f, 0.5f);
        this.animator.endPhase();
        for (int i = 0; i < 4; ++i) {
            this.animator.startPhase(4);
            this.animator.rotate(this.head, -PI / 5.5f, 0.0f, 0.0f);
            this.animator.rotate(this.neck, PI / 1.9f - PI / 64.0f, 0.0f, 0.0f);
            this.animator.rotate(this.mouthBottom, PI / 16.0f, 0.0f, 0.0f);
            this.animator.move(this.mouthBottom, 0.0f, 0.0f, 0.5f);
            this.animator.endPhase();
            this.animator.startPhase(4);
            this.animator.rotate(this.head, -PI / 6.0f, 0.0f, 0.0f);
            this.animator.rotate(this.neck, PI / 1.9f, 0.0f, 0.0f);
            this.animator.move(this.mouthBottom, 0.0f, 0.0f, 0.5f);
            this.animator.endPhase();
        }
        this.animator.resetPhase(8);
    }

    protected void animateRearing(Horse horse, float partialTick) {
        this.animator.startPhase(1);
        this.animator.rotate(this.head, -PI / 14.0f, 0.0f, 0.0f);
        this.animator.rotate(this.neck, -PI / 8.0f, 0.0f, 0.0f);
        this.animator.rotate(this.body, PI / 32.0f, 0.0f, 0.0f);
        this.animator.rotate(this.frontRightLeg, -PI / 8.0f, 0.0f, 0.0f);
        this.animator.rotate(this.frontLeftLeg, -PI / 8.0f, 0.0f, 0.0f);
        this.animator.rotate(this.frontRightShin, PI / 8.0f, 0.0f, 0.0f);
        this.animator.rotate(this.frontLeftShin, PI / 8.0f, 0.0f, 0.0f);
        this.animator.move(this.mouthBottom, 0.0f, 0.0f, 0.4f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(1);
        this.animator.startPhase(6);
        this.animator.rotate(this.head, PI / 14.0f, 0.0f, 0.0f);
        this.animator.rotate(this.neck, PI / 12.0f, 0.0f, 0.0f);
        this.animator.rotate(this.body, -PI / 3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.frontRightLeg, -PI / 14.0f, 0.0f, 0.0f);
        this.animator.rotate(this.frontLeftLeg, -PI / 14.0f, 0.0f, 0.0f);
        this.animator.rotate(this.frontRightShin, PI / 4.5f, 0.0f, 0.0f);
        this.animator.rotate(this.frontLeftShin, PI / 4.5f, 0.0f, 0.0f);
        this.animator.rotate(this.backRightLeg, PI / 3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.backLeftLeg, PI / 3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.tailBase, PI / 3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.rightSaddleRope, PI / 3.0f, 0.0f, 0.0f);
        this.animator.rotate(this.leftSaddleRope, PI / 3.0f, 0.0f, 0.0f);
        this.animator.move(this.body, 0.0f, -4.8f, 0.0f);
        this.animator.endPhase();
        this.animator.setStationaryPhase(18);
        this.animator.resetPhase(6);
        if (horse.getAnimTick() >= 4 && horse.getAnimTick() < 30) {
            float tick = ((float)(horse.getAnimTick() - 4) + partialTick) / 26.0f;
            float f = MathHelper.func_76126_a((float)(tick * PI * 2.0f * 2.5f));
            float f1 = MathHelper.func_76126_a((float)(tick * PI * 2.0f * 2.5f + PI));
            float f2 = MathHelper.func_76126_a((float)(tick * PI * 2.0f * 2.5f - 1.4f));
            float f3 = MathHelper.func_76126_a((float)(tick * PI * 2.0f * 2.5f + PI - 1.4f));
            float f4 = MathHelper.func_76126_a((float)(tick * PI));
            float scale = Math.min(1.0f, ((float)(horse.getAnimTick() - 4) + partialTick) / 4.0f);
            scale = Math.min(scale, ((float)(30 - horse.getAnimTick()) - partialTick) / 4.0f);
            this.body.field_78795_f -= f4 * 0.06f * scale;
            this.frontRightLeg.field_78795_f += f * 0.8f * scale;
            this.frontLeftLeg.field_78795_f += f1 * 0.8f * scale;
            this.frontRightShin.field_78795_f += f2 * 0.4f * scale;
            this.frontLeftShin.field_78795_f += f3 * 0.4f * scale;
        }
    }
}

