/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.block;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.block.BlockDecoration;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnderLily
extends BlockCrops {
    public static final long period_fast = 3700L;
    public static final long period = 24000L;
    public static final long period_grass = 96000L;

    public BlockEnderLily() {
        this.func_149658_d("extrautils:plant/ender_lilly");
        this.func_149663_c("extrautils:plant/ender_lilly");
        this.func_149647_a(ExtraUtils.creativeTabExtraUtils);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return super.func_149718_j(world, x, y, z) || this.canBePlantedHere(world, x, y, z);
    }

    protected void func_149855_e(World p_149855_1_, int p_149855_2_, int p_149855_3_, int p_149855_4_) {
        if (!this.func_149718_j(p_149855_1_, p_149855_2_, p_149855_3_, p_149855_4_) && !this.isEndStone(p_149855_1_, p_149855_2_, p_149855_3_ - 1, p_149855_4_)) {
            this.func_149697_b(p_149855_1_, p_149855_2_, p_149855_3_, p_149855_4_, p_149855_1_.func_72805_g(p_149855_2_, p_149855_3_, p_149855_4_), 0);
            p_149855_1_.func_147465_d(p_149855_2_, p_149855_3_, p_149855_4_, BlockEnderLily.func_149729_e((int)0), 0, 2);
        }
    }

    public int func_149645_b() {
        return 1;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return !(entity instanceof EntityDragon);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (par5EntityPlayer.field_71075_bZ.field_75098_d && par5EntityPlayer.func_71045_bC() == null && par5EntityPlayer.func_70093_af()) {
            if (world.field_72995_K) {
                return true;
            }
            world.func_72921_c(x, y, z, (world.func_72805_g(x, y, z) + 1) % 8, 2);
        }
        return false;
    }

    public boolean canBePlantedHere(World world, int x, int y, int z) {
        return world.func_147437_c(x, y, z) && (this.canThisPlantGrowOnThisBlockID(world.func_147439_a(x, y - 1, z)) || this.isEndStone(world, x, y - 1, z) || this.isSuperEndStone(world, x, y - 1, z));
    }

    protected boolean canThisPlantGrowOnThisBlockID(Block par1) {
        return par1 == Blocks.field_150349_c || par1 == Blocks.field_150346_d || par1 == Blocks.field_150377_bs || par1 == Blocks.field_150458_ak;
    }

    public boolean isSuperEndStone(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        return id instanceof BlockDecoration && ((BlockDecoration)id).isEnder[world.func_72805_g(x, y, z)];
    }

    public boolean isEndStone(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        return id == Blocks.field_150377_bs;
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        this.func_149855_e(par1World, par2, par3, par4);
        int l = par1World.func_72805_g(par2, par3, par4);
        if (l < 7) {
            if (this.isSuperEndStone(par1World, par2, par3 - 1, par4)) {
                if (par5Random.nextInt(20) == 0) {
                    par1World.func_72921_c(par2, par3, par4, ++l, 2);
                }
            } else if (this.isEndStone(par1World, par2, par3 - 1, par4)) {
                if (l % 2 == 0 == par1World.func_72820_D() % 48000L < 24000L && par5Random.nextInt(10) == 0) {
                    par1World.func_72921_c(par2, par3, par4, ++l, 2);
                }
            } else if (l % 2 == 0 == par1World.func_72820_D() % 192000L < 96000L && par5Random.nextInt(40) == 0) {
                par1World.func_72921_c(par2, par3, par4, ++l, 2);
            }
        }
    }

    public void func_149734_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par5Random.nextInt(5) != 0 || par1World.func_72805_g(par2, par3, par4) < 7) {
            return;
        }
        double d0 = (float)par2 + par5Random.nextFloat();
        double d1 = (float)par3 + par5Random.nextFloat();
        d0 = (float)par4 + par5Random.nextFloat();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int i1 = par5Random.nextInt(2) * 2 - 1;
        int j1 = par5Random.nextInt(2) * 2 - 1;
        d2 = ((double)par5Random.nextFloat() - 0.5) * 0.125;
        d3 = ((double)par5Random.nextFloat() - 0.5) * 0.125;
        d4 = ((double)par5Random.nextFloat() - 0.5) * 0.125;
        double d5 = (double)par4 + 0.5 + 0.25 * (double)j1;
        d4 = par5Random.nextFloat() * 1.0f * (float)j1;
        double d6 = (double)par2 + 0.5 + 0.25 * (double)i1;
        d2 = par5Random.nextFloat() * 1.0f * (float)i1;
        par1World.func_72869_a("portal", d6, d1, d5, d2, d3, d4);
    }

    public void func_149670_a(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        if (par1World.func_72805_g(par2, par3, par4) >= 3) {
            if (par5Entity instanceof EntityItem) {
                ItemStack item = ((EntityItem)par5Entity).func_92059_d();
                if (item != null && (item.func_77973_b() == this.getSeedItem() || item.func_77973_b() == this.getCropItem())) {
                    return;
                }
                if (par1World.field_72995_K) {
                    par1World.func_72869_a("crit", par5Entity.field_70165_t, par5Entity.field_70163_u, par5Entity.field_70161_v, 0.0, 0.0, 0.0);
                }
            }
            if (par5Entity instanceof EntityEnderman) {
                return;
            }
            par5Entity.func_70097_a(DamageSource.field_76367_g, 0.1f);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(this.getSeedItem(), 1, 0));
        if (metadata >= 7) {
            ret.add(new ItemStack(this.getCropItem(), 1, 0));
            if (this.isEndStone(world, x, y - 1, z) && world.field_73012_v.nextInt(50) == 0) {
                ret.add(new ItemStack(this.getSeedItem(), 1, 0));
            }
            if (this.isSuperEndStone(world, x, y - 1, z) && world.field_73012_v.nextInt(10) == 0) {
                ret.add(new ItemStack(this.getSeedItem(), 1, 0));
            }
        }
        return ret;
    }

    public void func_149863_m(World par1World, int par2, int par3, int par4) {
        int l = par1World.func_72805_g(par2, par3, par4);
        if (l == 0) {
            par1World.func_147480_a(par2, par3, par4, true);
        } else {
            if ((l -= MathHelper.func_76136_a((Random)par1World.field_73012_v, (int)1, (int)5)) < 0) {
                l = 0;
            }
            par1World.func_72921_c(par2, par3, par4, l, 2);
        }
    }

    protected Item getSeedItem() {
        return Item.func_150898_a((Block)this);
    }

    protected Item getCropItem() {
        return Items.field_151079_bi;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_149702_O() {
        return "extrautils:ender_lilly_seed";
    }
}

