/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.block;

import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class Box {
    public float minX;
    public float minY;
    public float minZ;
    public float maxX;
    public float maxY;
    public float maxZ;
    public int offsetx = 0;
    public int offsety = 0;
    public int offsetz = 0;
    public String label = "";
    public IIcon texture = null;
    public IIcon[] textureSide = new IIcon[6];
    public boolean invisible = false;
    public boolean renderAsNormalBlock = false;
    public boolean[] invisibleSide = new boolean[6];
    public int uvRotateEast = 0;
    public int uvRotateWest = 0;
    public int uvRotateSouth = 0;
    public int uvRotateNorth = 0;
    public int uvRotateTop = 0;
    public int uvRotateBottom = 0;
    public int color = 0xFFFFFF;
    public int[] rotAdd = new int[]{0, 1, 2, 3};

    public Box(String l, float par1, float par3, float par5, float par7, float par9, float par11) {
        this.label = l;
        this.minX = Math.min(par1, par7);
        this.minY = Math.min(par3, par9);
        this.minZ = Math.min(par5, par11);
        this.maxX = Math.max(par1, par7);
        this.maxY = Math.max(par3, par9);
        this.maxZ = Math.max(par5, par11);
    }

    public Box(float par1, float par3, float par5, float par7, float par9, float par11) {
        this("", par1, par3, par5, par7, par9, par11);
    }

    public Box setTextures(IIcon[] icons) {
        for (int i = 0; i < 6 && i < icons.length; ++i) {
            this.textureSide[i] = icons[i];
        }
        return this;
    }

    public Box setTextureSides(Object ... tex) {
        this.textureSide = new IIcon[6];
        int s = 0;
        for (Object aTex : tex) {
            if (aTex instanceof Integer) {
                s = (Integer)aTex;
                continue;
            }
            if (!(aTex instanceof IIcon) || s >= 6 || s < 0) continue;
            this.textureSide[s] = (IIcon)aTex;
            ++s;
        }
        return this;
    }

    public Box setColor(int col) {
        this.color = col;
        return this;
    }

    public Box setAllSideInvisible() {
        for (int i = 0; i < 6; ++i) {
            this.invisibleSide[i] = true;
        }
        return this;
    }

    public Box setSideInvisible(Object ... tex) {
        int s = 0;
        for (Object aTex : tex) {
            if (aTex instanceof Integer) {
                s = (Integer)aTex;
                this.invisibleSide[s] = true;
                continue;
            }
            if (!(aTex instanceof Boolean)) continue;
            this.invisibleSide[s] = (Boolean)aTex;
            ++s;
        }
        return this;
    }

    public Box setTexture(IIcon l) {
        this.texture = l;
        return this;
    }

    public Box setLabel(String l) {
        this.label = l;
        return this;
    }

    public Box copy() {
        return new Box(this.label, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public void setBounds(float par1, float par3, float par5, float par7, float par9, float par11) {
        this.minX = Math.min(par1, par7);
        this.minY = Math.min(par3, par9);
        this.minZ = Math.min(par5, par11);
        this.maxX = Math.max(par1, par7);
        this.maxY = Math.max(par3, par9);
        this.maxZ = Math.max(par5, par11);
    }

    public Box offset(float x, float y, float z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this;
    }

    public Box rotateY(int numRotations) {
        if (numRotations == 0) {
            return this;
        }
        if (numRotations < 0) {
            numRotations += 4;
        }
        for (int i = 0; i < numRotations; ++i) {
            Box prev = this.copy();
            this.minZ = prev.minX;
            this.maxZ = prev.maxX;
            this.minX = 1.0f - prev.maxZ;
            this.maxX = 1.0f - prev.minZ;
            IIcon temp = this.textureSide[2];
            this.textureSide[2] = this.textureSide[4];
            this.textureSide[4] = this.textureSide[3];
            this.textureSide[3] = this.textureSide[5];
            this.textureSide[5] = temp;
        }
        this.uvRotateTop = (this.uvRotateTop + this.rotAdd[numRotations]) % 2;
        this.uvRotateBottom = (this.uvRotateBottom + this.rotAdd[numRotations]) % 2;
        return this;
    }

    public Box rotateToSide(ForgeDirection dir) {
        Box prev = this.copy();
        switch (dir) {
            case DOWN: {
                break;
            }
            case UP: {
                this.minY = 1.0f - prev.maxY;
                this.maxY = 1.0f - prev.minY;
                break;
            }
            case NORTH: {
                this.minZ = prev.minY;
                this.maxZ = prev.maxY;
                this.minY = prev.minX;
                this.maxY = prev.maxX;
                this.minX = prev.minZ;
                this.maxX = prev.maxZ;
                break;
            }
            case SOUTH: {
                this.minZ = 1.0f - prev.maxY;
                this.maxZ = 1.0f - prev.minY;
                this.minY = prev.minX;
                this.maxY = prev.maxX;
                this.minX = 1.0f - prev.maxZ;
                this.maxX = 1.0f - prev.minZ;
                break;
            }
            case WEST: {
                this.minX = prev.minY;
                this.maxX = prev.maxY;
                this.minY = prev.minX;
                this.maxY = prev.maxX;
                this.minZ = 1.0f - prev.maxZ;
                this.maxZ = 1.0f - prev.minZ;
                break;
            }
            case EAST: {
                this.minX = 1.0f - prev.maxY;
                this.maxX = 1.0f - prev.minY;
                this.minY = prev.minX;
                this.maxY = prev.maxX;
                break;
            }
        }
        return this;
    }
}

