/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.block;

import com.rwtema.extrautils.block.Box;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.util.ForgeDirection;

public class BoxModel
extends ArrayList<Box> {
    public int invModelRotate = 90;
    public String label = "";

    public BoxModel() {
    }

    public BoxModel(Box newBox) {
        this.add(newBox);
    }

    public BoxModel(float par1, float par3, float par5, float par7, float par9, float par11) {
        this.add(new Box(par1, par3, par5, par7, par9, par11));
    }

    public static BoxModel newStandardBlock() {
        Box t = new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        t.renderAsNormalBlock = true;
        return new BoxModel(t);
    }

    public static BoxModel hollowBox(float minX, float minY, float minZ, float holeMinX, float holeMinZ, float holeMaxX, float holeMaxZ, float maxX, float maxY, float maxZ) {
        BoxModel t = new BoxModel();
        t.add(new Box(minX, minY, minZ, holeMinX, maxY, maxZ));
        t.add(new Box(holeMinX, minY, minZ, holeMaxX, maxY, holeMinZ));
        t.add(new Box(holeMinX, minY, holeMaxZ, holeMaxX, maxY, maxZ));
        t.add(new Box(holeMaxX, minY, minZ, maxX, maxY, maxZ));
        return t;
    }

    public static Box boundingBox(List models) {
        if (models == null) {
            return null;
        }
        if (models.size() == 0) {
            return null;
        }
        Box bounds = ((Box)models.get(0)).copy();
        for (int i = 1; i < models.size(); ++i) {
            bounds.setBounds(Math.min(bounds.minX, ((Box)models.get((int)i)).minX), Math.min(bounds.minY, ((Box)models.get((int)i)).minY), Math.min(bounds.minZ, ((Box)models.get((int)i)).minZ), Math.max(bounds.maxX, ((Box)models.get((int)i)).maxX), Math.max(bounds.maxY, ((Box)models.get((int)i)).maxY), Math.max(bounds.maxZ, ((Box)models.get((int)i)).maxZ));
        }
        return bounds;
    }

    public Box addBoxI(int par1, int par3, int par5, int par7, int par9, int par11) {
        return this.addBox("", (float)par1 / 16.0f, (float)par3 / 16.0f, (float)par5 / 16.0f, (float)par7 / 16.0f, (float)par9 / 16.0f, (float)par11 / 16.0f);
    }

    public Box addBox(float par1, float par3, float par5, float par7, float par9, float par11) {
        return this.addBox("", par1, par3, par5, par7, par9, par11);
    }

    public Box addBox(String l, float par1, float par3, float par5, float par7, float par9, float par11) {
        Box b = new Box(l, par1, par3, par5, par7, par9, par11);
        this.add(b);
        return b;
    }

    public BoxModel rotateToSide(ForgeDirection dir) {
        for (Box box : this) {
            box.rotateToSide(dir);
        }
        return this;
    }

    public BoxModel rotateY(int numRotations) {
        for (Box box : this) {
            box.rotateY(numRotations);
        }
        return this;
    }

    public BoxModel offset(float x, float y, float z) {
        for (Box box : this) {
            box.offset(x, y, z);
        }
        return this;
    }

    public BoxModel setColor(int col) {
        for (Box box : this) {
            box.setColor(col);
        }
        return this;
    }

    public BoxModel addYRotations() {
        this.addAll(this.copy().rotateY(1));
        this.addAll(this.copy().rotateY(2));
        return this;
    }

    public Box boundingBox() {
        return BoxModel.boundingBox(this);
    }

    public BoxModel copy() {
        BoxModel newModel = new BoxModel();
        for (int i = 0; i < this.size(); ++i) {
            newModel.add(((Box)this.get(i)).copy());
        }
        return newModel;
    }
}

