/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.dynamicgui;

import cofh.api.energy.IEnergyHandler;
import com.rwtema.extrautils.XUHelperClient;
import com.rwtema.extrautils.dynamicgui.DynamicContainer;
import com.rwtema.extrautils.dynamicgui.DynamicGui;
import com.rwtema.extrautils.dynamicgui.IWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class WidgetEnergy
implements IWidget {
    int curEnergy;
    int curMax;
    IEnergyHandler tile;
    ForgeDirection dir;
    int x;
    int y;

    public WidgetEnergy(IEnergyHandler tile, ForgeDirection dir, int x, int y) {
        this.dir = dir;
        this.tile = tile;
        this.x = x;
        this.y = y;
        this.curEnergy = 0;
        this.curMax = 0;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getW() {
        return 18;
    }

    @Override
    public int getH() {
        return 53;
    }

    @Override
    public NBTTagCompound getDescriptionPacket(boolean changesOnly) {
        NBTTagCompound tag = null;
        if (!changesOnly || this.curEnergy != this.tile.getEnergyStored(this.dir)) {
            tag = new NBTTagCompound();
            tag.func_74768_a("cur", this.tile.getEnergyStored(this.dir));
        }
        if (!changesOnly || this.curMax != this.tile.getMaxEnergyStored(this.dir)) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74768_a("max", this.tile.getMaxEnergyStored(this.dir));
        }
        this.curEnergy = this.tile.getEnergyStored(this.dir);
        this.curMax = this.tile.getMaxEnergyStored(this.dir);
        return tag;
    }

    @Override
    public void handleDescriptionPacket(NBTTagCompound packet) {
        if (packet.func_74764_b("cur")) {
            this.curEnergy = packet.func_74762_e("cur");
        }
        if (packet.func_74764_b("max")) {
            this.curMax = packet.func_74762_e("max");
        }
    }

    @Override
    public NBTTagCompound getPlayerInputPacket() {
        return null;
    }

    @Override
    public void handlePlayerInputPacket(NBTTagCompound packet) {
    }

    @Override
    public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
    }

    @Override
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        manager.func_110577_a(gui.getWidgets());
        int y = 0;
        if (this.curMax > 0 && this.curEnergy > 0 && (y = 54 * this.curEnergy / this.curMax) < 0) {
            y = 0;
        }
        gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 160, 0, 18, 54 - y);
        gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY() + 54 - y, 178, 54 - y, 18, y);
    }

    @Override
    public void addToContainer(DynamicContainer container) {
    }

    @Override
    public List<String> getToolTip() {
        if (this.curMax > 0) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(XUHelperClient.commaDelimited(this.curEnergy) + " / " + XUHelperClient.commaDelimited(this.curMax) + " RF");
            return l;
        }
        return null;
    }
}

