/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.item;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.damgesource.DamageSourceDivByZero;
import com.rwtema.extrautils.item.IItemMultiTransparency;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemUnstableIngot
extends Item
implements IItemMultiTransparency {
    public static final int numTickstilDestruction = 200;
    private IIcon[] iconIngot = new IIcon[2];
    private IIcon[] iconNugget = new IIcon[2];

    public ItemUnstableIngot() {
        this.func_77637_a(ExtraUtils.creativeTabExtraUtils);
        this.field_77777_bU = 1;
        this.func_77655_b("extrautils:unstableingot");
        this.func_77627_a(true);
    }

    public int getItemStackLimit(ItemStack item) {
        if (item != null) {
            if (item.func_77973_b() == ExtraUtils.unstableIngot && item.func_77960_j() == 0 && item.func_77942_o()) {
                if (!item.func_77978_p().func_74764_b("stable")) {
                    return 1;
                }
                if (item.func_77978_p().func_74764_b("time")) {
                    return 1;
                }
            }
            return 64;
        }
        return this.func_77639_j();
    }

    public static void explode(EntityPlayer player) {
        ItemUnstableIngot.stripPlayerOfIngots(player);
        if (ExtraUtils.unstableIngotExplosion) {
            player.field_70170_p.func_72876_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, false);
            player.func_70097_a((DamageSource)DamageSourceDivByZero.divbyzero, 32767.0f);
        }
    }

    public static void stripPlayerOfIngots(EntityPlayer player) {
        if (player != null && player.field_71071_by != null) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack item = player.field_71071_by.func_70301_a(i);
                if (item == null || item.func_77973_b() != ExtraUtils.unstableIngot || !item.func_77942_o() || !item.func_77978_p().func_74764_b("crafting") && !item.func_77978_p().func_74764_b("time")) continue;
                player.field_71071_by.func_70299_a(i, null);
            }
            ItemStack item = player.field_71071_by.func_70445_o();
            if (item != null && item.func_77973_b() == ExtraUtils.unstableIngot && item.func_77960_j() == 0 && item.func_77942_o() && (item.func_77978_p().func_74764_b("crafting") || item.func_77978_p().func_74764_b("time"))) {
                player.field_71071_by.func_70437_b(null);
            }
            player.field_71071_by.func_70296_d();
            ItemUnstableIngot.updatePlayer((Entity)player);
        }
    }

    public static void updatePlayer(Entity player) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71133_b.func_71203_ab().func_72385_f((EntityPlayerMP)player);
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77658_a() + "." + par1ItemStack.func_77960_j();
    }

    public void func_77663_a(ItemStack item, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (item.field_77994_a == 0) {
            return;
        }
        if (par2World.field_72995_K) {
            return;
        }
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)par3Entity;
        if (item.func_77960_j() > 0) {
            return;
        }
        if (item.func_77942_o()) {
            boolean deleteIngot = false;
            boolean explode = false;
            if (item.func_77978_p().func_74764_b("creative") || item.func_77978_p().func_74764_b("stable")) {
                return;
            }
            if (item.func_77978_p().func_74764_b("bug")) {
                item.func_77978_p().func_82580_o("bug");
                item.func_77978_p().func_74757_a("bug_show", true);
                return;
            }
            if (item.func_77978_p().func_74764_b("crafting") && player.field_71070_bA != null) {
                if (player.field_71070_bA.getClass() != ContainerPlayer.class) {
                    this.addTimeStamp(item, par2World);
                    return;
                }
                ItemUnstableIngot.stripPlayerOfIngots(player);
                return;
            }
            if (player.field_71070_bA != null && player.field_71070_bA.getClass() == ContainerPlayer.class) {
                ItemUnstableIngot.explode(player);
            }
            if (item.func_77978_p().func_74764_b("time") && item.func_77978_p().func_74764_b("dimension")) {
                float t = (float)(200L - (par2World.func_82737_E() - item.func_77978_p().func_74763_f("time"))) / 20.0f;
                if (par3Entity.field_70170_p.field_73011_w.field_76574_g != item.func_77978_p().func_74762_e("dimension") | t < 0.0f) {
                    if (par3Entity.field_70170_p.field_73011_w.field_76574_g == item.func_77978_p().func_74762_e("dimension")) {
                        ItemUnstableIngot.explode(player);
                    } else {
                        ItemUnstableIngot.stripPlayerOfIngots(player);
                    }
                }
            }
        }
    }

    public void addTimeStamp(ItemStack item, World world) {
        NBTTagCompound ts = new NBTTagCompound();
        if (ts.func_74764_b("crafting")) {
            ts.func_82580_o("crafting");
        }
        if (item.func_77960_j() > 0) {
            return;
        }
        ts.func_74768_a("dimension", world.field_73011_w.field_76574_g);
        ts.func_74772_a("time", world.func_82737_E());
        item.func_77982_d(ts);
    }

    public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("stable")) {
            return;
        }
        if (par1ItemStack.func_77960_j() > 0) {
            return;
        }
        this.addTimeStamp(par1ItemStack, par2World);
        if (!par2World.field_72995_K) {
            ItemUnstableIngot.updatePlayer((Entity)par3EntityPlayer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack.func_77960_j() > 0) {
            return;
        }
        if (par1ItemStack.func_77942_o() && !par1ItemStack.func_77978_p().func_74764_b("crafting") && !par1ItemStack.func_77978_p().func_74764_b("creative") && !par1ItemStack.func_77978_p().func_74764_b("bug")) {
            if (par1ItemStack.func_77978_p().func_74764_b("stable")) {
                par3List.add("Stable");
                return;
            }
            if (par1ItemStack.func_77978_p().func_74764_b("dimension") && par2EntityPlayer.field_70170_p.field_73011_w.field_76574_g == par1ItemStack.func_77978_p().func_74762_e("dimension")) {
                float t = (float)(200L - (par2EntityPlayer.field_70170_p.func_82737_E() - par1ItemStack.func_77978_p().func_74763_f("time"))) / 20.0f;
                if (t < 0.0f) {
                    t = 0.0f;
                }
                par3List.add("Explodes in " + String.format(Locale.ENGLISH, "%.1f", Float.valueOf(t)) + " seconds");
            } else if (par1ItemStack.func_77978_p().func_74764_b("bug_show")) {
                par3List.add("This ingot was created incorrectly");
                par3List.add("using getRecipeOutput() instead of getCraftingResult()");
                par3List.add("if this ingot was made legitimately please");
                par3List.add("report this to the mod developer.");
                par3List.add("(don't spam them though - check to see if");
                par3List.add("it hasn't already been reported)");
            }
        } else {
            par3List.add("ERROR: Divide by diamond");
            par3List.add("This ingot is highly unstable and will explode");
            par3List.add("after 10 seconds.");
            par3List.add("Will also explode if the crafting window is closed");
            par3List.add("or the ingot is thrown on the ground.");
            par3List.add("Additionally these ingots do not stack");
            par3List.add(" - Do not craft unless ready -");
            par3List.add("");
            par3List.add("Must be crafted in a vanilla crafting table.");
            if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("creative")) {
                par3List.add("");
                par3List.add("Creative Spawned - Stable");
            }
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        if (location instanceof EntityItem && itemstack.func_77942_o() && (itemstack.func_77978_p().func_74764_b("crafting") || itemstack.func_77978_p().func_74764_b("time"))) {
            ((EntityItem)location).field_70292_b = 1;
            location.func_70106_y();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("creative", true);
        ItemStack item = new ItemStack(par1, 1, 0);
        item.func_77982_d(tag);
        par3List.add(item);
        item = new ItemStack(par1, 1, 1);
        par3List.add(item);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IIconRegister) {
        this.field_77791_bV = this.iconIngot[0] = par1IIconRegister.func_94245_a(this.func_77658_a().substring(5));
        this.iconIngot[1] = par1IIconRegister.func_94245_a(this.func_77658_a().substring(5) + "1");
        this.iconNugget[0] = par1IIconRegister.func_94245_a("extrautils:unstablenugget");
        this.iconNugget[1] = par1IIconRegister.func_94245_a("extrautils:unstablenugget1");
    }

    @Override
    public int numIcons(ItemStack item) {
        return 2;
    }

    @Override
    public IIcon getIconForTransparentRender(ItemStack item, int pass) {
        if (item.func_77960_j() > 0) {
            return this.iconNugget[pass];
        }
        return this.iconIngot[pass];
    }

    @Override
    public float getIconTransparency(ItemStack item, int pass) {
        if (pass == 1) {
            return 0.5f;
        }
        return 1.0f;
    }
}

