/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.item.scanner;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import com.rwtema.extrautils.item.scanner.IScanner;
import cpw.mods.fml.common.Loader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class ScannerRegistry {
    public static List<IScanner> scanners = new ArrayList<IScanner>();
    private static boolean isSorted = false;

    public static void addScanner(IScanner scan) {
        scanners.add(scan);
        isSorted = false;
    }

    public static void sort() {
        Collections.sort(scanners, new SortScanners());
        isSorted = true;
    }

    public static List<String> getData(Object obj, ForgeDirection side) {
        ArrayList<String> data = new ArrayList<String>();
        if (!isSorted) {
            ScannerRegistry.sort();
        }
        for (IScanner scan : scanners) {
            if (!scan.getTargetClass().isAssignableFrom(obj.getClass())) continue;
            scan.addData(obj, data, side);
        }
        return data;
    }

    static {
        ScannerRegistry.addScanner(new scanTE());
        ScannerRegistry.addScanner(new scanEntity());
        ScannerRegistry.addScanner(new scanInv());
        ScannerRegistry.addScanner(new scanSidedInv());
        ScannerRegistry.addScanner(new scanTank());
        if (Loader.isModLoaded((String)"Buildcraft|Energy")) {
            ScannerRegistry.addScanner(new scanBCPower());
        }
        ScannerRegistry.addScanner(new scanTE3Power());
    }

    public static class scanShears
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return IShearable.class;
        }

        @Override
        public void addData(Object target, List<String> data, ForgeDirection side) {
            IShearable a = (IShearable)target;
            data.add("- Shearable");
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }

    public static class scanTE3Power
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return IEnergyHandler.class;
        }

        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side) {
            IEnergyHandler a = (IEnergyHandler)tile;
            data.add(" TE3 Side Energy: " + a.getEnergyStored(side) + " / " + a.getMaxEnergyStored(side));
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }

    public static class scanBCPower
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return IPowerReceptor.class;
        }

        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side) {
            PowerHandler.PowerReceiver p = ((IPowerReceptor)tile).getPowerReceiver(side);
            if (p != null) {
                String t = "BC Power: ";
                switch (p.getType().ordinal()) {
                    case 0: {
                        t = t + "Engine";
                        break;
                    }
                    case 1: {
                        t = t + "Gate";
                        break;
                    }
                    case 2: {
                        t = t + "Machine";
                        break;
                    }
                    case 3: {
                        t = t + "Pipe";
                        break;
                    }
                    case 4: {
                        t = t + "Storage";
                    }
                }
                data.add(t);
                data.add(" Energy Stored: " + p.getEnergyStored() + " / " + p.getMaxEnergyStored());
                data.add(" Energy Input (min-max): " + p.getMinEnergyReceived() + "-" + p.getMaxEnergyReceived());
            }
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }

    public static class scanTank
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return IFluidHandler.class;
        }

        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side) {
            FluidTankInfo[] tanks = ((IFluidHandler)tile).getTankInfo(side);
            if (tanks != null) {
                if (tanks.length == 1) {
                    if (tanks[0].fluid != null && tanks[0].fluid.amount > 0) {
                        data.add("Fluid Tank: " + tanks[0].fluid.getFluid().getLocalizedName() + " - " + tanks[0].fluid.amount + " / " + tanks[0].capacity);
                    } else {
                        data.add("Fluid Tank: Empty - 0 / " + tanks[0].capacity);
                    }
                } else {
                    for (int i = 0; i < tanks.length; ++i) {
                        if (tanks[i].fluid != null && tanks[i].fluid.amount > 0) {
                            data.add("Fluid Tank " + i + ": " + tanks[i].fluid.getFluid().getLocalizedName() + " - " + tanks[i].fluid.amount + " / " + tanks[i].capacity);
                            continue;
                        }
                        data.add("Fluid Tank " + i + ": Empty - 0 / " + tanks[i].capacity);
                    }
                }
            }
        }

        @Override
        public int getPriority() {
            return -98;
        }
    }

    public static class scanSidedInv
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return ISidedInventory.class;
        }

        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side) {
            int[] slots = ((ISidedInventory)tile).func_94128_d(side.ordinal());
            int k = 0;
            if (slots.length > 0) {
                for (int i = 0; i < slots.length; ++i) {
                    if (((ISidedInventory)tile).func_70301_a(i) == null) continue;
                    ++k;
                }
                data.add("Inventory Side Slots: " + k + " / " + slots.length);
            }
        }

        @Override
        public int getPriority() {
            return -99;
        }
    }

    public static class scanInv
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return IInventory.class;
        }

        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side) {
            int n = ((IInventory)tile).func_70302_i_();
            if (n > 0) {
                int k = 0;
                for (int i = 0; i < n; ++i) {
                    if (((IInventory)tile).func_70301_a(i) == null) continue;
                    ++k;
                }
                data.add("Inventory Slots: " + k + " / " + n);
            }
        }

        @Override
        public int getPriority() {
            return -100;
        }
    }

    public static class scanEntityLiv
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return EntityLivingBase.class;
        }

        @Override
        public void addData(Object target, List<String> data, ForgeDirection side) {
            EntityLivingBase e = (EntityLivingBase)target;
            data.add(e.func_110143_aJ() + " / " + e.func_110138_aP());
        }

        @Override
        public int getPriority() {
            return -110;
        }
    }

    public static class scanEntity
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return Entity.class;
        }

        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side) {
            NBTTagCompound tags = new NBTTagCompound();
            if (((Entity)tile).func_70039_c(tags)) {
                data.add("~~ " + tags.func_74779_i("id") + " ~~");
                data.add("Entity Data: " + tags.toString().length());
            }
        }

        @Override
        public int getPriority() {
            return Integer.MIN_VALUE;
        }
    }

    public static class scanTE
    implements IScanner {
        @Override
        public Class getTargetClass() {
            return TileEntity.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addData(Object tile, List<String> data, ForgeDirection side) {
            NBTTagCompound tags = new NBTTagCompound();
            ((TileEntity)tile).func_145841_b(tags);
            data.add("~~ " + tags.func_74779_i("id") + " ~~");
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
            try {
                try {
                    CompressedStreamTools.func_74800_a((NBTTagCompound)tags, (DataOutput)dataoutputstream);
                    data.add("Tile Data: " + bytearrayoutputstream.size());
                }
                finally {
                    dataoutputstream.close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }

        @Override
        public int getPriority() {
            return -2147483647;
        }
    }

    public static class SortScanners
    implements Comparator<IScanner> {
        @Override
        public int compare(IScanner arg0, IScanner arg1) {
            int b;
            int a = arg0.getPriority();
            if (a == (b = arg1.getPriority())) {
                return 0;
            }
            if (a < b) {
                return -1;
            }
            return 1;
        }
    }
}

