/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.multipart.microblock;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.IMicroMaterialRender;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.microblock.MicroblockRender;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.MultipartGenerator;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.rwtema.extrautils.multipart.microblock.IFence;
import com.rwtema.extrautils.multipart.microblock.IMicroBlock;
import com.rwtema.extrautils.multipart.microblock.ItemMicroBlock;
import com.rwtema.extrautils.multipart.microblock.PartFenceDummyArm;
import com.rwtema.extrautils.multipart.microblock.PartMicroBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class PartFence
extends PartMicroBlock
implements JIconHitEffects,
IMicroMaterialRender,
JNormalOcclusion,
IFence,
IMicroBlock {
    public static final Cuboid6[] partCuboids = new Cuboid6[]{new Cuboid6(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new Cuboid6(0.375, 0.0, 0.375, 0.625, 1.5, 0.625), new Cuboid6(0.375, 0.0, 0.0, 0.625, 1.5, 0.375), new Cuboid6(0.375, 0.0, 0.625, 0.625, 1.5, 1.0), new Cuboid6(0.0, 0.0, 0.375, 0.375, 1.5, 0.625), new Cuboid6(0.625, 0.0, 0.375, 1.0, 1.5, 0.625)};
    public static final Cuboid6[] renderCuboids1 = new Cuboid6[]{null, null, new Cuboid6(0.4375, 0.75, 0.0, 0.5625, 0.9375, 0.375), new Cuboid6(0.4375, 0.75, 0.625, 0.5625, 0.9375, 1.0), new Cuboid6(0.0, 0.75, 0.4375, 0.375, 0.9375, 0.5625), new Cuboid6(0.625, 0.75, 0.4375, 1.0, 0.9375, 0.5625)};
    public static final Cuboid6[] renderCuboids2 = new Cuboid6[]{null, null, new Cuboid6(0.4375, 0.375, 0.0, 0.5625, 0.5625, 0.375), new Cuboid6(0.4375, 0.375, 0.625, 0.5625, 0.5625, 1.0), new Cuboid6(0.0, 0.375, 0.4375, 0.375, 0.5625, 0.5625), new Cuboid6(0.625, 0.375, 0.4375, 1.0, 0.5625, 0.5625)};
    public static final String type = "extrautils:fence";
    public static Cuboid6[] axisCubes = null;
    public MicroMaterialRegistry.IMicroMaterial mat = null;
    public int connectionMask = 0;
    int material;

    public PartFence() {
    }

    public PartFence(int material) {
        this.material = material;
    }

    @Override
    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    @Override
    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(this.getBounds());
    }

    @Override
    public void harvest(MovingObjectPosition hit, EntityPlayer player) {
        super.harvest(hit, player);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeInt(this.material);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        this.material = packet.readInt();
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74778_a("mat", MicroMaterialRegistry.materialName((int)this.material));
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.material = MicroMaterialRegistry.materialID((String)tag.func_74779_i("mat"));
    }

    @Override
    public String getType() {
        return type;
    }

    public Cuboid6 getBounds() {
        return partCuboids[0];
    }

    @Override
    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> t = new ArrayList<Cuboid6>();
        t.add(partCuboids[1].copy());
        for (int i = 2; i < 6; ++i) {
            if ((this.connectionMask & 1 << i) == 0) continue;
            t.add(partCuboids[i].copy());
        }
        return t;
    }

    @Override
    public ItemStack getItemDrop() {
        ItemStack item = new ItemStack((Item)ItemMicroBlock.instance, 1, 1);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("mat", MicroMaterialRegistry.materialName((int)this.material));
        item.func_77982_d(tag);
        return item;
    }

    @Override
    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(this.getItemDrop());
    }

    @Override
    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItemDrop();
    }

    @Override
    public IIcon getBreakingIcon(Object subPart, int side) {
        return this.getBrokenIcon(side);
    }

    @Override
    public MicroMaterialRegistry.IMicroMaterial getMaterial() {
        if (this.mat == null) {
            this.mat = MicroMaterialRegistry.getMaterial((int)this.material);
        }
        return this.mat;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBrokenIcon(int side) {
        if (this.mat != null) {
            return this.mat.getBreakingIcon(side);
        }
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    @Override
    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (MovingObjectPosition)hit, (EffectRenderer)effectRenderer);
    }

    @Override
    public void addDestroyEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (EffectRenderer)effectRenderer, (boolean)false);
    }

    @Override
    public Cuboid6 getRenderBounds() {
        return this.getBounds();
    }

    @Override
    public int getLightValue() {
        return MicroMaterialRegistry.getMaterial((int)this.material).getLightValue();
    }

    @Override
    public void onNeighborChanged() {
        this.reloadShape();
    }

    @Override
    public void drop() {
        TileMultipart.dropItem((ItemStack)this.getItemDrop(), (World)this.world(), (Vector3)Vector3.fromTileEntityCenter((TileEntity)this.tile()));
        this.tile().remPart((TMultiPart)this);
    }

    @Override
    public void onPartChanged(TMultiPart part) {
        this.reloadShape();
    }

    @Override
    public Iterable<IndexedCuboid6> getSubParts() {
        IndexedCuboid6 box = new IndexedCuboid6((Object)0, new Cuboid6(0.5, 0.5, 0.5, 0.5, 0.5, 0.5));
        for (Cuboid6 cuboid6 : this.getCollisionBoxes()) {
            box.enclose((Cuboid6)new IndexedCuboid6((Object)0, cuboid6));
        }
        box.max.y = 1.0;
        return Arrays.asList(box);
    }

    @Override
    public void onWorldJoin() {
        this.reloadShape();
        super.onWorldJoin();
    }

    public boolean shouldConnect(int x, int y, int z, int direction) {
        Block l = this.world().func_147439_a(x, y, z);
        if (this.world().func_147438_o(x, y, z) instanceof IFence && this.tile().canAddPart((TMultiPart)PartFenceDummyArm.dummyArms[direction])) {
            return ((TileMultipart)this.world().func_147438_o(x, y, z)).canAddPart((TMultiPart)PartFenceDummyArm.dummyArms[Facing.field_71588_a[direction]]);
        }
        return l.func_149688_o().func_76218_k() && l.func_149686_d() && this.tile().canAddPart((TMultiPart)PartFenceDummyArm.dummyArms[direction]);
    }

    @Override
    public void reloadShape() {
        int prevMask = this.connectionMask;
        this.connectionMask = 0;
        for (int i = 2; i < 6; ++i) {
            if (!this.shouldConnect(this.x() + Facing.field_71586_b[i], this.y() + Facing.field_71587_c[i], this.z() + Facing.field_71585_d[i], i)) continue;
            this.connectionMask |= 1 << i;
        }
        if (prevMask != this.connectionMask) {
            this.tile().notifyPartChange((TMultiPart)this);
            this.tile().markRender();
        }
    }

    @Override
    public boolean renderStatic(Vector3 pos, int pass) {
        this.reloadShape();
        if (this.mat == null) {
            this.mat = MicroMaterialRegistry.getMaterial((int)this.material);
        }
        if (this.mat != null && this.mat.canRenderInPass(pass)) {
            MicroblockRender.renderCuboid((Vector3)new Vector3((double)this.x(), (double)this.y(), (double)this.z()), (MicroMaterialRegistry.IMicroMaterial)this.mat, (int)pass, (Cuboid6)this.getRenderBounds(), (int)0);
            for (int i = 0; i < 6; ++i) {
                if ((this.connectionMask & 1 << i) == 0) continue;
                MicroblockRender.renderCuboid((Vector3)new Vector3((double)this.x(), (double)this.y(), (double)this.z()), (MicroMaterialRegistry.IMicroMaterial)this.mat, (int)pass, (Cuboid6)renderCuboids1[i], (int)(1 << Facing.field_71588_a[i] | 1 << i));
                MicroblockRender.renderCuboid((Vector3)new Vector3((double)this.x(), (double)this.y(), (double)this.z()), (MicroMaterialRegistry.IMicroMaterial)this.mat, (int)pass, (Cuboid6)renderCuboids2[i], (int)(1 << Facing.field_71588_a[i] | 1 << i));
            }
            return true;
        }
        return false;
    }

    @Override
    public void renderStatic(Vector3 pos) {
    }

    @Override
    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return this.getMaterial().getStrength(player);
    }

    @Override
    public int getMetadata() {
        return 1;
    }

    @Override
    public TMultiPart newPart(boolean client) {
        return new PartFence();
    }

    @Override
    public TMultiPart placePart(ItemStack stack, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 arg5, int materialID) {
        return new PartFence(materialID);
    }

    @Override
    public void registerPassThroughs() {
        MultipartGenerator.registerPassThroughInterface((String)IFence.class.getName());
    }

    @Override
    public void renderItem(ItemStack item, MicroMaterialRegistry.IMicroMaterial material) {
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)partCuboids[0], (int)0);
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)renderCuboids1[2], (int)0);
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)renderCuboids1[3], (int)0);
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)renderCuboids2[2], (int)0);
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)renderCuboids2[3], (int)0);
    }
}

