/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.generator;

import com.rwtema.extrautils.tileentity.generator.TileEntityGenerator;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityGeneratorFurnaceOverClocked
extends TileEntityGeneratorFurnace {
    public double curLevel = 0.0;
    public double speed = 0.0;

    @Override
    public int transferLimit() {
        return 100000;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("speed", this.speed);
        nbt.func_74780_a("curLevel", this.curLevel);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.speed = nbt.func_74769_h("speed");
        this.curLevel = nbt.func_74769_h("curLevel");
    }

    @Override
    public double genLevel() {
        return (float)this.curLevel;
    }

    @Override
    public void func_145845_h() {
        this.curLevel = this.speed > 0.05 ? (this.curLevel += this.speed - 0.05) : (this.curLevel -= 0.05);
        if (this.curLevel < 0.0) {
            this.curLevel = 0.0;
        }
        this.speed *= 0.96;
        super.func_145845_h();
    }

    @Override
    public double getFuelBurn(ItemStack item) {
        if (item == null || item.field_77994_a == 0) {
            return 0.0;
        }
        int k = TileEntityGenerator.getFurnaceBurnTime(item);
        double p = this.coolDown / (double)(this.getMaxCoolDown() - k);
        this.speed = Math.min(Math.max(this.speed, (double)(k / 1600) * 0.1), 0.2);
        return (double)k * (0.1 + p * 3.0) / (1.0 + this.genLevel());
    }

    @Override
    public boolean burnItem() {
        if (super.burnItem()) {
            int k = TileEntityGenerator.getFurnaceBurnTime(this.inv.func_70301_a(0));
            this.speed = Math.min(Math.max(this.speed, (double)(k / 1600) * 0.1), 0.1);
            return true;
        }
        return false;
    }

    @Override
    public boolean addCoolDown(double add, boolean simulate) {
        if (add == 0.0) {
            return false;
        }
        if (!simulate) {
            this.coolDown += add;
            if (this.coolDown > (double)this.getMaxCoolDown()) {
                this.coolDown = this.getMaxCoolDown();
            }
        }
        return true;
    }

    @Override
    public double stepCoolDown() {
        return 1.0;
    }

    @Override
    public int getMaxCoolDown() {
        return 3600;
    }
}

