/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.multipart;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.Vertex5;
import codechicken.lib.render.uv.MultiIconTransformation;
import codechicken.lib.render.uv.UVTransformation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.BlockMicroMaterial;
import codechicken.microblock.FaceMicroblockClient;
import codechicken.microblock.MaterialRenderHelper;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.rwtema.extrautils.XUHelperClient;
import com.rwtema.extrautils.block.BlockDecoration;
import com.rwtema.extrautils.block.FakeRenderBlocks;
import com.rwtema.extrautils.block.IconConnectedTexture;
import com.rwtema.extrautils.block.RenderBlockConnectedTextures;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import scala.collection.Iterator;
import scala.util.Random;

public class ConnectedTextureMicroMaterial
extends BlockMicroMaterial {
    public static final double[] u = new double[]{-1.0, 1.0, 1.0, -1.0};
    public static final double[] v = new double[]{1.0, 1.0, -1.0, -1.0};
    public boolean isGlass = true;
    Random rand = new Random();
    private int pass;
    private World world;

    public ConnectedTextureMicroMaterial(Block block, int meta) {
        super(block, meta);
        this.isGlass = block instanceof BlockDecoration ? !((BlockDecoration)block).field_149787_q[this.meta()] : !block.func_149662_c();
    }

    public int getLightValue() {
        if (this.block() instanceof BlockDecoration) {
            return ((BlockDecoration)this.block()).light[this.meta()];
        }
        return 0;
    }

    public void renderMicroFace(Vector3 pos, int pass, Cuboid6 bounds) {
        int c = this.getColour(pass);
        this.pass = pass;
        if (pass != -1) {
            if (CCRenderState.model instanceof BlockRenderer.BlockFace) {
                int s = this.getSideFromBounds(bounds);
                int side = ((BlockRenderer.BlockFace)CCRenderState.model).side;
                this.world = XUHelperClient.clientPlayer().func_130014_f_();
                if (s == side) {
                    FakeRenderBlocks fr = RenderBlockConnectedTextures.fakeRender;
                    fr.setWorld((IBlockAccess)this.world);
                    IIcon icon = this.block().func_149691_a(s, this.meta());
                    if (icon instanceof IconConnectedTexture) {
                        fr.curBlock = this.block();
                        fr.curMeta = this.meta();
                        if (this.isGlass) {
                            double h = 0.001;
                            switch (s) {
                                case 0: {
                                    this.renderHalfSide(this.block(), 0.5, h, 0.5, 1, 0, 0, 0, 0, -1, (IconConnectedTexture)icon, bounds, side, pos, c);
                                    break;
                                }
                                case 1: {
                                    this.renderHalfSide(this.block(), 0.5, 1.0 - h, 0.5, -1, 0, 0, 0, 0, -1, (IconConnectedTexture)icon, bounds, side, pos, c);
                                    break;
                                }
                                case 2: {
                                    this.renderHalfSide(this.block(), 0.5, 0.5, h, 1, 0, 0, 0, 1, 0, (IconConnectedTexture)icon, bounds, side, pos, c);
                                    break;
                                }
                                case 3: {
                                    this.renderHalfSide(this.block(), 0.5, 0.5, 1.0 - h, -1, 0, 0, 0, 1, 0, (IconConnectedTexture)icon, bounds, side, pos, c);
                                    break;
                                }
                                case 4: {
                                    this.renderHalfSide(this.block(), h, 0.5, 0.5, 0, 0, -1, 0, 1, 0, (IconConnectedTexture)icon, bounds, side, pos, c);
                                    break;
                                }
                                case 5: {
                                    this.renderHalfSide(this.block(), 1.0 - h, 0.5, 0.5, 0, 0, 1, 0, 1, 0, (IconConnectedTexture)icon, bounds, side, pos, c);
                                }
                            }
                        } else {
                            switch (s) {
                                case 0: {
                                    this.renderSide(this.block(), 0.5, 0.0, 0.5, 1, 0, 0, 0, 0, -1, (IconConnectedTexture)icon, side, pos, c, this.icont());
                                    break;
                                }
                                case 1: {
                                    this.renderSide(this.block(), 0.5, 1.0, 0.5, -1, 0, 0, 0, 0, -1, (IconConnectedTexture)icon, side, pos, c, this.icont());
                                    break;
                                }
                                case 2: {
                                    this.renderSide(this.block(), 0.5, 0.5, 0.0, 1, 0, 0, 0, 1, 0, (IconConnectedTexture)icon, side, pos, c, this.icont());
                                    break;
                                }
                                case 3: {
                                    this.renderSide(this.block(), 0.5, 0.5, 1.0, -1, 0, 0, 0, 1, 0, (IconConnectedTexture)icon, side, pos, c, this.icont());
                                    break;
                                }
                                case 4: {
                                    this.renderSide(this.block(), 0.0, 0.5, 0.5, 0, 0, -1, 0, 1, 0, (IconConnectedTexture)icon, side, pos, c, this.icont());
                                    break;
                                }
                                case 5: {
                                    this.renderSide(this.block(), 1.0, 0.5, 0.5, 0, 0, 1, 0, 1, 0, (IconConnectedTexture)icon, side, pos, c, this.icont());
                                }
                            }
                        }
                        return;
                    }
                    MaterialRenderHelper.start((Vector3)pos, (int)pass, (UVTransformation)this.icont()).blockColour(this.getColour(pass)).lighting().render();
                    return;
                }
            }
            super.renderMicroFace(pos, pass, bounds);
        }
    }

    public int getSideFromBounds(Cuboid6 bounds) {
        if (bounds.max.y != 1.0) {
            return 0;
        }
        if (bounds.min.y != 0.0) {
            return 1;
        }
        if (bounds.max.z != 1.0) {
            return 2;
        }
        if (bounds.min.z != 0.0) {
            return 3;
        }
        if (bounds.max.x != 1.0) {
            return 4;
        }
        if (bounds.min.x != 0.0) {
            return 5;
        }
        return -1;
    }

    public void renderSide(Block block, double ox, double oy, double oz, int ax, int ay, int az, int bx, int by, int bz, IconConnectedTexture icon, int side, Vector3 pos, int colour, MultiIconTransformation icont) {
        Tessellator t = Tessellator.field_78398_a;
        for (int j = 0; j < 4; ++j) {
            RenderBlockConnectedTextures.fakeRender.isOpaque = !this.isGlass;
            byte i = RenderBlockConnectedTextures.fakeRender.getType(block, side, (int)pos.x, (int)pos.y, (int)pos.z, ax * (int)u[j], ay * (int)u[j], az * (int)u[j], bx * (int)v[j], by * (int)v[j], bz * (int)v[j], (int)(ox * 2.0 - 1.0), (int)(oy * 2.0 - 1.0), (int)(oz * 2.0 - 1.0));
            icon.setType(i);
            double cx = ox + (double)ax * u[j] / 4.0 + (double)bx * v[j] / 4.0;
            double cy = oy + (double)ay * u[j] / 4.0 + (double)by * v[j] / 4.0;
            double cz = oz + (double)az * u[j] / 4.0 + (double)bz * v[j] / 4.0;
            Vertex5[] vec = new Vertex5[4];
            for (int k = 0; k < 4; ++k) {
                vec[k] = new Vertex5(cx + u[k] * (double)ax * 0.25 + v[k] * (double)bx * 0.25, cy + u[k] * (double)ay * 0.25 + v[k] * (double)by * 0.25, cz + u[k] * (double)az * 0.25 + v[k] * (double)bz * 0.25, (double)icon.func_94214_a(16.0 - (8.0 + u[j] * 4.0 + u[k] * 4.0)), (double)icon.func_94207_b(16.0 - (8.0 + v[j] * 4.0 + v[k] * 4.0)));
            }
            MaterialRenderHelper.start((Vector3)pos, (int)this.pass, (UVTransformation)icont).blockColour(this.getColour(this.pass)).lighting().render();
            icon.resetType();
        }
    }

    public boolean hasMatchingPart(Cuboid6 part, int x, int y, int z) {
        TileEntity tile_base = this.world.func_147438_o(x, y, z);
        if (tile_base != null && tile_base instanceof TileMultipart) {
            Iterator parts = ((TileMultipart)tile_base).partList().toIterator();
            while (parts.hasNext()) {
                TMultiPart p = (TMultiPart)parts.next();
                if (!(p instanceof FaceMicroblockClient) || ((FaceMicroblockClient)p).getBounds() != part || MicroMaterialRegistry.getMaterial((int)((FaceMicroblockClient)p).material()) != this) continue;
                return true;
            }
        }
        return false;
    }

    public int getHalfType(Block block, int side, int x, int y, int z, int ax, int ay, int az, int bx, int by, int bz, Cuboid6 part) {
        boolean a = this.hasMatchingPart(part, x + ax, y + ay, z + az);
        boolean b = this.hasMatchingPart(part, x + bx, y + by, z + bz);
        if (a) {
            if (b) {
                if (this.hasMatchingPart(part, x + ax + bx, y + ay + by, z + az + bz)) {
                    return 3;
                }
                return 4;
            }
            return 2;
        }
        if (b) {
            return 1;
        }
        return 0;
    }

    public void renderHalfSide(Block block, double ox, double oy, double oz, int ax, int ay, int az, int bx, int by, int bz, IconConnectedTexture icon, Cuboid6 part, int side, Vector3 pos, int colour) {
        Tessellator t = Tessellator.field_78398_a;
        for (int j = 0; j < 4; ++j) {
            int i = this.getHalfType(block, side, (int)pos.x, (int)pos.y, (int)pos.z, ax * (int)u[j], ay * (int)u[j], az * (int)u[j], bx * (int)v[j], by * (int)v[j], bz * (int)v[j], part);
            icon.setType(i);
            double cx = ox + (double)ax * u[j] / 4.0 + (double)bx * v[j] / 4.0;
            double cy = oy + (double)ay * u[j] / 4.0 + (double)by * v[j] / 4.0;
            double cz = oz + (double)az * u[j] / 4.0 + (double)bz * v[j] / 4.0;
            Vertex5[] vec = new Vertex5[4];
            for (int k = 0; k < 4; ++k) {
                vec[k] = new Vertex5(cx + u[k] * (double)ax * 0.25 + v[k] * (double)bx * 0.25, cy + u[k] * (double)ay * 0.25 + v[k] * (double)by * 0.25, cz + u[k] * (double)az * 0.25 + v[k] * (double)bz * 0.25, (double)icon.func_94214_a(16.0 - (8.0 + u[j] * 4.0 + u[k] * 4.0)), (double)icon.func_94207_b(16.0 - (8.0 + v[j] * 4.0 + v[k] * 4.0)));
            }
            MaterialRenderHelper.start((Vector3)pos, (int)this.pass, (UVTransformation)this.icont()).blockColour(this.getColour(this.pass)).lighting().render();
            icon.resetType();
        }
    }
}

