/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.nei;

import codechicken.microblock.MicroMaterialRegistry;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.rwtema.extrautils.multipart.FMPBase;
import com.rwtema.extrautils.multipart.microblock.RecipeMicroBlocks;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;

public class MicroBlocksHandler
extends ShapedRecipeHandler {
    public static String[] currentMaterials = null;
    public static Set<IRecipe> recipes = null;
    public String currentMaterial = "";
    public boolean scroll = true;

    public static Set<IRecipe> getCraftingRecipes() {
        if (recipes == null) {
            recipes = new HashSet<IRecipe>();
            List allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allrecipes) {
                if (!(irecipe instanceof RecipeMicroBlocks)) continue;
                recipes.add(irecipe);
            }
        }
        return recipes;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), this.getOverlayIdentifier(), new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrafting.class;
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IRecipe irecipe : MicroBlocksHandler.getCraftingRecipes()) {
            if (!(irecipe instanceof RecipeMicroBlocks) || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            MicroblockCachedRecipe recipe = new MicroblockCachedRecipe((RecipeMicroBlocks)irecipe);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
        this.scroll = !result.func_77942_o() || "".equals(result.func_77978_p().func_74779_i("mat"));
        this.currentMaterial = result.func_77942_o() ? result.func_77978_p().func_74779_i("mat") : "";
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe irecipe : MicroBlocksHandler.getCraftingRecipes()) {
            MicroblockCachedRecipe recipe = null;
            if (irecipe instanceof RecipeMicroBlocks) {
                recipe = new MicroblockCachedRecipe((RecipeMicroBlocks)irecipe);
            }
            if (recipe == null) continue;
            recipe.computeVisuals();
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
        this.scroll = !ingredient.func_77942_o() || "".equals(ingredient.func_77978_p().func_74779_i("mat"));
        this.currentMaterial = ingredient.func_77942_o() ? ingredient.func_77978_p().func_74779_i("mat") : "";
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return super.hasOverlay(gui, container, recipe) || this.isRecipe2x2(recipe) && RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)"crafting2x2");
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        IRecipeOverlayRenderer renderer = super.getOverlayRenderer(gui, recipe);
        if (renderer != null) {
            return renderer;
        }
        IStackPositioner positioner = RecipeInfo.getStackPositioner((GuiContainer)gui, (String)"crafting2x2");
        if (positioner == null) {
            return null;
        }
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), positioner);
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        IOverlayHandler handler = super.getOverlayHandler(gui, recipe);
        if (handler != null) {
            return handler;
        }
        return RecipeInfo.getOverlayHandler((GuiContainer)gui, (String)"crafting2x2");
    }

    public boolean isRecipe2x2(int recipe) {
        for (PositionedStack stack : this.getIngredientStacks(recipe)) {
            if (stack.relx <= 43 && stack.rely <= 24) continue;
            return false;
        }
        return true;
    }

    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    public String getOverlayIdentifier() {
        return "xu_microblocks_crafting";
    }

    public String getRecipeName() {
        return "Extra Utilities: Microblocks";
    }

    public class MicroblockCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public MicroblockPositionedStack result;

        public MicroblockCachedRecipe(int width, int height, Object[] items, ItemStack out) {
            super((TemplateRecipeHandler)MicroBlocksHandler.this);
            this.result = new MicroblockPositionedStack(out, 119, 24, true);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public MicroblockCachedRecipe(RecipeMicroBlocks irecipe) {
            this(irecipe.recipeWidth, irecipe.recipeHeight, irecipe.getRecipeItems(), irecipe.func_77571_b());
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    MicroblockPositionedStack stack = new MicroblockPositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public void permMaterial() {
            if (!MicroBlocksHandler.this.scroll) {
                return;
            }
            if (currentMaterials == null) {
                currentMaterials = new String[MicroMaterialRegistry.getIdMap().length];
                for (int i = 0; i < MicroMaterialRegistry.getIdMap().length; ++i) {
                    MicroBlocksHandler.currentMaterials[i] = (String)MicroMaterialRegistry.getIdMap()[i]._1();
                }
            }
            MicroBlocksHandler.this.currentMaterial = currentMaterials[MicroBlocksHandler.this.cycleticks / 20 % currentMaterials.length];
        }

        public List<PositionedStack> getIngredients() {
            this.permMaterial();
            return this.getCycledIngredients(MicroBlocksHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            this.permMaterial();
            this.result.addMaterial();
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
            this.result.generatePermutations();
        }

        public class MicroblockPositionedStack
        extends PositionedStack {
            public MicroblockPositionedStack(Object object, int x, int y, boolean genPerms) {
                super(object, x, y, genPerms);
            }

            public void setPermutationToRender(int index) {
                super.setPermutationToRender(index);
                if (this.item.func_77973_b() == FMPBase.getMicroBlockItemId()) {
                    this.addMaterial();
                }
            }

            public void addMaterial() {
                if ("".equals(MicroBlocksHandler.this.currentMaterial)) {
                    this.item = null;
                    return;
                }
                NBTTagCompound tag = this.item.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                tag.func_74778_a("mat", MicroBlocksHandler.this.currentMaterial);
                this.item.func_77982_d(tag);
            }
        }
    }
}

