/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.texture;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class LiquidColorRegistry
implements IResourceManagerReloadListener {
    public static final int emptyColor = 0xFFFFFF;
    public static final int defaultColor = 0xFFFFFF;
    public static Map<IIcon, Integer> m = new HashMap<IIcon, Integer>();
    private static IResourceManager resourcemanager;

    public static void reset() {
        m.clear();
    }

    public static int getIconColor(IIcon icon, int defaultColor) {
        Integer col;
        if (icon == null) {
            return defaultColor;
        }
        if (m.containsKey(icon)) {
            Integer col2 = m.get(icon);
            if (col2 == null) {
                return defaultColor;
            }
            return col2;
        }
        String t = icon.func_94215_i();
        try {
            col = LiquidColorRegistry.readIconCol(t);
        }
        catch (IOException e) {
            col = null;
        }
        if (col == null) {
            m.put(icon, null);
            return defaultColor;
        }
        float r = (float)(col >> 16 & 0xFF) / 255.0f * ((float)(defaultColor >> 16 & 0xFF) / 255.0f);
        float g = (float)(col >> 8 & 0xFF) / 255.0f * ((float)(defaultColor >> 8 & 0xFF) / 255.0f);
        float b = (float)(col & 0xFF) / 255.0f * ((float)(defaultColor & 0xFF) / 255.0f);
        col = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        m.put(icon, col);
        return col;
    }

    public static Integer readIconCol(String t) throws IOException {
        String s1 = "minecraft";
        String s2 = t;
        int i = t.indexOf(58);
        if (i >= 0) {
            s2 = t.substring(i + 1, t.length());
            if (i > 1) {
                s1 = t.substring(0, i);
            }
        }
        s1 = s1.toLowerCase();
        s2 = "textures/blocks/" + s2 + ".png";
        IResource resource = resourcemanager.func_110536_a(new ResourceLocation(s1, s2));
        InputStream inputstream = resource.func_110527_b();
        BufferedImage bufferedimage = ImageIO.read(inputstream);
        int height = bufferedimage.getHeight();
        int width = bufferedimage.getWidth();
        int[] aint = new int[height * width];
        bufferedimage.getRGB(0, 0, width, height, aint, 0, width);
        if (aint.length == 0) {
            return null;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        for (int l : aint) {
            r += (float)(-l >> 16 & 0xFF) / 255.0f;
            g += (float)(-l >> 8 & 0xFF) / 255.0f;
            b += (float)(-l & 0xFF) / 255.0f;
        }
        return -((int)((r /= (float)aint.length) * 255.0f) << 16 | (int)((g /= (float)aint.length) * 255.0f) << 8 | (int)((b /= (float)aint.length) * 255.0f));
    }

    public static int getFluidColor(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null) {
            return 0xFFFFFF;
        }
        if (fluid.getFluid().getIcon(fluid) == null) {
            return 0xFFFFFF;
        }
        return LiquidColorRegistry.getIconColor(fluid.getFluid().getIcon(fluid), fluid.getFluid().getColor(fluid));
    }

    public void func_110549_a(IResourceManager resourcemanager) {
        LiquidColorRegistry.reset();
        LiquidColorRegistry.resourcemanager = resourcemanager;
    }
}

