/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.texture;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;

public class TextureComprBlock
extends TextureAtlasSprite {
    private int n;
    private ResourceLocation textureLocation;

    public TextureComprBlock(String par1Str, String base, int n) {
        super(par1Str);
        this.n = n;
        this.textureLocation = new ResourceLocation("minecraft", "textures/blocks/" + base + ".png");
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        int mp = Minecraft.func_71410_x().field_71474_y.field_151442_I;
        try {
            IResource iresource = manager.func_110536_a(location);
            BufferedImage[] abufferedimage = new BufferedImage[1 + Minecraft.func_71410_x().field_71474_y.field_151442_I];
            abufferedimage[0] = ImageIO.read(iresource.func_110527_b());
            TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
            AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_110526_a("animation");
            this.func_147964_a(abufferedimage, animationmetadatasection, (float)Minecraft.func_71410_x().field_71474_y.field_151443_J > 1.0f);
        }
        catch (IOException e) {
            try {
                IResource iresource = manager.func_110536_a(this.textureLocation);
                BufferedImage[] abufferedimage = new BufferedImage[1 + Minecraft.func_71410_x().field_71474_y.field_151442_I];
                abufferedimage[0] = ImageIO.read(iresource.func_110527_b());
                TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
                AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_110526_a("animation");
                this.func_147964_a(abufferedimage, animationmetadatasection, (float)Minecraft.func_71410_x().field_71474_y.field_151443_J > 1.0f);
            }
            catch (IOException e1) {
                e.printStackTrace();
                return true;
            }
            float nh = (float)this.n / 8.5f;
            float br = 1.0f - nh;
            for (int j = 0; j < this.field_110976_a.size(); ++j) {
                int[] image = new int[((int[][])this.field_110976_a.get(j))[0].length];
                for (int i = 0; i < image.length; ++i) {
                    int x = i % this.field_130223_c;
                    int y = i / this.field_130224_d;
                    int l = ((int[][])this.field_110976_a.get(j))[0][i];
                    float r = (float)(-l >> 16 & 0xFF) / 255.0f;
                    float g = (float)(-l >> 8 & 0xFF) / 255.0f;
                    float b = (float)(-l & 0xFF) / 255.0f;
                    float dx = (float)(2 * x) / (float)(this.field_130223_c - 1) - 1.0f;
                    float dy = (float)(2 * y) / (float)(this.field_130224_d - 1) - 1.0f;
                    float db = Math.max(Math.abs(dx), Math.abs(dy));
                    db = Math.max(db, (float)Math.sqrt(dx * dx + dy * dy) / 1.4f);
                    float d = 1.0f - db + 1.0f - nh;
                    float rb = 1.0f - (float)(2 + this.n) / 32.0f;
                    float k = 1.0f;
                    if (db > rb) {
                        k = 0.7f + 0.1f * (db - rb) / (1.0f - rb);
                    }
                    if ((d *= k * k) > 1.0f) {
                        d = 1.0f;
                    } else if (d < 0.0f) {
                        d = 0.0f;
                    }
                    r = 1.0f - (1.0f - r) * br * d;
                    g = 1.0f - (1.0f - g) * br * d;
                    b = 1.0f - (1.0f - b) * br * d;
                    image[i] = -((int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f));
                }
                int[][] aint = new int[1 + mp][];
                aint[0] = image;
                this.field_110976_a.set(j, aint);
            }
        }
        return false;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }
}

