/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.enderquarry;

import com.rwtema.extrautils.LogHelper;
import com.rwtema.extrautils.tileentity.enderquarry.BlockDummy;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Blocks;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.IFluidBlock;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class BlockBreakingRegistry {
    public static BlockBreakingRegistry instance = new BlockBreakingRegistry();
    public static HashMap<Block, entry> entries = new HashMap();
    public static Set<String> methodNames = null;
    public static Map<String, Boolean> names = new HashMap<String, Boolean>();
    public static LaunchClassLoader cl = (LaunchClassLoader)BlockBreakingRegistry.class.getClassLoader();

    public static boolean blackList(Block id) {
        return BlockBreakingRegistry.entries.get((Object)id).blackList;
    }

    public static boolean isSpecial(Block id) {
        return BlockBreakingRegistry.entries.get((Object)id).isSpecial;
    }

    public static boolean isFence(Block id) {
        return BlockBreakingRegistry.entries.get((Object)id).isFence;
    }

    public static boolean isFluid(Block id) {
        return BlockBreakingRegistry.entries.get((Object)id).isFluid;
    }

    public void setupBreaking() {
        if (methodNames == null) {
            methodNames = new HashSet<String>();
            for (Method m : BlockDummy.class.getDeclaredMethods()) {
                methodNames.add(m.getName());
            }
        } else {
            return;
        }
        for (Object aBlockRegistry : Block.field_149771_c) {
            entries.put((Block)aBlockRegistry, new entry());
        }
        BlockBreakingRegistry.entries.get((Object)Blocks.field_150478_aa).blackList = true;
        for (Object aBlockRegistry : Block.field_149771_c) {
            Block block = (Block)aBlockRegistry;
            entry e = entries.get(block);
            String name = block.getClass().getName();
            if (block.func_149739_a() != null) {
                name = block.func_149739_a();
            }
            try {
                name = Block.field_149771_c.func_148750_c((Object)block);
            }
            catch (Exception err) {
                LogHelper.error("Error getting name for block " + name, new Object[0]);
                err.printStackTrace();
            }
            e.isFence = false;
            try {
                e.isFence = block.func_149645_b() == 11;
            }
            catch (Exception err) {
                LogHelper.error("Error checking block class code: Exception calling getRenderType() on block " + name, new Object[0]);
                err.printStackTrace();
            }
            catch (NoClassDefFoundError err) {
                throw new RuntimeException("Serious error calling getRenderType() on block " + name + " : Likely cause is client-side code is being called server-side", err);
            }
            catch (Throwable err) {
                throw new RuntimeException("Serious error calling getRenderType() on block " + name, err);
            }
            boolean bl = e.isFence = e.isFence || block instanceof BlockFence;
            if (block instanceof BlockLiquid || block instanceof IFluidBlock) {
                e.blackList = true;
                e.isFluid = true;
            }
            if (block instanceof IPlantable || block instanceof IGrowable) {
                e.blackList = true;
            }
            e.isSpecial = this.hasSpecialBreaking(block.getClass());
        }
    }

    public boolean hasSpecialBreaking(Class clazz) {
        if (clazz == null || clazz.equals(Block.class)) {
            return false;
        }
        if (names.containsKey(clazz.getName())) {
            return names.get(clazz.getName());
        }
        LogHelper.info("Checking class for special block breaking code: " + clazz.getName(), new Object[0]);
        try {
            byte[] bytes = clazz.getClassLoader() instanceof LaunchClassLoader ? ((LaunchClassLoader)clazz.getClassLoader()).getClassBytes(clazz.getName()) : cl.getClassBytes(clazz.getName());
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode method : classNode.methods) {
                if (!methodNames.contains(method.name)) continue;
                LogHelper.info("Detected special block breaking code in class: " + clazz.getName(), new Object[0]);
                names.put(clazz.getName(), true);
                return true;
            }
        }
        catch (Throwable e) {
            try {
                for (Method m : clazz.getDeclaredMethods()) {
                    if (!methodNames.contains(m.getName())) continue;
                    LogHelper.info("Detected special block breaking code in class: " + clazz.getName(), new Object[0]);
                    names.put(clazz.getName(), true);
                    return true;
                }
            }
            catch (Throwable e2) {
                LogHelper.error("Error checking block class code: " + clazz.getName(), new Object[0]);
                e.printStackTrace();
                e2.printStackTrace();
                names.put(clazz.getName(), true);
                return true;
            }
        }
        boolean result = this.hasSpecialBreaking(clazz.getSuperclass());
        names.put(clazz.getName(), result);
        return result;
    }

    public static class entry {
        public boolean isSpecial = false;
        public boolean blackList = false;
        public boolean isFence = false;
        public boolean isFluid = false;
    }
}

