/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.generator;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.block.BlockMultiBlock;
import com.rwtema.extrautils.block.BoxModel;
import com.rwtema.extrautils.block.IBlockTooltip;
import com.rwtema.extrautils.block.IMultiBoxBlock;
import com.rwtema.extrautils.nei.InfoData;
import com.rwtema.extrautils.texture.TextureMultiIcon;
import com.rwtema.extrautils.tileentity.generator.TileEntityGenerator;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorEnder;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorFood;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorFurnace;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorFurnaceOverClocked;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorFurnaceSurvival;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorMagma;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorNether;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorPink;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorPotion;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorRedFlux;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorSolar;
import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorTNT;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockGenerator
extends BlockMultiBlock
implements IMultiBoxBlock,
IBlockTooltip {
    private static final int[] rotInd = new int[]{0, 1, 4, 5, 3, 2};
    public static int num_gens = 0;
    public static Class<? extends TileEntityGenerator>[] tiles = new Class[16];
    public static String[] textures = new String[16];
    public static String[] names = new String[16];
    public static Random random;
    private IIcon[][] icons = new IIcon[16][6];

    public BlockGenerator() {
        super(Material.field_151576_e);
        this.func_149647_a(ExtraUtils.creativeTabExtraUtils);
        this.func_149663_c("extrautils:generator");
        this.func_149711_c(5.0f);
        this.func_149672_a(Block.field_149777_j);
    }

    public static void addInfoData() {
        InfoData.add(new ItemStack(ExtraUtils.gen, 1, 0), "Survivalist Generator", "http://i.imgur.com/PopIU5m.png", "Generates RF using regular furnace fuel. It has a very low energy output but is suprisingly effecient and fuel lasts 20 times the base rate");
        InfoData.add(new ItemStack(ExtraUtils.gen, 1, 1), "Furnace Generator", "http://i.imgur.com/5hrgwr9.png", "Generates RF using regular furnace fuel.");
        InfoData.add(new ItemStack(ExtraUtils.gen, 1, 2), "Lava Generator", "http://i.imgur.com/5hrgwr9.png", "Generates RF using lava, which must be piped in liquid form. Note: the generator is not as effecient as other forms of lava power generation.");
        InfoData.add(new ItemStack(ExtraUtils.gen, 1, 3), "Ender Generator", "http://i.imgur.com/6GZVXK8.png", "Generates RF using ender pearls, eyes of ender and ender-lilly seeds. Very effecient.");
        InfoData.add(new ItemStack(ExtraUtils.gen, 1, 4), "Heated Redstone Generator", "http://i.imgur.com/Mm7qlEd.png", "Generates RF using lava and redstone. It can also run off of molten redstone from Thermal Expansion.");
        InfoData.add(new ItemStack(ExtraUtils.gen, 1, 5), "Food Generator", "http://i.imgur.com/tOzbAFV.png", "Generates RF using food. The fulfilling the food, the more RF is generated and the more 'saturating' the food the longer the generator will run for.");
        InfoData.add(new ItemStack(ExtraUtils.gen, 1, 6), "Potion Generator", "http://i.imgur.com/QZ2MgOX.png", "Generates RF using potions. The more complex the potion, the more power is generated. Every brewing 'step' doubles the power generated by the potion.");
        InfoData.add(new ItemStack(ExtraUtils.gen, 1, 7), "Solar Generator", "http://i.imgur.com/or3R8Pe.png", "Generates RF using sunlight. The generator creates a large amount of power from direct sunlight. However there is a problem, the generator cannot generate power and transmit it at the same time. You must switch between the two modes by applying a redstone signal.");
        InfoData.add(new ItemStack(ExtraUtils.gen, 1, 8), "TNT Generator", "http://i.imgur.com/9u0Nz3e.png", "Generates RF using gunpowder/tnt. Watch out, explosions are not completely contained by the generator.");
        InfoData.add(new ItemStack(ExtraUtils.gen, 1, 9), "Pink Generator", "http://i.imgur.com/L3iP98p.png", "Generates RF using the power of love. Pink dye or anything that uses pink dye in its crafting recipe can be used to generate power.");
        InfoData.add(new ItemStack(ExtraUtils.gen, 1, 10), "High-temperature Furnace Generator", "http://i.imgur.com/kSLG67j.png", "Generates RF using regular furnace fuel. A very ineffecient generator with an initially low energy output, but as the internal temperature rises its energy output rises.", "");
        InfoData.add(new ItemStack(ExtraUtils.gen, 1, 11), "Nether Star Generator", "http://i.imgur.com/CbNrVc7.png", "Generates RF using nether stars. Incredibly powerful generator that produces more energy than most systems can transferBC. It will damage anything in a 10 block radius.");
    }

    public static void addRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraUtils.gen, 1, 0), (Object[])new Object[]{"iii", "iIi", "rfr", Character.valueOf('i'), Blocks.field_150347_e, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraUtils.gen, 1, 5), (Object[])new Object[]{"iii", "iIi", "rfr", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('I'), new ItemStack(ExtraUtils.gen, 1, 0), Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraUtils.gen, 1, 1), (Object[])new Object[]{"iii", "iIi", "rfr", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('I'), Blocks.field_150339_S, Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraUtils.gen, 1, 2), (Object[])new Object[]{"iii", "iIi", "rfr", Character.valueOf('i'), Items.field_151043_k, Character.valueOf('I'), Blocks.field_150339_S, Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraUtils.gen, 1, 3), (Object[])new Object[]{"eee", "iIi", "rfr", Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('i'), Items.field_151061_bv, Character.valueOf('I'), Blocks.field_150339_S, Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraUtils.gen, 1, 4), (Object[])new Object[]{"iii", "iIi", "rfr", Character.valueOf('i'), Blocks.field_150451_bX, Character.valueOf('I'), new ItemStack(ExtraUtils.gen, 1, 2), Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraUtils.gen, 1, 6), (Object[])new Object[]{"iii", "iIi", "rfr", Character.valueOf('i'), Blocks.field_150343_Z, Character.valueOf('I'), Blocks.field_150381_bn, Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraUtils.gen, 1, 7), (Object[])new Object[]{"lql", "qIq", "rfr", Character.valueOf('q'), Items.field_151128_bU, Character.valueOf('l'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('I'), Blocks.field_150484_ah, Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraUtils.gen, 1, 8), (Object[])new Object[]{"iii", "iIi", "rfr", Character.valueOf('i'), Blocks.field_150335_W, Character.valueOf('I'), Blocks.field_150339_S, Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraUtils.gen, 1, 9), (Object[])new Object[]{"iii", "iIi", "rfr", Character.valueOf('i'), new ItemStack(Blocks.field_150325_L, 1, 6), Character.valueOf('I'), new ItemStack(ExtraUtils.gen, 1, 0), Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraUtils.gen, 1, 10), (Object[])new Object[]{"iii", "iIi", "rfr", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('I'), new ItemStack(ExtraUtils.gen, 1, 1), Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ExtraUtils.gen, 1, 11), (Object[])new Object[]{"wiw", "wIw", "rfr", Character.valueOf('w'), new ItemStack(Items.field_151144_bL, 1, 1), Character.valueOf('i'), Items.field_151156_bN, Character.valueOf('I'), Blocks.field_150339_S, Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('r'), Items.field_151137_ax});
    }

    public static void mapTiles() {
        for (int i = 0; i < num_gens; ++i) {
            TileEntity.func_145826_a(tiles[i], (String)("extrautils:generator" + textures[i]));
        }
    }

    public static void addName(int i, String texture, String name, Class<? extends TileEntityGenerator> clazz) {
        BlockGenerator.textures[i] = texture;
        BlockGenerator.names[i] = name;
        BlockGenerator.tiles[i] = clazz;
        num_gens = Math.max(num_gens, i + 1);
    }

    public boolean func_149727_a(World worldObj, int x, int y, int z, EntityPlayer player, int side, float dx, float dy, float dz) {
        ItemStack item;
        FluidStack fluid;
        if (worldObj.field_72995_K) {
            return true;
        }
        TileEntity tile = worldObj.func_147438_o(x, y, z);
        if (player.func_71045_bC() != null && tile instanceof IFluidHandler && (fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(item = player.func_71045_bC()))) != null && ((IFluidHandler)tile).fill(ForgeDirection.getOrientation((int)side), fluid, false) == fluid.amount) {
            ((IFluidHandler)tile).fill(ForgeDirection.getOrientation((int)side), fluid, true);
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_70062_b(0, item.func_77973_b().getContainerItem(item));
            }
            return true;
        }
        player.openGui((Object)ExtraUtils.instance, 0, worldObj, x, y, z);
        return true;
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int x) {
        return this.icons[x][par1];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int rot = ((TileEntityGenerator)world.func_147438_o((int)x, (int)y, (int)z)).rotation;
        for (int i = 0; i < rot; ++i) {
            side = rotInd[side];
        }
        return this.icons[world.func_72805_g(x, y, z)][side];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < num_gens; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IIconRegister) {
        for (int i = 0; i < num_gens; ++i) {
            this.icons[i][0] = TextureMultiIcon.registerGridIcon(par1IIconRegister, "extrautils:generator_" + textures[i], 0, 0, 3, 2);
            this.icons[i][1] = TextureMultiIcon.registerGridIcon(par1IIconRegister, "extrautils:generator_" + textures[i], 0, 1, 3, 2);
            this.icons[i][2] = TextureMultiIcon.registerGridIcon(par1IIconRegister, "extrautils:generator_" + textures[i], 1, 0, 3, 2);
            this.icons[i][3] = TextureMultiIcon.registerGridIcon(par1IIconRegister, "extrautils:generator_" + textures[i], 1, 1, 3, 2);
            this.icons[i][4] = TextureMultiIcon.registerGridIcon(par1IIconRegister, "extrautils:generator_" + textures[i], 2, 0, 3, 2);
            this.icons[i][5] = TextureMultiIcon.registerGridIcon(par1IIconRegister, "extrautils:generator_" + textures[i], 2, 1, 3, 2);
        }
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    public boolean hasTileEntity(int metadata) {
        return tiles[metadata] != null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        try {
            return tiles[metadata].newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void prepareForRender(String label) {
    }

    public BoxModel genericModel(int meta) {
        BoxModel model = new BoxModel();
        model.addBoxI(2, 14, 3, 14, 15, 13);
        model.addBoxI(1, 9, 2, 15, 14, 14);
        model.addBoxI(1, 8, 2, 15, 9, 6).setTextureSides(3, this.icons[meta][2]);
        model.addBoxI(1, 8, 10, 15, 9, 14);
        model.addBoxI(1, 7, 2, 15, 8, 5);
        model.addBoxI(1, 4, 2, 15, 7, 4);
        model.addBoxI(2, 8, 6, 14, 9, 10);
        model.addBoxI(2, 7, 5, 14, 8, 11).setTextureSides(1, this.icons[meta][0]);
        model.addBoxI(2, 3, 4, 14, 7, 12).setTextureSides(1, this.icons[meta][0]);
        model.addBoxI(2, 2, 5, 14, 3, 11);
        model.addBoxI(2, 1, 6, 14, 2, 10);
        model.addBoxI(0, 1, 1, 1, 15, 2);
        model.addBoxI(0, 1, 14, 1, 15, 15);
        model.addBoxI(15, 1, 1, 16, 15, 2);
        model.addBoxI(15, 1, 14, 16, 15, 15);
        model.addBoxI(1, 0, 1, 15, 1, 2);
        model.addBoxI(1, 0, 14, 15, 1, 15);
        model.addBoxI(1, 1, 1, 2, 2, 2);
        model.addBoxI(14, 1, 1, 15, 2, 2);
        model.addBoxI(1, 1, 14, 2, 2, 15);
        model.addBoxI(14, 1, 14, 15, 2, 15);
        model.addBoxI(0, 15, 2, 1, 16, 14);
        model.addBoxI(15, 15, 2, 16, 16, 14);
        model.addBoxI(0, 14, 2, 1, 15, 3);
        model.addBoxI(0, 14, 13, 1, 15, 14);
        model.addBoxI(15, 14, 2, 16, 15, 3);
        model.addBoxI(15, 14, 13, 16, 15, 14);
        return model;
    }

    @Override
    public BoxModel getWorldModel(IBlockAccess world, int x, int y, int z) {
        return this.genericModel(world.func_72805_g(x, y, z)).rotateY(((TileEntityGenerator)world.func_147438_o((int)x, (int)y, (int)z)).rotation);
    }

    @Override
    public BoxModel getInventoryModel(int metadata) {
        return this.genericModel(metadata).rotateY(1);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase par5EntityLivingBase, ItemStack item) {
        int l = MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) % 4;
        l = (l + 6) % 4;
        ((TileEntityGenerator)world.func_147438_o((int)x, (int)y, (int)z)).rotation = (byte)l;
        if (item.func_77942_o()) {
            ((TileEntityGenerator)world.func_147438_o((int)x, (int)y, (int)z)).storage.readFromNBT(item.func_77978_p());
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        ArrayList<ItemStack> items = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
        if (world.func_147468_f(x, y, z)) {
            if (!world.field_72995_K) {
                for (ItemStack item : items) {
                    if (player != null && player.field_71075_bZ.field_75098_d && !item.func_77942_o()) continue;
                    this.func_149642_a(world, x, y, z, item);
                }
            }
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStack item = new ItemStack((Block)this, 1, this.func_149692_a(metadata));
        if (world.func_147438_o(x, y, z) instanceof TileEntityGenerator) {
            NBTTagCompound tags = new NBTTagCompound();
            ((TileEntityGenerator)world.func_147438_o(x, y, z)).writeInvToTags(tags);
            if (!tags.func_82582_d()) {
                item.func_77982_d(tags);
            }
        }
        ret.add(item);
        return ret;
    }

    public void func_149636_a(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
        par2EntityPlayer.func_71064_a(StatList.field_75934_C[BlockGenerator.func_149682_b((Block)this)], 1);
        par2EntityPlayer.func_71020_j(0.025f);
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityGenerator && world.func_147438_o(x, y, z) instanceof IInventory) {
            IInventory tile = (IInventory)world.func_147438_o(x, y, z);
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                ItemStack itemstack = tile.func_70301_a(i);
                if (itemstack == null) continue;
                float f = random.nextFloat() * 0.8f + 0.1f;
                float f1 = random.nextFloat() * 0.8f + 0.1f;
                float f2 = random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int k1 = random.nextInt(21) + 10;
                    if (k1 > itemstack.field_77994_a) {
                        k1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= k1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77960_j()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)random.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)random.nextGaussian() * f3;
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    @Override
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("Energy")) {
            par3List.add(par1ItemStack.func_77978_p().func_74762_e("Energy") + " / " + 100000 + " RF");
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int par5) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityGenerator) {
            return ((TileEntityGenerator)tile).getCompLevel();
        }
        return 0;
    }

    static {
        BlockGenerator.addName(0, "stone", "Survivalist", TileEntityGeneratorFurnaceSurvival.class);
        BlockGenerator.addName(1, "base", "Furnace", TileEntityGeneratorFurnace.class);
        BlockGenerator.addName(2, "lava", "Lava", TileEntityGeneratorMagma.class);
        BlockGenerator.addName(3, "ender", "Ender", TileEntityGeneratorEnder.class);
        BlockGenerator.addName(4, "redflux", "Heated Redstone", TileEntityGeneratorRedFlux.class);
        BlockGenerator.addName(5, "food", "Culinary", TileEntityGeneratorFood.class);
        BlockGenerator.addName(6, "potion", "Potions", TileEntityGeneratorPotion.class);
        BlockGenerator.addName(7, "solar", "Solar", TileEntityGeneratorSolar.class);
        BlockGenerator.addName(8, "tnt", "TNT", TileEntityGeneratorTNT.class);
        BlockGenerator.addName(9, "pink", "Pink", TileEntityGeneratorPink.class);
        BlockGenerator.addName(10, "overclocked", "High-temperature Furnace", TileEntityGeneratorFurnaceOverClocked.class);
        BlockGenerator.addName(11, "nether", "Nether Star", TileEntityGeneratorNether.class);
        random = new Random();
    }
}

