/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.generator;

import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.rwtema.extrautils.XUHelper;
import com.rwtema.extrautils.tileentity.generator.InventoryGeneric;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNodeEnergy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;

public abstract class TileEntityGenerator
extends TileEntity
implements IEnergyHandler,
IPowerEmitter {
    public static final int capacity = 100000;
    protected EnergyStorage storage = new EnergyStorage(100000);
    public byte rotation = 0;
    public double coolDown = 0.0;
    int c = -1;
    int[] slots = null;
    private int connectionMask = 0;

    public static int getFurnaceBurnTime(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (item.func_77973_b() == Items.field_151129_at) {
            return 0;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)item);
    }

    public static String getCoolDownString(double t) {
        return TileEntityGenerator.getCoolDownStringInt((int)Math.floor(t)) + (t == Math.floor(t) ? "" : Double.valueOf(t - Math.floor(t)));
    }

    public static String getCoolDownStringInt(long t) {
        String s = t % 60L + "s";
        if ((t /= 60L) == 0L) {
            return s;
        }
        s = t % 60L + "m " + s;
        if ((t /= 60L) == 0L) {
            return s;
        }
        s = t % 24L + "h " + s;
        if ((t /= 24L) == 0L) {
            return s;
        }
        s = t + "d " + s;
        return s;
    }

    public int x() {
        return this.field_145851_c;
    }

    public int y() {
        return this.field_145848_d;
    }

    public int z() {
        return this.field_145849_e;
    }

    public boolean isPowered() {
        return this.field_145850_b.func_72864_z(this.x(), this.y(), this.z());
    }

    public String getBlurb(double coolDown, double energy) {
        if (coolDown == 0.0) {
            return "";
        }
        return "PowerLevel:\n" + energy + "\nTime Remaining:\n" + TileEntityGenerator.getCoolDownString(coolDown);
    }

    public void rightClick(EntityPlayer player, int side, float dx, float dy, float dz) {
        player.func_146105_b((IChatComponent)new ChatComponentText("" + this.coolDown + " " + this.storage.getEnergyStored() + " " + this.genLevel()));
    }

    public double stepCoolDown() {
        return 1.0;
    }

    public boolean checkRedstone() {
        return this.field_145850_b.func_94577_B(this.x(), this.y(), this.z()) > 0;
    }

    public int getCompLevel() {
        if (this.c == -1) {
            this.c = this.storage.getEnergyStored() * 15 / this.storage.getMaxEnergyStored();
        }
        return this.c;
    }

    public void checkCompLevel() {
        if (this.getCompLevel() != this.storage.getEnergyStored() * 15 / this.storage.getMaxEnergyStored()) {
            this.c = this.storage.getEnergyStored() * 15 / this.storage.getMaxEnergyStored();
            this.field_145850_b.func_147459_d(this.x(), this.y(), this.z(), this.func_145838_q());
        }
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.coolDown > 0.0) {
            if (this.coolDown > 1.0) {
                this.storage.receiveEnergy((int)Math.floor(this.genLevel()), false);
                this.coolDown -= this.stepCoolDown();
            } else {
                this.coolDown = 0.0;
            }
        } else {
            this.coolDown = 0.0;
        }
        this.processInput();
        if (this.shouldTransmit() && this.storage.getEnergyStored() > 0) {
            this.transmitEnergy();
        }
        this.checkCompLevel();
    }

    private void transmitEnergy() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.x() + side.offsetX, this.y() + side.offsetY, this.z() + side.offsetZ);
            if (tile instanceof TileEntityGenerator) continue;
            if (tile instanceof IEnergyHandler) {
                this.storage.extractEnergy(((IEnergyHandler)tile).receiveEnergy(side.getOpposite(), this.storage.extractEnergy(this.transferLimit(), true), false), false);
                continue;
            }
            TileEntityGenerator.transferBC(side, tile, this.storage, this.transferLimit());
        }
    }

    public static void transferBC(ForgeDirection side, TileEntity tile, EnergyStorage storage, int amount) {
        PowerHandler.PowerReceiver machine;
        IBatteryObject obj = MjAPI.getMjBattery(tile, "buildcraft.kinesis", side);
        if (obj != null) {
            double a = obj.addEnergy(TileEntityTransferNodeEnergy.RFtoBC(storage.extractEnergy(amount, true)));
            storage.extractEnergy(TileEntityTransferNodeEnergy.BCtoRF(a), false);
        } else if (XUHelper.isBCPresent() && tile instanceof IPowerReceptor && (machine = ((IPowerReceptor)tile).getPowerReceiver(side)) != null) {
            int e = TileEntityTransferNodeEnergy.BCtoRF(TileEntityTransferNodeEnergy.getEnergyIn(machine));
            double a = machine.receiveEnergy(PowerHandler.Type.PIPE, TileEntityTransferNodeEnergy.RFtoBC(storage.extractEnergy(e, true)), side);
            storage.extractEnergy(TileEntityTransferNodeEnergy.BCtoRF(a), true);
        }
    }

    public int transferLimit() {
        return this.storage.getMaxEnergyStored();
    }

    public boolean shouldTransmit() {
        return true;
    }

    public int getMaxCoolDown() {
        return 200;
    }

    public boolean addCoolDown(double coolDown, boolean simulate) {
        if (this.coolDown > 0.0) {
            return false;
        }
        if (!simulate) {
            this.coolDown += coolDown;
        }
        return true;
    }

    public boolean processInput() {
        return false;
    }

    public double genLevel() {
        return 0.0;
    }

    public FluidTank[] getTanks() {
        return new FluidTank[0];
    }

    public InventoryGeneric getInventory() {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (nbt.func_82582_d()) {
            throw new RuntimeException("NBT tags are empty - NBT = " + nbt.toString());
        }
        super.func_145839_a(nbt);
        if (!nbt.func_74764_b("Energy")) {
            throw new RuntimeException("Missing NBT Data - NBT = " + nbt.toString());
        }
        this.storage.readFromNBT(nbt);
        if (this.getInventory() != null) {
            this.getInventory().readFromNBT(nbt);
        }
        if (this.getTanks() != null) {
            for (int i = 0; i < this.getTanks().length; ++i) {
                this.getTanks()[i].readFromNBT(nbt.func_74775_l("Tank_" + i));
            }
        }
        this.rotation = (byte)nbt.func_74762_e("rotation");
        this.coolDown = nbt.func_74769_h("coolDown");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        this.storage.writeToNBT(nbt);
        if (this.getInventory() != null) {
            this.getInventory().writeToNBT(nbt);
        }
        if (this.getTanks() != null) {
            for (int i = 0; i < this.getTanks().length; ++i) {
                NBTTagCompound t = new NBTTagCompound();
                this.getTanks()[i].writeToNBT(t);
                nbt.func_74782_a("Tank_" + i, (NBTBase)t);
            }
        }
        nbt.func_74768_a("rotation", (int)this.rotation);
        nbt.func_74780_a("coolDown", this.coolDown);
        super.func_145841_b(nbt);
        NBTTagCompound backup = new NBTTagCompound();
        super.func_145841_b(backup);
        nbt.func_74782_a("backup", (NBTBase)backup);
    }

    public Packet func_145844_m() {
        NBTTagCompound t = new NBTTagCompound();
        t.func_74774_a("d", this.rotation);
        return new S35PacketUpdateTileEntity(this.x(), this.y(), this.z(), 4, t);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (pkt.func_148857_g().func_74764_b("d")) {
            if (pkt.func_148857_g().func_74771_c("d") != this.rotation) {
                this.field_145850_b.func_147471_g(this.x(), this.y(), this.z());
            }
            this.rotation = pkt.func_148857_g().func_74771_c("d");
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(Math.min(this.transferLimit(), maxExtract), simulate);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int c = 0;
        for (FluidTank tank : this.getTanks()) {
            c += tank.fill(resource, doFill);
        }
        return c;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] info = new FluidTankInfo[this.getTanks().length];
        for (int i = 0; i < this.getTanks().length; ++i) {
            info[i] = this.getTanks()[i].getInfo();
        }
        return info;
    }

    public int getSizeInventory() {
        return this.getInventory().func_70302_i_();
    }

    public ItemStack getStackInSlot(int i) {
        return this.getInventory().func_70301_a(i);
    }

    public ItemStack decrStackSize(int i, int j) {
        return this.getInventory().func_70298_a(i, j);
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        return this.getInventory().func_70304_b(i);
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.getInventory().func_70299_a(i, itemstack);
    }

    public String getInventoryName() {
        return this.getInventory().func_145825_b();
    }

    public boolean hasCustomInventoryName() {
        return this.getInventory().func_145818_k_();
    }

    public int getInventoryStackLimit() {
        return this.getInventory().func_70297_j_();
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.getInventory().func_70300_a(entityplayer);
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return this.getInventory().func_94041_b(i, itemstack);
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        if (this.slots == null) {
            int t = this.getSizeInventory();
            this.slots = new int[t];
            for (int i = 0; i < t; ++i) {
                this.slots[i] = i;
            }
        }
        return this.slots;
    }

    public boolean canInsertItem(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return true;
    }

    public boolean canExtractItem(int i, ItemStack itemstack, int j) {
        return true;
    }

    public void readInvFromTags(NBTTagCompound tags) {
        if (tags.func_74764_b("Energy")) {
            this.storage.readFromNBT(tags);
        }
    }

    public void writeInvToTags(NBTTagCompound tags) {
        if (this.storage.getEnergyStored() > 0) {
            this.storage.writeToNBT(tags);
        }
    }
}

