/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.generator;

import com.rwtema.extrautils.tileentity.generator.TileEntityGeneratorFurnace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionHelper;

public class TileEntityGeneratorPotion
extends TileEntityGeneratorFurnace {
    public static Map<Integer, Integer> powerMap = new HashMap<Integer, Integer>();
    int curLevel = 0;

    public static void genPotionLevels() {
        HashSet<Item> ingredientIDs = new HashSet<Item>();
        ArrayList<Integer> potionIDs = new ArrayList<Integer>();
        for (Object anItemRegistry : Item.field_150901_e) {
            Item i = (Item)anItemRegistry;
            for (int meta = 0; meta < 16; ++meta) {
                if (!i.func_150892_m(new ItemStack(i, 1, meta))) continue;
                ingredientIDs.add(i);
            }
        }
        powerMap.put(0, 0);
        potionIDs.add(0);
        for (int i = 0; i < potionIDs.size(); ++i) {
            int potion = (Integer)potionIDs.get(i);
            for (Item ingredient : ingredientIDs) {
                String k = "";
                String s = "";
                for (int meta = 0; meta < 16 || !k.equals(s); ++meta) {
                    if (!ingredient.func_150892_m(new ItemStack(ingredient, 1, meta))) continue;
                    try {
                        s = ingredient.func_150896_i(new ItemStack(ingredient, 1, meta));
                        int c = PotionHelper.func_77913_a((int)potion, (String)s);
                        if (!potionIDs.contains(c)) {
                            potionIDs.add(c);
                            powerMap.put(c, powerMap.get(potion) + 1);
                        }
                        k = s == null ? "" : s;
                        continue;
                    }
                    catch (Exception err) {
                        throw new RuntimeException("Caught error while applying potion ingredient " + ingredient.toString() + " to " + potion, err);
                    }
                }
            }
        }
    }

    @Override
    public int transferLimit() {
        return Math.max(400, (int)this.genLevel());
    }

    @Override
    public double genLevel() {
        return 20 * (int)Math.pow(2.0, this.curLevel);
    }

    public int getPotionLevel(ItemStack item) {
        if (item != null && item.func_77973_b() == Items.field_151068_bn && powerMap.containsKey(item.func_77960_j())) {
            return powerMap.get(item.func_77960_j());
        }
        return 0;
    }

    @Override
    public double getFuelBurn(ItemStack item) {
        if (this.getPotionLevel(item) == 0) {
            return 0.0;
        }
        return 1600.0;
    }

    @Override
    public boolean processInput() {
        if (this.coolDown > 0.0) {
            return false;
        }
        int c = this.getPotionLevel(this.inv.func_70301_a(0));
        if (c > 0) {
            this.addCoolDown(this.getFuelBurn(this.inv.func_70301_a(0)), false);
            this.curLevel = c;
            this.inv.func_70301_a(0).func_77964_b(0);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.curLevel = nbt.func_74762_e("curLevel");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("curLevel", this.curLevel);
    }
}

