/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class InvHelper {
    public static int[] getSlots(IInventory inv, int side) {
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_94128_d(side);
        }
        if (inv != null) {
            int size = inv.func_70302_i_();
            int[] arr = new int[size];
            for (int i = 0; i < size; ++i) {
                arr[i] = i;
            }
            return arr;
        }
        return new int[0];
    }

    public static boolean canStack(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        return a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j() && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static boolean sameType(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        if (InvHelper.canStack(a, b)) {
            return true;
        }
        int t = OreDictionary.getOreID((ItemStack)a);
        return t != -1 && t == OreDictionary.getOreID((ItemStack)b);
    }

    public static boolean sameMod(ItemStack a, ItemStack b) {
        return a != null && b != null && (InvHelper.canStack(a, b) || a.func_77973_b() == b.func_77973_b() || InvHelper.getModID(a).equals(InvHelper.getModID(b)));
    }

    public static String getModID(ItemStack item) {
        ModContainer ID = InvHelper.getModForItemStack(item);
        if (ID == null || ID.getModId() == null) {
            return "Unknown";
        }
        return ID.getModId();
    }

    public static ModContainer getModForItemStack(ItemStack stack) {
        ModContainer container;
        Item item = stack.func_77973_b();
        Class<?> klazz = null;
        if (item == null) {
            return null;
        }
        GameRegistry.UniqueIdentifier identifier = GameRegistry.findUniqueIdentifierFor((Item)item);
        klazz = item.getClass();
        if (identifier == null && item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).field_150939_a;
            identifier = GameRegistry.findUniqueIdentifierFor((Block)block);
            klazz = block.getClass();
        }
        Map modList = Loader.instance().getIndexedModList();
        if (identifier != null && (container = (ModContainer)modList.get(identifier.modId)) != null) {
            return container;
        }
        String[] itemClassParts = klazz.getName().split("\\.");
        ModContainer closestMatch = null;
        int mostMatchingPackages = 0;
        for (Map.Entry entry2 : modList.entrySet()) {
            Object mod = ((ModContainer)entry2.getValue()).getMod();
            if (mod == null) continue;
            String[] modClassParts = mod.getClass().getName().split("\\.");
            int packageMatches = 0;
            for (int i = 0; i < modClassParts.length && i < itemClassParts.length && itemClassParts[i] != null && itemClassParts[i].equals(modClassParts[i]); ++i) {
                ++packageMatches;
            }
            if (packageMatches <= mostMatchingPackages) continue;
            mostMatchingPackages = packageMatches;
            closestMatch = (ModContainer)entry2.getValue();
        }
        return closestMatch;
    }
}

