/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.network.NetworkHandler;
import com.rwtema.extrautils.tileentity.enderquarry.IChunkLoad;
import com.rwtema.extrautils.tileentity.transfernodes.TNHelper;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityRetrievalNodeInventory;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityRetrievalNodeLiquid;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNodeEnderRegistry;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNodeEnergy;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNodeInventory;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNodeLiquid;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNodeUpgradeInventory;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INode;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipe;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipeCosmetic;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.StdPipes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityTransferNode
extends TileEntity
implements IPipe,
INode,
IPipeCosmetic,
IChunkLoad {
    public static int baseMaxCoolDown = 10;
    public int pipe_x = 0;
    public int pipe_y = 0;
    public int pipe_z = 0;
    public int pipe_dir = 6;
    public int pipe_type = 0;
    public float pr = 1.0f;
    public float pg = 0.0f;
    public float pb = 0.0f;
    public TileEntityTransferNodeUpgradeInventory upgrades = new TileEntityTransferNodeUpgradeInventory(4, this);
    public boolean isReceiver = false;
    public String type;
    public INodeBuffer buffer;
    public boolean powered = false;
    public boolean init = false;
    public SearchType searchType = SearchType.RANDOM_WALK;
    public HashSet<SearchPosition> prevSearch = new HashSet();
    public ArrayList<SearchPosition> toSearch = new ArrayList();
    public Random rand = new Random();
    protected int coolDown;
    protected int maxCoolDown = 384;
    protected int stepCoolDown = 1;
    protected boolean oldVersion = false;
    int ptype = 0;

    public TileEntityTransferNode(String s, INodeBuffer buffer) {
        this.type = s;
        this.buffer = buffer;
    }

    public int upgradeNo(int n) {
        if (ExtraUtils.nodeUpgrade == null) {
            return 0;
        }
        int k = 0;
        for (int i = 0; i < this.upgrades.func_70302_i_(); ++i) {
            if (this.upgrades.func_70301_a(i) == null || this.upgrades.func_70301_a(i).func_77973_b() != ExtraUtils.nodeUpgrade || this.upgrades.func_70301_a(i).func_77960_j() != n) continue;
            k += this.upgrades.func_70301_a((int)i).field_77994_a;
        }
        return k;
    }

    public void calcUpgradeModifiers() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        boolean wasReceiver = this.isReceiver;
        this.isReceiver = false;
        this.stepCoolDown = 1;
        SearchType prevSearchType = this.searchType;
        this.searchType = SearchType.RANDOM_WALK;
        int prev_pipe_type = this.pipe_type;
        if (prev_pipe_type == 0 || prev_pipe_type == 8 || prev_pipe_type == 10 || prev_pipe_type == 11 || prev_pipe_type == 12 || prev_pipe_type == 13) {
            this.pipe_type = 0;
        }
        for (int i = 0; i < this.upgrades.func_70302_i_(); ++i) {
            if (this.upgrades.func_70301_a(i) != null && ExtraUtils.nodeUpgrade != null && this.upgrades.func_70301_a(i).func_77973_b() == ExtraUtils.nodeUpgrade) {
                if (this.upgrades.func_70301_a(i).func_77960_j() == 0) {
                    for (int k = 0; k < this.upgrades.func_70301_a((int)i).field_77994_a && this.stepCoolDown < this.maxCoolDown; ++k) {
                        ++this.stepCoolDown;
                    }
                    continue;
                }
                if (this.upgrades.func_70301_a(i).func_77960_j() == 6) {
                    if (!(this.isReceiver || wasReceiver || this.field_145850_b == null || this.field_145850_b.field_72995_K)) {
                        TileEntityTransferNodeEnderRegistry.registerTileEntity(this);
                    }
                    this.isReceiver = true;
                    continue;
                }
                if (this.upgrades.func_70301_a(i).func_77960_j() == 7) {
                    this.searchType = SearchType.DEPTH_FIRST;
                    continue;
                }
                if (this.upgrades.func_70301_a(i).func_77960_j() != 8) continue;
                this.searchType = SearchType.BREADTH_FIRST;
                continue;
            }
            if (this.upgrades.pipeType(this.upgrades.func_70301_a(i)) <= 0) continue;
            this.pipe_type = this.upgrades.pipeType(this.upgrades.func_70301_a(i));
        }
        if (prevSearchType != this.searchType) {
            this.resetSearch();
        }
        if (prev_pipe_type != this.pipe_type) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (wasReceiver && !this.isReceiver) {
            TileEntityTransferNodeEnderRegistry.deregisterTileEntity(this);
        }
    }

    public void updateRedstone() {
        if (this.field_145850_b == null) {
            return;
        }
        this.powered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isPowered() {
        if (!this.init && this.field_145850_b != null) {
            this.powered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.init = true;
        }
        return this.powered;
    }

    @Override
    public boolean checkRedstone() {
        if (this.isPowered()) {
            this.resetSearch();
            return true;
        }
        return false;
    }

    @Override
    public int getNodeX() {
        return this.field_145851_c;
    }

    @Override
    public int getNodeY() {
        return this.field_145848_d;
    }

    @Override
    public int getNodeZ() {
        return this.field_145849_e;
    }

    @Override
    public ForgeDirection getNodeDir() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() % 6));
    }

    @Override
    public int getPipeX() {
        return this.pipe_x;
    }

    @Override
    public int getPipeY() {
        return this.pipe_y;
    }

    @Override
    public int getPipeZ() {
        return this.pipe_z;
    }

    @Override
    public int getPipeDir() {
        return this.pipe_dir;
    }

    @Override
    public List<ItemStack> getUpgrades() {
        ArrayList<ItemStack> u = new ArrayList<ItemStack>();
        for (int i = 0; i < this.upgrades.func_70302_i_(); ++i) {
            if (this.upgrades.func_70301_a(i) == null) continue;
            u.add(this.upgrades.func_70301_a(i));
        }
        return u;
    }

    public void func_145839_a(NBTTagCompound tag) {
        int i;
        super.func_145839_a(tag);
        this.pipe_x = tag.func_74764_b("pipe_x") ? tag.func_74762_e("pipe_x") : 0;
        this.pipe_y = tag.func_74764_b("pipe_y") ? tag.func_74762_e("pipe_y") : 0;
        this.pipe_z = tag.func_74764_b("pipe_z") ? tag.func_74762_e("pipe_z") : 0;
        this.pipe_dir = tag.func_74762_e("pipe_dir");
        this.pipe_type = tag.func_74764_b("pipe_type") ? (int)tag.func_74771_c("pipe_type") : 0;
        for (int i2 = 0; i2 < this.upgrades.func_70302_i_(); ++i2) {
            if (tag.func_74764_b("upgrade_" + i2)) {
                this.upgrades.func_70299_a(i2, ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("upgrade_" + i2)));
                continue;
            }
            this.upgrades.func_70299_a(i2, null);
        }
        this.buffer.readFromNBT(tag);
        NBTTagCompound t = tag.func_74775_l("prevSearch");
        int s = t.func_74762_e("size");
        for (i = 0; i < s; ++i) {
            this.prevSearch.add(SearchPosition.loadFromTag(t.func_74775_l(Integer.toString(i))));
        }
        t = tag.func_74775_l("toSearch");
        s = t.func_74762_e("size");
        for (i = 0; i < s; ++i) {
            this.toSearch.add(SearchPosition.loadFromTag(t.func_74775_l(Integer.toString(i))));
        }
        if (tag.func_74771_c("version") == 0) {
            this.oldVersion = true;
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        if (this.pipe_x != 0) {
            par1NBTTagCompound.func_74768_a("pipe_x", this.pipe_x);
        }
        if (this.pipe_y != 0) {
            par1NBTTagCompound.func_74768_a("pipe_y", this.pipe_y);
        }
        if (this.pipe_z != 0) {
            par1NBTTagCompound.func_74768_a("pipe_z", this.pipe_z);
        }
        if (this.pipe_dir != 0) {
            par1NBTTagCompound.func_74768_a("pipe_dir", this.pipe_dir);
        }
        if (this.pipe_type != 0) {
            par1NBTTagCompound.func_74774_a("pipe_type", (byte)this.pipe_type);
        }
        for (int i = 0; i < this.upgrades.func_70302_i_(); ++i) {
            if (this.upgrades.func_70301_a(i) == null) continue;
            NBTTagCompound newItem = new NBTTagCompound();
            this.upgrades.func_70301_a(i).func_77955_b(newItem);
            par1NBTTagCompound.func_74782_a("upgrade_" + i, (NBTBase)newItem);
        }
        this.buffer.writeToNBT(par1NBTTagCompound);
        NBTTagCompound t2 = new NBTTagCompound();
        t2.func_74768_a("size", this.prevSearch.size());
        int i = 0;
        for (SearchPosition p : this.prevSearch) {
            t2.func_74782_a(Integer.toString(i), (NBTBase)p.getTag());
            ++i;
        }
        NBTTagCompound t3 = new NBTTagCompound();
        t3.func_74768_a("size", this.toSearch.size());
        for (i = 0; i < this.toSearch.size(); ++i) {
            t3.func_74782_a(Integer.toString(i), (NBTBase)this.toSearch.get(i).getTag());
        }
        par1NBTTagCompound.func_74782_a("prevSearch", (NBTBase)t2);
        par1NBTTagCompound.func_74782_a("toSearch", (NBTBase)t3);
        if (!this.oldVersion) {
            par1NBTTagCompound.func_74774_a("version", (byte)1);
        }
    }

    public int getType() {
        if (this.ptype == 0) {
            this.ptype = -1;
            Class<?> clazz = this.getClass();
            if (clazz.equals(TileEntityTransferNodeInventory.class)) {
                this.ptype = 3;
            } else if (clazz.equals(TileEntityTransferNodeLiquid.class)) {
                this.ptype = 4;
            } else if (clazz.equals(TileEntityRetrievalNodeInventory.class)) {
                this.ptype = 5;
            } else if (clazz.equals(TileEntityRetrievalNodeLiquid.class)) {
                this.ptype = 6;
            } else if (clazz.equals(TileEntityTransferNodeEnergy.class)) {
                this.ptype = 7;
            }
        }
        return this.ptype;
    }

    public void sendParticleUpdate() {
        if (ExtraUtils.disableNodeParticles) {
            return;
        }
        NetworkHandler.sendParticleEvent(this.field_145850_b, this.getType(), this.field_145851_c + this.pipe_x, this.field_145848_d + this.pipe_y, this.field_145849_e + this.pipe_z);
    }

    public boolean handleInventories() {
        boolean advance = false;
        boolean rr = this.upgradeNo(9) != 0;
        boolean ss = this.buffer.shouldSearch();
        if (ss) {
            IPipe pipe = TNHelper.getPipe((IBlockAccess)this.field_145850_b, this.field_145851_c + this.pipe_x, this.field_145848_d + this.pipe_y, this.field_145849_e + this.pipe_z);
            if (pipe != null) {
                this.sendParticleUpdate();
                advance = pipe.transferItems((IBlockAccess)this.field_145850_b, this.field_145851_c + this.pipe_x, this.field_145848_d + this.pipe_y, this.field_145849_e + this.pipe_z, ForgeDirection.getOrientation((int)this.pipe_dir), this.buffer);
            } else {
                this.resetSearch();
                return false;
            }
        }
        if (rr) {
            return ss;
        }
        if (!this.buffer.shouldSearch()) {
            this.resetSearch();
            return false;
        }
        return advance;
    }

    public boolean advPipeSearch() {
        IPipe pipeBlock;
        if (this.pipe_dir == 6) {
            this.pipe_dir = this.getNodeDir().getOpposite().ordinal();
        }
        if ((pipeBlock = TNHelper.getPipe((IBlockAccess)this.field_145850_b, this.field_145851_c + this.pipe_x, this.field_145848_d + this.pipe_y, this.field_145849_e + this.pipe_z)) != null) {
            this.prevSearch.add(new SearchPosition(this.pipe_x, this.pipe_y, this.pipe_z, ForgeDirection.getOrientation((int)this.pipe_dir)));
            ArrayList<ForgeDirection> dirs = pipeBlock.getOutputDirections((IBlockAccess)this.field_145850_b, this.field_145851_c + this.pipe_x, this.field_145848_d + this.pipe_y, this.field_145849_e + this.pipe_z, ForgeDirection.getOrientation((int)this.pipe_dir), this.buffer);
            switch (this.searchType) {
                case RANDOM_WALK: {
                    if (dirs.isEmpty()) break;
                    this.toSearch.add(new SearchPosition(this.pipe_x, this.pipe_y, this.pipe_z, dirs.get(0)).adv());
                    break;
                }
                case DEPTH_FIRST: {
                    for (ForgeDirection d : dirs) {
                        SearchPosition s = new SearchPosition(this.pipe_x, this.pipe_y, this.pipe_z, d).adv();
                        if (this.prevSearch.contains(s) || this.toSearch.contains(s)) continue;
                        if (this.toSearch.isEmpty()) {
                            this.toSearch.add(new SearchPosition(this.pipe_x, this.pipe_y, this.pipe_z, d).adv());
                            continue;
                        }
                        this.toSearch.add(0, new SearchPosition(this.pipe_x, this.pipe_y, this.pipe_z, d).adv());
                    }
                    break;
                }
                case BREADTH_FIRST: {
                    for (ForgeDirection d : dirs) {
                        SearchPosition s = new SearchPosition(this.pipe_x, this.pipe_y, this.pipe_z, d).adv();
                        if (this.prevSearch.contains(s) || this.toSearch.contains(s)) continue;
                        this.toSearch.add(s);
                    }
                    break;
                }
            }
        }
        if (!this.loadNextPos()) {
            this.pipe_dir = this.getNodeDir().getOpposite().ordinal();
            this.resetSearch();
            return false;
        }
        return true;
    }

    public void resetSearch() {
        if (this.pipe_x != 0 || this.pipe_y != 0 || this.pipe_z != 0 || !this.prevSearch.isEmpty()) {
            this.pipe_x = 0;
            this.pipe_y = 0;
            this.pipe_z = 0;
            this.pipe_dir = -1;
            this.toSearch.clear();
            this.prevSearch.clear();
        }
    }

    public boolean loadNextPos() {
        if (this.toSearch.isEmpty()) {
            return false;
        }
        SearchPosition pos = this.toSearch.remove(0);
        if (this.searchType != SearchType.RANDOM_WALK) {
            while (this.prevSearch.contains(pos) && !this.toSearch.isEmpty()) {
                pos = this.toSearch.remove(0);
            }
            if (this.prevSearch.contains(pos)) {
                return false;
            }
            this.prevSearch.add(pos.copy());
        }
        this.pipe_x = pos.x;
        this.pipe_y = pos.y;
        this.pipe_z = pos.z;
        this.pipe_dir = pos.side.ordinal();
        return true;
    }

    public Packet func_145844_m() {
        NBTTagCompound t = new NBTTagCompound();
        t.func_74774_a("d", (byte)this.pipe_type);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 4, t);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (pkt.func_148857_g().func_74764_b("d")) {
            if (pkt.func_148857_g().func_74771_c("d") != this.pipe_type) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.pipe_type = pkt.func_148857_g().func_74771_c("d");
        }
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onWorldLeave();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.onWorldJoin();
    }

    @Override
    public void onChunkLoad() {
    }

    public void onWorldJoin() {
        this.buffer.setNode(this);
        this.calcUpgradeModifiers();
    }

    public void onWorldLeave() {
        TileEntityTransferNodeEnderRegistry.deregisterTileEntity(this);
    }

    @Override
    public ArrayList<ForgeDirection> getOutputDirections(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        return StdPipes.getPipeType(this.pipe_type).getOutputDirections(world, x, y, z, dir, buffer);
    }

    @Override
    public boolean transferItems(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        return StdPipes.getPipeType(this.pipe_type).transferItems(world, x, y, z, dir, buffer);
    }

    @Override
    public boolean canInput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return dir != this.getNodeDir() && StdPipes.getPipeType(this.pipe_type).canInput(world, x, y, z, dir);
    }

    @Override
    public boolean canOutput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return dir != this.getNodeDir() && StdPipes.getPipeType(this.pipe_type).canOutput(world, x, y, z, dir);
    }

    @Override
    public int limitTransfer(TileEntity dest, ForgeDirection side, INodeBuffer buffer) {
        return StdPipes.getPipeType(this.pipe_type).limitTransfer(dest, side, buffer);
    }

    @Override
    public IInventory getFilterInventory(IBlockAccess world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean shouldConnectToTile(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return dir != this.getNodeDir() && StdPipes.getPipeType(this.pipe_type).shouldConnectToTile(world, x, y, z, dir);
    }

    @Override
    public IIcon baseTexture() {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.pipe_type))).baseTexture();
    }

    @Override
    public IIcon pipeTexture(ForgeDirection dir, boolean blocked) {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.pipe_type))).pipeTexture(dir, blocked);
    }

    @Override
    public IIcon invPipeTexture(ForgeDirection dir) {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.pipe_type))).invPipeTexture(dir);
    }

    @Override
    public IIcon socketTexture(ForgeDirection dir) {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.pipe_type))).socketTexture(dir);
    }

    @Override
    public String getPipeType() {
        return StdPipes.getPipeType(this.pipe_type).getPipeType();
    }

    @Override
    public float baseSize() {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.pipe_type))).baseSize();
    }

    @Override
    public TileEntityTransferNode getNode() {
        return this;
    }

    @Override
    public String getNodeType() {
        return this.type;
    }

    public void update() {
    }

    public boolean initDirection() {
        return false;
    }

    public static class SearchPosition {
        public ForgeDirection side = ForgeDirection.UNKNOWN;
        public int x;
        public int y;
        public int z;

        public SearchPosition(int par1, int par2, int par3, ForgeDirection par4) {
            this.x = par1;
            this.y = par2;
            this.z = par3;
            this.side = par4;
        }

        public static byte getOrd(ForgeDirection e) {
            return (byte)e.ordinal();
        }

        public static SearchPosition loadFromTag(NBTTagCompound tag) {
            return new SearchPosition(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), ForgeDirection.getOrientation((int)tag.func_74771_c("side")));
        }

        public SearchPosition copy() {
            return new SearchPosition(this.x, this.y, this.z, this.side);
        }

        public String toString() {
            return "SearchPosition{side=" + this.side + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
        }

        public SearchPosition adv() {
            this.x += this.side.offsetX;
            this.y += this.side.offsetY;
            this.z += this.side.offsetZ;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchPosition that = (SearchPosition)o;
            if (this.effectiveX() != that.effectiveX()) {
                return false;
            }
            return this.effectiveY() == that.effectiveY() && this.effectiveZ() == that.effectiveZ();
        }

        public int effectiveX() {
            return this.x * 2 - this.side.offsetX;
        }

        public int effectiveY() {
            return this.y * 2 - this.side.offsetY;
        }

        public int effectiveZ() {
            return this.z * 2 - this.side.offsetZ;
        }

        public int hashCode() {
            int result = this.effectiveX();
            result = 31 * result + this.effectiveY();
            result = 31 * result + this.effectiveZ();
            return result;
        }

        public NBTTagCompound getTag() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("x", this.x);
            tag.func_74768_a("y", this.y);
            tag.func_74768_a("z", this.z);
            tag.func_74774_a("side", (byte)this.side.ordinal());
            return tag;
        }
    }

    public static enum SearchType {
        RANDOM_WALK,
        DEPTH_FIRST,
        BREADTH_FIRST;

    }
}

