/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes.multiparts;

import buildcraft.api.tools.IToolWrench;
import codechicken.lib.vec.Cuboid6;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.INeighborTileChange;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.XUHelper;
import com.rwtema.extrautils.block.Box;
import com.rwtema.extrautils.block.BoxModel;
import com.rwtema.extrautils.tileentity.transfernodes.BlockTransferPipe;
import com.rwtema.extrautils.tileentity.transfernodes.multiparts.DummyPipePart;
import com.rwtema.extrautils.tileentity.transfernodes.multiparts.MCMetaTilePart;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipe;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipeCosmetic;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.StdPipes;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PipePart
extends MCMetaTilePart
implements ISidedHollowConnect,
IPipe,
IPipeCosmetic,
INeighborTileChange,
TSlottedPart {
    public static DummyPipePart[] dummyPipes = new DummyPipePart[6];
    public int blockMasks = -1;
    public byte[] flagmasks = new byte[]{1, 2, 4, 8, 16, 32};

    public PipePart(int meta) {
        super(meta);
    }

    public PipePart() {
    }

    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(new ItemStack(this.getBlock(), 1, ExtraUtils.transferPipe.func_149692_a(this.getMetadata())));
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack(this.getBlock(), 1, ExtraUtils.transferPipe.func_149692_a(this.getMetadata()));
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(new Cuboid6((double)(0.5f - this.baseSize()), (double)(0.5f - this.baseSize()), (double)(0.5f - this.baseSize()), (double)(0.5f + this.baseSize()), (double)(0.5f + this.baseSize()), (double)(0.5f + this.baseSize())));
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (this.getWorld().field_72995_K) {
            return true;
        }
        if (item != null && (item.func_77973_b() == Items.field_151055_y || XUHelper.bcWrenchPresent() && item.func_77973_b() instanceof IToolWrench)) {
            if (XUHelper.bcWrenchPresent() && item.func_77973_b() instanceof IToolWrench && !((IToolWrench)item.func_77973_b()).canWrench(player, part.field_72311_b, part.field_72312_c, part.field_72309_d)) {
                return false;
            }
            int newmetadata = StdPipes.getNextPipeType((IBlockAccess)this.getWorld(), part.field_72311_b, part.field_72312_c, part.field_72309_d, this.meta);
            this.meta = (byte)newmetadata;
            this.sendDescUpdate();
            if (XUHelper.bcWrenchPresent() && item.func_77973_b() instanceof IToolWrench) {
                ((IToolWrench)item.func_77973_b()).wrenchUsed(player, part.field_72311_b, part.field_72312_c, part.field_72309_d);
            }
            return true;
        }
        return false;
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(0.5 - (double)this.baseSize(), 0.5 - (double)this.baseSize(), 0.5 - (double)this.baseSize(), 0.5 + (double)this.baseSize(), 0.5 + (double)this.baseSize(), 0.5 + (double)this.baseSize());
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> t2 = new ArrayList<Cuboid6>();
        BoxModel model = ((BlockTransferPipe)ExtraUtils.transferPipe).getWorldModel((IBlockAccess)this.world(), this.x(), this.y(), this.z());
        for (Box box : model) {
            t2.add(new Cuboid6((double)box.minX, (double)box.minY, (double)box.minZ, (double)box.maxX, (double)box.maxY, (double)box.maxZ));
        }
        return t2;
    }

    public Block getBlock() {
        return ExtraUtils.transferPipe;
    }

    public String getType() {
        return "extrautils:transfer_pipe";
    }

    @Override
    public ArrayList<ForgeDirection> getOutputDirections(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        return StdPipes.getPipeType(this.meta).getOutputDirections(world, x, y, z, dir, buffer);
    }

    @Override
    public boolean transferItems(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        return StdPipes.getPipeType(this.meta).transferItems(world, x, y, z, dir, buffer);
    }

    @Override
    public boolean canInput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return !this.isBlocked(dir) && StdPipes.getPipeType(this.meta).canInput(world, x, y, z, dir);
    }

    @Override
    public boolean canOutput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return !this.isBlocked(dir) && StdPipes.getPipeType(this.meta).canOutput((IBlockAccess)this.getWorld(), x, y, z, dir);
    }

    @Override
    public int limitTransfer(TileEntity dest, ForgeDirection side, INodeBuffer buffer) {
        return StdPipes.getPipeType(this.meta).limitTransfer(dest, side, buffer);
    }

    @Override
    public IInventory getFilterInventory(IBlockAccess world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean shouldConnectToTile(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return !this.isBlocked(dir) && StdPipes.getPipeType(this.meta).shouldConnectToTile(world, x, y, z, dir);
    }

    public void reloadBlockMasks() {
        this.blockMasks = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            PipePart.dummyPipes[dir.ordinal()].h = 0.5f - this.baseSize();
            if (this.tile().canAddPart((TMultiPart)dummyPipes[dir.ordinal()])) continue;
            this.blockMasks |= this.flagmasks[dir.ordinal()];
        }
    }

    public void onPartChanged(TMultiPart part) {
        this.reloadBlockMasks();
    }

    public void onNeighborChanged() {
        this.reloadBlockMasks();
    }

    public boolean isBlocked(ForgeDirection dir) {
        if (this.blockMasks < 0) {
            this.reloadBlockMasks();
        }
        return (this.blockMasks & this.flagmasks[dir.ordinal()]) == this.flagmasks[dir.ordinal()];
    }

    @Override
    public IIcon baseTexture() {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.meta))).baseTexture();
    }

    @Override
    public IIcon socketTexture(ForgeDirection dir) {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.meta))).socketTexture(dir);
    }

    @Override
    public IIcon pipeTexture(ForgeDirection dir, boolean blocked) {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.meta))).pipeTexture(dir, blocked);
    }

    @Override
    public IIcon invPipeTexture(ForgeDirection dir) {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.meta))).invPipeTexture(dir);
    }

    @Override
    public String getPipeType() {
        return StdPipes.getPipeType(this.meta).getPipeType();
    }

    @Override
    public float baseSize() {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.meta))).baseSize();
    }

    public boolean occlusionTest(TMultiPart npart) {
        return npart instanceof DummyPipePart || super.occlusionTest(npart);
    }

    public void onNeighborTileChanged(int arg0, boolean arg1) {
        this.reloadBlockMasks();
    }

    public boolean weakTileChanges() {
        return true;
    }

    public int getSlotMask() {
        return 64;
    }

    public int getHollowSize(int side) {
        return 6;
    }

    @Override
    public TileEntity getBlockTile() {
        return this.tile();
    }

    static {
        for (int i = 0; i < 6; ++i) {
            PipePart.dummyPipes[i] = new DummyPipePart(i, 0.375f);
        }
    }
}

