/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes.multiparts;

import buildcraft.api.tools.IToolWrench;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.XUHelper;
import com.rwtema.extrautils.block.Box;
import com.rwtema.extrautils.block.BoxModel;
import com.rwtema.extrautils.tileentity.transfernodes.BlockTransferNode;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNode;
import com.rwtema.extrautils.tileentity.transfernodes.multiparts.DummyPipePart;
import com.rwtema.extrautils.tileentity.transfernodes.multiparts.MCMetaTilePart;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INode;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipeCosmetic;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.StdPipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import scala.util.Random;

public abstract class TransferNodePart
extends MCMetaTilePart
implements INode,
IPipeCosmetic,
ISidedHollowConnect,
TSlottedPart,
TFacePart {
    public static Random rand = new Random();
    private static DummyPipePart[] dummyPipes = new DummyPipePart[6];
    public TileEntityTransferNode node;
    public boolean valid = true;
    public boolean init = false;
    public int blockMasks = -1;
    public byte[] flagmasks = new byte[]{1, 2, 4, 8, 16, 32};
    int id = rand.nextInt();

    public TransferNodePart(int meta, TileEntityTransferNode node) {
        super(meta);
        this.node = node;
        node.field_145847_g = meta;
    }

    public TransferNodePart(TileEntityTransferNode node) {
        this.node = node;
        node.field_145847_g = this.meta;
    }

    @Override
    public TileEntity getBlockTile() {
        return this.tile();
    }

    public int getHollowSize(int side) {
        return 6;
    }

    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(new ItemStack(this.getBlock(), 1, this.getBlock().func_149692_a((int)this.meta)));
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack(this.getBlock(), 1, this.getBlock().func_149692_a(this.getMetadata()));
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (this.getWorld().field_72995_K) {
            return true;
        }
        if (item != null && (item.func_77973_b() == Items.field_151055_y || XUHelper.bcWrenchPresent() && item.func_77973_b() instanceof IToolWrench)) {
            if (XUHelper.bcWrenchPresent() && item.func_77973_b() instanceof IToolWrench && !((IToolWrench)item.func_77973_b()).canWrench(player, part.field_72311_b, part.field_72312_c, part.field_72309_d)) {
                return false;
            }
            int newmetadata = StdPipes.getNextPipeType((IBlockAccess)this.getWorld(), part.field_72311_b, part.field_72312_c, part.field_72309_d, this.getNode().pipe_type);
            this.getNode().pipe_type = (byte)newmetadata;
            this.sendDescUpdate();
            if (XUHelper.bcWrenchPresent() && item.func_77973_b() instanceof IToolWrench) {
                ((IToolWrench)item.func_77973_b()).wrenchUsed(player, part.field_72311_b, part.field_72312_c, part.field_72309_d);
            }
            return true;
        }
        player.openGui((Object)ExtraUtils.instance, 0, this.getWorld(), this.x(), this.y(), this.z());
        return true;
    }

    public void onRemoved() {
        if (!this.getWorld().field_72995_K) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (int i = 0; i < this.node.upgrades.func_70302_i_(); ++i) {
                if (this.node.upgrades.func_70301_a(i) == null) continue;
                drops.add(this.node.upgrades.func_70301_a(i));
            }
            this.tile().dropItems(drops);
        }
    }

    public void onWorldJoin() {
        if (this.getWorld() != null) {
            this.node.func_145834_a(this.getWorld());
        }
        this.node.field_145851_c = this.x();
        this.node.field_145848_d = this.y();
        this.node.field_145849_e = this.z();
        this.node.onWorldJoin();
        this.reloadBlockMasks();
    }

    public void onWorldSeparate() {
        this.node.func_145843_s();
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList t = new ArrayList();
        ArrayList<Cuboid6> t2 = new ArrayList<Cuboid6>();
        ExtraUtils.transferNode.func_149743_a(this.getWorld(), this.x(), this.y(), this.z(), AxisAlignedBB.func_72332_a().func_72299_a((double)this.x(), (double)this.y(), (double)this.z(), (double)(this.x() + 1), (double)(this.y() + 1), (double)(this.z() + 1)), t, null);
        for (AxisAlignedBB aT : t) {
            t2.add(new Cuboid6(aT.field_72340_a, aT.field_72338_b, aT.field_72339_c, aT.field_72336_d, aT.field_72337_e, aT.field_72334_f).sub(new Vector3((double)this.x(), (double)this.y(), (double)this.z())));
        }
        return t2;
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        NBTTagCompound subtag = new NBTTagCompound();
        this.node.func_145841_b(subtag);
        tag.func_74782_a("node", (NBTBase)subtag);
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.node.func_145839_a(tag.func_74775_l("node"));
    }

    public boolean doesTick() {
        return true;
    }

    public void update() {
        if (this.node != null && !this.world().field_72995_K) {
            this.node.field_145847_g = this.meta;
            if (this.getWorld().func_147438_o(this.x(), this.y(), this.z()) == this.tile()) {
                if (this.node.func_145831_w() == null) {
                    this.onWorldJoin();
                }
                this.node.func_145845_h();
            }
        }
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)this.meta);
        packet.writeByte(this.node.pipe_type);
    }

    public void readDesc(MCDataInput packet) {
        this.meta = packet.readByte();
        this.node.pipe_type = packet.readByte();
    }

    public Block getBlock() {
        return ExtraUtils.transferNode;
    }

    @Override
    public int getNodeX() {
        return this.node.getNodeX();
    }

    @Override
    public int getNodeY() {
        return this.node.getNodeY();
    }

    @Override
    public int getNodeZ() {
        return this.node.getNodeZ();
    }

    @Override
    public ForgeDirection getNodeDir() {
        this.node.field_145847_g = this.meta;
        return this.node.getNodeDir();
    }

    @Override
    public int getPipeX() {
        return this.node.getPipeX();
    }

    @Override
    public int getPipeY() {
        return this.node.getPipeY();
    }

    @Override
    public int getPipeZ() {
        return this.node.getPipeZ();
    }

    @Override
    public int getPipeDir() {
        return this.node.getPipeDir();
    }

    @Override
    public List<ItemStack> getUpgrades() {
        return this.node.getUpgrades();
    }

    @Override
    public boolean checkRedstone() {
        return this.node.checkRedstone();
    }

    @Override
    public BoxModel getModel(ForgeDirection dir) {
        return this.node.getModel(dir);
    }

    @Override
    public String getNodeType() {
        return this.node.getNodeType();
    }

    @Override
    public boolean transferItems(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        return this.getNode().transferItems(world, x, y, z, dir, buffer);
    }

    @Override
    public boolean canInput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return !this.isBlocked(dir) && this.getNode().canInput(world, x, y, z, dir);
    }

    @Override
    public ArrayList<ForgeDirection> getOutputDirections(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        return this.getNode().getOutputDirections(world, x, y, z, dir, buffer);
    }

    @Override
    public boolean canOutput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return !this.isBlocked(dir) && this.getNode().canOutput(world, x, y, z, dir);
    }

    @Override
    public int limitTransfer(TileEntity dest, ForgeDirection side, INodeBuffer buffer) {
        return this.getNode().limitTransfer(dest, side, buffer);
    }

    @Override
    public IInventory getFilterInventory(IBlockAccess world, int x, int y, int z) {
        return this.getNode().getFilterInventory(world, x, y, z);
    }

    @Override
    public boolean shouldConnectToTile(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return !this.isBlocked(dir) && this.getNode().shouldConnectToTile(world, x, y, z, dir);
    }

    public void reloadBlockMasks() {
        this.blockMasks = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TransferNodePart.dummyPipes[dir.ordinal()].h = 0.5f + this.baseSize();
            if (dir == this.getNodeDir()) {
                this.blockMasks |= this.flagmasks[dir.ordinal()];
                continue;
            }
            if (this.tile().canAddPart((TMultiPart)dummyPipes[dir.ordinal()])) continue;
            this.blockMasks |= this.flagmasks[dir.ordinal()];
        }
    }

    public void onPartChanged(TMultiPart part) {
        this.reloadBlockMasks();
    }

    public void onNeighborChanged() {
        this.node.updateRedstone();
        this.reloadBlockMasks();
    }

    public boolean isBlocked(ForgeDirection dir) {
        if (this.node.func_145831_w() == null) {
            this.onWorldJoin();
        }
        if (this.blockMasks < 0) {
            this.reloadBlockMasks();
        }
        return (this.blockMasks & this.flagmasks[dir.ordinal()]) == this.flagmasks[dir.ordinal()];
    }

    @Override
    public IIcon baseTexture() {
        return this.getNode().baseTexture();
    }

    @Override
    public IIcon pipeTexture(ForgeDirection dir, boolean blocked) {
        return this.getNode().pipeTexture(dir, blocked);
    }

    @Override
    public IIcon invPipeTexture(ForgeDirection dir) {
        return this.getNode().invPipeTexture(dir);
    }

    @Override
    public IIcon socketTexture(ForgeDirection dir) {
        return this.getNode().socketTexture(dir);
    }

    @Override
    public String getPipeType() {
        return this.getNode().getPipeType();
    }

    @Override
    public float baseSize() {
        return this.getNode().baseSize();
    }

    public boolean occlusionTest(TMultiPart npart) {
        return npart instanceof DummyPipePart || super.occlusionTest(npart);
    }

    public Cuboid6 getBounds() {
        Box bounds = ((BlockTransferNode)this.getBlock()).getWorldModel((IBlockAccess)this.getWorld(), this.x(), this.y(), this.z()).boundingBox();
        return new Cuboid6((double)bounds.minX, (double)bounds.minY, (double)bounds.minZ, (double)bounds.maxX, (double)bounds.maxY, (double)bounds.maxZ);
    }

    public int getSlotMask() {
        if (this.getNode().getNodeDir() == ForgeDirection.UNKNOWN) {
            return 64;
        }
        return 0x40 | 1 << this.getNode().getNodeDir().ordinal();
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public boolean solid(int arg0) {
        return false;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            TransferNodePart.dummyPipes[i] = new DummyPipePart(i, 0.625f);
        }
    }
}

