/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes.pipes;

import com.rwtema.extrautils.tileentity.transfernodes.BlockTransferPipe;
import com.rwtema.extrautils.tileentity.transfernodes.TNHelper;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipe;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeEnergy
extends PipeBase {
    public PipeEnergy() {
        super("Energy");
    }

    public PipeEnergy(String type) {
        super(type);
    }

    @Override
    public boolean shouldConnectToTile(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        if (TNHelper.getPipe(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != null) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        return TNHelper.isRFEnergy(tile, dir.getOpposite()) || TNHelper.isBCEnergy(tile, dir.getOpposite());
    }

    @Override
    public boolean canInput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        IPipe pipe = TNHelper.getPipe(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        return pipe != null && pipe.getPipeType().startsWith("Energy");
    }

    @Override
    public IIcon socketTexture(ForgeDirection dir) {
        return BlockTransferPipe.pipes_nozzle_energy;
    }

    @Override
    public IIcon baseTexture() {
        return BlockTransferPipe.pipes_energy;
    }

    @Override
    public IIcon pipeTexture(ForgeDirection dir, boolean blocked) {
        return BlockTransferPipe.pipes_energy;
    }

    @Override
    public IIcon invPipeTexture(ForgeDirection dir) {
        return BlockTransferPipe.pipes_energy;
    }
}

