/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes.pipes;

import com.rwtema.extrautils.tileentity.transfernodes.TNHelper;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipe;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeCrossOver;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeDirectional;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeEnergy;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeEnergyExtract;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeFilter;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeModSorting;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeNonInserting;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeRationing;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeSorting;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeStandard;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class StdPipes {
    public static IPipe[] pipe = new IPipe[15];

    public static IPipe getPipeType(int type) {
        if (type < 0 || type >= pipe.length) {
            return null;
        }
        return pipe[type];
    }

    public static int getNextPipeType(IBlockAccess world, int x, int y, int z, int metadata) {
        if (metadata >= 8) {
            return metadata;
        }
        if ((metadata = (metadata + 1) % 8) == 0 || metadata == 7) {
            return metadata;
        }
        IPipe pipe = TNHelper.getPipe(world, x, y, z);
        if (pipe == null) {
            return metadata;
        }
        int numNeighbors = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!TNHelper.canInput(world, x, y, z, dir) || !TNHelper.canInput(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite())) continue;
            ++numNeighbors;
        }
        if (numNeighbors <= 1) {
            if (metadata >= 1 && metadata <= 6) {
                metadata = 7;
            }
        } else {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(metadata - 1));
            while (!(metadata < 1 || metadata > 6 || TNHelper.canInput(world, x, y, z, dir) && TNHelper.canInput(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite()))) {
                dir = ForgeDirection.getOrientation((int)(++metadata - 1));
            }
        }
        return metadata;
    }

    static {
        StdPipes.pipe[0] = new PipeStandard();
        for (int i = 0; i < 6; ++i) {
            StdPipes.pipe[i + 1] = new PipeDirectional(ForgeDirection.getOrientation((int)i));
        }
        StdPipes.pipe[7] = new PipeNonInserting();
        StdPipes.pipe[8] = new PipeSorting();
        StdPipes.pipe[9] = new PipeFilter();
        StdPipes.pipe[10] = new PipeRationing();
        StdPipes.pipe[11] = new PipeEnergy();
        StdPipes.pipe[12] = new PipeCrossOver();
        StdPipes.pipe[13] = new PipeModSorting();
        StdPipes.pipe[14] = new PipeEnergyExtract();
    }
}

