/*
 * Decompiled with CFR 0.152.
 */
package elliandetector;

import elliandetector.EllianDetector;
import elliandetector.EllianDetector2MinecraftProxy;
import elliandetector.EllianDetectorCalculator;
import elliandetector.EllianDetectorConfiguration;
import elliandetector.EllianDetectorRenderer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class EllianDetectorRunner
implements Runnable {
    private EllianDetector detector = null;
    private boolean enabled = true;
    private String error = "";
    private int fudge = 0;
    private boolean isPressed = false;
    private int refreshTimer = 20000;
    private int timer = 0;
    private int ztimer = 0;
    private boolean threading = true;
    private boolean active = false;
    public Thread runner;

    public EllianDetectorRunner() {
        try {
            this.detector = new EllianDetector();
            EllianDetectorConfiguration.loadBlockColors(this.detector);
            EllianDetectorConfiguration.loadMaterials(this.detector);
            EllianDetectorConfiguration.loadCurrentConf(this.detector);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean OnTickInGame() {
        if (this.runner == null && this.threading) {
            this.runner = new Thread(this);
            this.runner.setPriority(5);
            this.runner.start();
        }
        if (this.enabled && !this.detector.isHidden() && (this.detector.hasPlayerMoved() || this.timer > this.refreshTimer || this.detector.isVertical() && this.detector.isDirectionChanged())) {
            if (this.threading) {
                try {
                    this.runner.notify();
                }
                catch (Exception exception) {}
            } else {
                this.calcMap();
            }
        }
        if (!this.isMenuShowing()) {
            if (Keyboard.isKeyDown((int)EllianDetector.KEY_ZOOM.getKeyIndex())) {
                if (!this.isPressed) {
                    this.SetZoom();
                    this.isPressed = true;
                }
            } else if (Keyboard.isKeyDown((int)EllianDetector.KEY_MATERIAL.getKeyIndex())) {
                if (!this.isPressed) {
                    this.SetMaterial();
                    this.isPressed = true;
                }
            } else if (Keyboard.isKeyDown((int)EllianDetector.KEY_MENU.getKeyIndex())) {
                if (!this.isPressed) {
                    EllianDetector2MinecraftProxy.displayOptionScreen(this.detector);
                    this.isPressed = true;
                }
            } else if (Keyboard.isKeyDown((int)EllianDetector.KEY_DIRECTION.getKeyIndex())) {
                if (!this.isPressed) {
                    this.SetDirection();
                    this.isPressed = true;
                }
            } else {
                this.isPressed = false;
            }
        }
        this.enabled = !this.isMenuShowing();
        if (!this.error.equals("") && this.ztimer == 0) {
            this.ztimer = 200;
        }
        if (this.ztimer > 0) {
            --this.ztimer;
        }
        if (this.fudge > 0) {
            --this.fudge;
        }
        if (this.ztimer == 0 && !this.error.equals("")) {
            this.error = "";
        }
        if (this.enabled && !this.detector.isHidden()) {
            EllianDetectorRenderer.getInstance().refreshWindowSize();
            this.detector.refreshDirection();
            this.renderMap();
            if (this.ztimer > 0) {
                EllianDetector2MinecraftProxy.write(this.error, 20, 20, 0xFFFFFF);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    private void calcMap() {
        EllianDetectorCalculator.getInstance().mapCalcDetector(this.detector);
    }

    private boolean isMenuShowing() {
        return EllianDetector2MinecraftProxy.getMenu() != null || EllianDetector2MinecraftProxy.showDebugInfo();
    }

    private void renderMap() {
        EllianDetectorRenderer.getInstance().renderMap(this.detector);
    }

    private void SetDirection() {
        if (this.fudge > 0) {
            return;
        }
        if (this.detector.isVertical()) {
            this.detector.setVertical(false);
            this.error = "Detection direction: Horizontal";
        } else {
            this.detector.setVertical(true);
            this.error = "Detection direction: Vertical";
        }
        this.timer = this.refreshTimer + 1;
        EllianDetectorConfiguration.writeCurrentConf(this.detector);
        this.fudge = 20;
    }

    private void SetMaterial() {
        if (this.fudge > 0) {
            return;
        }
        this.detector.changeMaterial();
        this.error = "Material: " + this.detector.getCurrentMaterialName();
        this.timer = this.refreshTimer + 1;
        EllianDetectorConfiguration.writeCurrentConf(this.detector);
        this.fudge = 20;
    }

    private void SetZoom() {
        if (this.fudge > 0) {
            return;
        }
        if (this.detector.getZoom() == 0) {
            this.detector.setZoom(2);
            this.error = "Zoom Level: (1.0x)";
        } else if (this.detector.getZoom() == 2) {
            this.detector.setZoom(1);
            this.error = "Zoom Level: (2.0x)";
        } else if (this.detector.getZoom() == 1) {
            this.detector.setZoom(0);
            this.error = "Zoom Level: (4.0x)";
        }
        this.timer = this.refreshTimer + 1;
        EllianDetectorConfiguration.writeCurrentConf(this.detector);
        this.fudge = 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (this.threading) {
                if (this.enabled) {
                    this.active = true;
                    while (EllianDetector2MinecraftProxy.playerExists() && this.active) {
                        try {
                            Object object = EllianDetectorCalculator.getInstance().lock;
                            synchronized (object) {
                                this.calcMap();
                            }
                        }
                        catch (Exception exception) {}
                        this.active = false;
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
                try {
                    this.runner.wait(0L);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            try {
                this.runner.wait(0L);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

