/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.Set;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.BlockRenderTypeOverride;
import mods.betterfoliage.client.KeyHandler;
import mods.betterfoliage.client.render.RenderBlockBetterGrass;
import mods.betterfoliage.client.render.RenderBlockBetterLeaves;
import mods.betterfoliage.client.resource.ILeafTextureRecognizer;
import mods.betterfoliage.client.resource.LeafTextureGenerator;
import mods.betterfoliage.common.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public class BetterFoliageClient
implements BlockRenderTypeOverride.IRenderTypeProvider,
ILeafTextureRecognizer {
    public static int leavesRenderId;
    public static int grassRenderId;
    public static LeafTextureGenerator leafGenerator;
    public static Set<Class<?>> blockLeavesClasses;

    public static void preInit() {
        FMLCommonHandler.instance().bus().register((Object)new KeyHandler());
        BetterFoliage.log.info("Registering renderers");
        leavesRenderId = RenderBlockBetterLeaves.register();
        grassRenderId = RenderBlockBetterGrass.register();
        BlockRenderTypeOverride.provider = new BetterFoliageClient();
        blockLeavesClasses.add(BlockLeavesBase.class);
        BetterFoliageClient.addLeafBlockClass("forestry.arboriculture.gadgets.BlockLeaves");
        BetterFoliageClient.addLeafBlockClass("thaumcraft.common.blocks.BlockMagicalLeaves");
        BetterFoliage.log.info("Registering leaf texture generator");
        leafGenerator = new LeafTextureGenerator();
        MinecraftForge.EVENT_BUS.register((Object)leafGenerator);
        BetterFoliageClient.leafGenerator.recognizers.add(new BetterFoliageClient());
        leafGenerator.loadLeafMappings(new File(BetterFoliage.configDir, "leafMask.properties"));
    }

    protected static void addLeafBlockClass(String className) {
        try {
            blockLeavesClasses.add(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public int getRenderType(Block block) {
        if (Config.grassEnabled && block instanceof BlockGrass) {
            return grassRenderId;
        }
        if (Config.leavesEnabled) {
            for (Class<?> clazz : blockLeavesClasses) {
                if (!clazz.isAssignableFrom(block.getClass())) continue;
                return leavesRenderId;
            }
        }
        return block.func_149645_b();
    }

    @Override
    public boolean isLeafTexture(TextureAtlasSprite icon) {
        String resourceLocation = icon.func_94215_i();
        return resourceLocation.startsWith("forestry:leaves/");
    }

    static {
        blockLeavesClasses = Sets.newHashSet();
    }
}

