/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.resource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.BetterFoliageClient;
import mods.betterfoliage.client.resource.ILeafTextureRecognizer;
import mods.betterfoliage.client.resource.LeafTextureResource;
import mods.betterfoliage.common.util.ReflectionUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;

@SideOnly(value=Side.CLIENT)
public class LeafTextureGenerator
implements IIconRegister,
IResourceManager {
    public String domainName = "bf_leaves_autogen";
    public ResourceLocation missing_resource = new ResourceLocation("betterfoliage", "textures/blocks/missingleaf.png");
    public TextureMap blockTextures;
    public List<ILeafTextureRecognizer> recognizers = Lists.newLinkedList();
    int counter = 0;
    public Map<String, String> maskMappings = Maps.newHashMap();

    public Set<String> func_135055_a() {
        return ImmutableSet.of((Object)this.domainName);
    }

    public IResource func_110536_a(ResourceLocation resourceLocation) throws IOException {
        String origResPath = resourceLocation.func_110623_a().substring(16);
        LeafTextureResource result = new LeafTextureResource(new ResourceLocation(origResPath), this.maskMappings);
        if (result.data == null) {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(this.missing_resource);
        }
        ++this.counter;
        return result;
    }

    public List<IResource> func_135056_b(ResourceLocation resource) throws IOException {
        return ImmutableList.of();
    }

    public IIcon func_94245_a(String resourceLocation) {
        TextureAtlasSprite original = this.blockTextures.getTextureExtry(resourceLocation);
        this.blockTextures.func_94245_a(new ResourceLocation(this.domainName, resourceLocation).toString());
        BetterFoliage.log.debug(String.format("Found leaf texture: %s", resourceLocation));
        return original;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.blockTextures = event.map;
        this.counter = 0;
        BetterFoliage.log.info("Reloading leaf textures");
        Map<String, IResourceManager> domainManagers = ReflectionUtil.getDomainResourceManagers();
        if (domainManagers == null) {
            BetterFoliage.log.warn("Failed to inject leaf texture generator");
            return;
        }
        domainManagers.put(this.domainName, this);
        for (Block block : Block.field_149771_c) {
            for (Class<?> clazz : BetterFoliageClient.blockLeavesClasses) {
                if (!clazz.isAssignableFrom(block.getClass())) continue;
                BetterFoliage.log.debug(String.format("Inspecting leaf block: %s", block.getClass().getName()));
                block.func_149651_a((IIconRegister)this);
            }
        }
        Map mapAtlas = null;
        mapAtlas = ReflectionUtil.getField(this.blockTextures, "field_110574_e", Map.class);
        if (mapAtlas == null) {
            mapAtlas = ReflectionUtil.getField(this.blockTextures, "mapRegisteredSprites", Map.class);
        }
        if (mapAtlas == null) {
            BetterFoliage.log.warn("Failed to reflect texture atlas, textures may be missing");
        } else {
            HashSet foundLeafTextures = Sets.newHashSet();
            for (TextureAtlasSprite icon : mapAtlas.values()) {
                for (ILeafTextureRecognizer recognizer : this.recognizers) {
                    if (!recognizer.isLeafTexture(icon)) continue;
                    foundLeafTextures.add(icon.func_94215_i());
                }
            }
            for (String resourceLocation : foundLeafTextures) {
                BetterFoliage.log.debug(String.format("Found non-block-registered leaf texture: %s", resourceLocation));
                this.blockTextures.func_94245_a(new ResourceLocation(this.domainName, resourceLocation).toString());
            }
        }
    }

    @SubscribeEvent
    public void endTextureReload(TextureStitchEvent.Post event) {
        this.blockTextures = null;
        if (event.map.func_130086_a() == 0) {
            BetterFoliage.log.info(String.format("Generated %d leaf textures", this.counter));
        }
    }

    public void loadLeafMappings(File leafMaskFile) {
        Properties props = new Properties();
        try {
            FileInputStream fis = new FileInputStream(leafMaskFile);
            props.load(fis);
        }
        catch (Exception e) {
            this.maskMappings.put("spruce", "fine");
            this.maskMappings.put("fir", "fine");
            this.maskMappings.put("bamboo", "fine");
            this.saveLeafMappings(leafMaskFile);
            return;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.maskMappings.put(entry.getKey().toString(), entry.getValue().toString());
        }
        BetterFoliage.log.info(String.format("Loaded %d leaf mask mappings", this.maskMappings.size()));
    }

    protected void saveLeafMappings(File leafMaskFile) {
        try {
            FileOutputStream fos = new FileOutputStream(leafMaskFile);
            Properties props = new Properties();
            props.putAll(this.maskMappings);
            props.store(fos, "");
        }
        catch (Exception e) {
            BetterFoliage.log.info("Failed to save default leaf mask mappings");
            return;
        }
        BetterFoliage.log.info("Created default leaf mask mappings");
    }
}

