/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.resource;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import mods.betterfoliage.BetterFoliage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class LeafTextureResource
implements IResource {
    protected byte[] data = null;
    public static String defaultMask = "rough";

    public LeafTextureResource(ResourceLocation resLeaf, Map<String, String> maskMappings) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        try {
            ResourceLocation origResource = new ResourceLocation(resLeaf.func_110624_b(), "textures/blocks/" + resLeaf.func_110623_a());
            BufferedImage origImage = ImageIO.read(resourceManager.func_110536_a(origResource).func_110527_b());
            if (origImage.getWidth() != origImage.getHeight()) {
                return;
            }
            int size = origImage.getWidth();
            String maskType = defaultMask;
            for (Map.Entry<String, String> entry : maskMappings.entrySet()) {
                if (!resLeaf.func_110623_a().contains(entry.getKey())) continue;
                maskType = entry.getValue();
                break;
            }
            BufferedImage maskImage = this.loadLeafMaskImage(maskType, size * 2);
            int scale = size * 2 / maskImage.getWidth();
            BufferedImage overlayIcon = new BufferedImage(size * 2, size * 2, 6);
            Graphics2D graphics = overlayIcon.createGraphics();
            graphics.drawImage((Image)origImage, 0, 0, null);
            graphics.drawImage((Image)origImage, 0, size, null);
            graphics.drawImage((Image)origImage, size, 0, null);
            graphics.drawImage((Image)origImage, size, size, null);
            for (int x = 0; x < overlayIcon.getWidth(); ++x) {
                for (int y = 0; y < overlayIcon.getHeight(); ++y) {
                    long origPixel = (long)overlayIcon.getRGB(x, y) & 0xFFFFFFFFL;
                    long maskPixel = (long)maskImage.getRGB(x / scale, y / scale) & 0xFF000000L | 0xFFFFFFL;
                    overlayIcon.setRGB(x, y, (int)(origPixel & maskPixel));
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)overlayIcon, "PNG", baos);
            this.data = baos.toByteArray();
        }
        catch (Exception e) {
            BetterFoliage.log.info(String.format("Could not create leaf texture: %s, exception: %s", resLeaf.toString(), e.getClass().getSimpleName()));
        }
    }

    protected BufferedImage loadLeafMaskImage(String type, int size) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        IResource maskResource = null;
        while (maskResource == null && size >= 16) {
            try {
                maskResource = resourceManager.func_110536_a(new ResourceLocation(String.format("betterfoliage:textures/blocks/leafmask_%d_%s.png", size, type)));
            }
            catch (Exception e) {
                // empty catch block
            }
            size /= 2;
        }
        try {
            return maskResource == null ? null : ImageIO.read(maskResource.func_110527_b());
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputStream func_110527_b() {
        return this.data != null ? new ByteArrayInputStream(this.data) : null;
    }

    public boolean func_110528_c() {
        return false;
    }

    public IMetadataSection func_110526_a(String var1) {
        return null;
    }
}

