/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.common.config;

import java.io.File;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.common.config.OptionDouble;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static boolean leavesEnabled = true;
    public static boolean grassEnabled = true;
    public static OptionDouble leavesHOffset = new OptionDouble(0.0, 0.4, 0.025, 0.2);
    public static OptionDouble leavesVOffset = new OptionDouble(0.0, 0.4, 0.025, 0.1);
    public static OptionDouble leavesSize = new OptionDouble(0.75, 1.8, 0.05, 1.4);
    public static OptionDouble grassHOffset = new OptionDouble(0.0, 0.4, 0.025, 0.2);
    public static OptionDouble grassHeightMin = new OptionDouble(0.1, 1.5, 0.05, 0.5);
    public static OptionDouble grassHeightMax = new OptionDouble(0.1, 1.5, 0.05, 1.0);
    public static OptionDouble grassSize = new OptionDouble(0.5, 1.5, 0.05, 1.0);

    private Config() {
    }

    public static void load() {
        Configuration config = new Configuration(new File(BetterFoliage.configDir, "betterfoliage.cfg"));
        config.load();
        leavesEnabled = config.get("render", "leavesEnabled", true).getBoolean(true);
        Config.loadValue(config, "render", "leavesHorizontalOffset", leavesHOffset);
        Config.loadValue(config, "render", "leavesVerticalOffset", leavesVOffset);
        Config.loadValue(config, "render", "leavesSize", leavesSize);
        grassEnabled = config.get("render", "grassEnabled", true).getBoolean(true);
        Config.loadValue(config, "render", "grassHorizontalOffset", grassHOffset);
        Config.loadValue(config, "render", "grassHeightMin", grassHeightMin);
        Config.loadValue(config, "render", "grassHeightMax", grassHeightMax);
        if (Config.grassHeightMin.value > Config.grassHeightMax.value) {
            Config.grassHeightMin.value = Config.grassHeightMax.value;
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void save() {
        Configuration config = new Configuration(new File(BetterFoliage.configDir, "betterfoliage.cfg"));
        config.load();
        config.get("render", "leavesEnabled", true).set(leavesEnabled);
        Config.saveValue(config, "render", "leavesHorizontalOffset", leavesHOffset);
        Config.saveValue(config, "render", "leavesVerticalOffset", leavesVOffset);
        Config.saveValue(config, "render", "leavesSize", leavesSize);
        config.get("render", "grassEnabled", true).set(grassEnabled);
        Config.saveValue(config, "render", "grassHorizontalOffset", grassHOffset);
        Config.saveValue(config, "render", "grassHeightMin", grassHeightMin);
        Config.saveValue(config, "render", "grassHeightMax", grassHeightMax);
        if (config.hasChanged()) {
            config.save();
        }
    }

    protected static void saveValue(Configuration config, String category, String key, OptionDouble option) {
        config.get(category, key, option.value).set(option.value);
    }

    protected static void loadValue(Configuration config, String category, String key, OptionDouble option) {
        option.value = config.get(category, key, option.value).getDouble(option.value);
        if (option.value > option.max) {
            option.value = option.max;
            Config.saveValue(config, category, key, option);
        }
        if (option.value < option.min) {
            option.value = option.min;
            Config.saveValue(config, category, key, option);
        }
    }
}

