/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.betterfoliage.client.render.RenderBlockAOBase;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterGrass
extends RenderBlockAOBase
implements ISimpleBlockRenderingHandler {
    public IIcon[] grassIcons = new IIcon[2];

    public static int register() {
        int result = RenderingRegistry.getNextAvailableRenderId();
        RenderBlockBetterGrass renderGrass = new RenderBlockBetterGrass();
        RenderingRegistry.registerBlockHandler((int)result, (ISimpleBlockRenderingHandler)renderGrass);
        MinecraftForge.EVENT_BUS.register((Object)renderGrass);
        renderGrass.init();
        return result;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        this.renderStandardBlockAsItem(renderer, block, metadata, 1.0f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.field_147845_a = world;
        this.func_147775_a(block);
        this.setPassCounters(1);
        boolean result = this.func_147784_q(block, x, y, z);
        if (y == 255 || !this.field_147845_a.func_147437_c(x, y + 1, z)) {
            return result;
        }
        int variation = this.getSemiRandomFromPos(x, y, z, 0);
        int heightVariation = this.getSemiRandomFromPos(x, y, z, 1);
        double halfSize = Config.grassSize.value * 0.5;
        double halfHeight = 0.5 * (Config.grassHeightMin.value + this.pRand[heightVariation] * (Config.grassHeightMax.value - Config.grassHeightMin.value));
        Double3 drawCenter = new Double3((double)x + 0.5, (double)y + 1.0 + halfHeight, (double)z + 0.5).add(this.pRot[variation].scaleAxes(Config.grassHOffset.value, 0.0, Config.grassHOffset.value));
        Double3 horz1 = new Double3(halfSize, 0.0, halfSize);
        Double3 horz2 = new Double3(halfSize, 0.0, -halfSize);
        Double3 vert1 = new Double3(0.0, halfHeight, 0.0);
        IIcon grassIcon = this.grassIcons[variation % 2];
        if (Minecraft.func_71379_u()) {
            this.renderQuadWithShading(grassIcon, drawCenter, horz1, vert1, 0, this.aoYPXZPP, this.aoYPXZNN, this.aoYPXZNN, this.aoYPXZPP);
            this.renderQuadWithShading(grassIcon, drawCenter, horz1.inverse(), vert1, 0, this.aoYPXZNN, this.aoYPXZPP, this.aoYPXZPP, this.aoYPXZNN);
            this.renderQuadWithShading(grassIcon, drawCenter, horz2, vert1, 0, this.aoYPXZPN, this.aoYPXZNP, this.aoYPXZNP, this.aoYPXZPN);
            this.renderQuadWithShading(grassIcon, drawCenter, horz2.inverse(), vert1, 0, this.aoYPXZNP, this.aoYPXZPN, this.aoYPXZPN, this.aoYPXZNP);
        } else {
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(this.field_147845_a, x, y + 1, z));
            this.renderQuad(grassIcon, drawCenter, horz1, vert1, 0);
            this.renderQuad(grassIcon, drawCenter, horz1.inverse(), vert1, 0);
            this.renderQuad(grassIcon, drawCenter, horz2, vert1, 0);
            this.renderQuad(grassIcon, drawCenter, horz2.inverse(), vert1, 0);
        }
        return result;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return 0;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        for (int idx = 0; idx < 2; ++idx) {
            this.grassIcons[idx] = event.map.func_94245_a(String.format("betterfoliage:grass_%d", idx));
        }
    }
}

