/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.betterfoliage.client.BetterFoliageClient;
import mods.betterfoliage.client.render.RenderBlockAOBase;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import mods.betterfoliage.common.util.ReflectionUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterLeaves
extends RenderBlockAOBase
implements ISimpleBlockRenderingHandler {
    public static int register() {
        int result = RenderingRegistry.getNextAvailableRenderId();
        RenderBlockBetterLeaves renderLeaves = new RenderBlockBetterLeaves();
        RenderingRegistry.registerBlockHandler((int)result, (ISimpleBlockRenderingHandler)renderLeaves);
        renderLeaves.init();
        return result;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        this.renderStandardBlockAsItem(renderer, block, metadata, 1.0f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean result;
        this.field_147845_a = world;
        this.setPassCounters(1);
        int origRenderType = block.func_149645_b();
        this.func_147775_a(block);
        if (origRenderType == 0) {
            result = this.func_147784_q(block, x, y, z);
        } else {
            ISimpleBlockRenderingHandler handler = ReflectionUtil.getRenderingHandler(origRenderType);
            result = handler.renderWorldBlock(world, x, y, z, block, origRenderType, (RenderBlocks)this);
        }
        if (this.isBlockSurrounded(x, y, z)) {
            return result;
        }
        TextureAtlasSprite blockLeafIcon = (TextureAtlasSprite)block.func_149673_e(world, x, y, z, ForgeDirection.NORTH.ordinal());
        TextureAtlasSprite crossLeafIcon = Minecraft.func_71410_x().func_147117_R().func_110572_b(BetterFoliageClient.leafGenerator.domainName + ":" + blockLeafIcon.func_94215_i());
        if (crossLeafIcon == null) {
            return result;
        }
        int variation = this.getSemiRandomFromPos(x, y, z, 0);
        double halfSize = 0.5 * Config.leavesSize.value;
        boolean isAirTop = y == 255 || this.field_147845_a.func_147437_c(x, y + 1, z);
        boolean isAirBottom = y == 0 || this.field_147845_a.func_147437_c(x, y - 1, z);
        Double3 drawCenter = new Double3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        Double3 horz1 = new Double3(halfSize, 0.0, halfSize).add(this.pRot[variation].scaleAxes(Config.leavesHOffset.value, Config.leavesVOffset.value, Config.leavesHOffset.value));
        Double3 horz2 = new Double3(halfSize, 0.0, -halfSize).add(this.pRot[variation + 1 & 0x3F].scaleAxes(Config.leavesHOffset.value, Config.leavesVOffset.value, Config.leavesHOffset.value));
        Double3 vert1 = new Double3(0.0, halfSize * 1.41, 0.0);
        if (Minecraft.func_71379_u()) {
            this.renderQuadWithShading((IIcon)crossLeafIcon, drawCenter, horz1, vert1, variation, isAirTop ? this.aoYPXZPP : this.aoZPXYPP, isAirTop ? this.aoYPXZNN : this.aoXNYZPN, isAirBottom ? this.aoYNXZNN : this.aoXNYZNN, isAirBottom ? this.aoYNXZPP : this.aoZPXYPN);
            this.renderQuadWithShading((IIcon)crossLeafIcon, drawCenter, horz1.inverse(), vert1, variation, isAirTop ? this.aoYPXZNN : this.aoZNXYNP, isAirTop ? this.aoYPXZPP : this.aoXPYZPP, isAirBottom ? this.aoYNXZPP : this.aoXPYZNP, isAirBottom ? this.aoYNXZNN : this.aoZNXYNN);
            this.renderQuadWithShading((IIcon)crossLeafIcon, drawCenter, horz2, vert1, variation, isAirTop ? this.aoYPXZPN : this.aoXPYZPN, isAirTop ? this.aoYPXZNP : this.aoZPXYNP, isAirBottom ? this.aoYNXZNP : this.aoZPXYNN, isAirBottom ? this.aoYNXZPN : this.aoXPYZNN);
            this.renderQuadWithShading((IIcon)crossLeafIcon, drawCenter, horz2.inverse(), vert1, variation, isAirTop ? this.aoYPXZNP : this.aoXNYZPP, isAirTop ? this.aoYPXZPN : this.aoZNXYPP, isAirBottom ? this.aoYNXZPN : this.aoZNXYPN, isAirBottom ? this.aoYNXZNP : this.aoXNYZNP);
        } else {
            if (isAirTop) {
                Tessellator.field_78398_a.func_78380_c(block.func_149677_c(this.field_147845_a, x, y + 1, z));
            } else if (isAirBottom) {
                Tessellator.field_78398_a.func_78380_c(block.func_149677_c(this.field_147845_a, x, y - 1, z));
            } else {
                Tessellator.field_78398_a.func_78380_c(block.func_149677_c(this.field_147845_a, x, y, z));
            }
            this.renderQuad((IIcon)crossLeafIcon, drawCenter, horz1, vert1, variation);
            this.renderQuad((IIcon)crossLeafIcon, drawCenter, horz1.inverse(), vert1, variation);
            this.renderQuad((IIcon)crossLeafIcon, drawCenter, horz2, vert1, variation);
            this.renderQuad((IIcon)crossLeafIcon, drawCenter, horz2.inverse(), vert1, variation);
        }
        return result;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return 0;
    }

    protected boolean isBlockSurrounded(int x, int y, int z) {
        if (this.field_147845_a.func_147437_c(x + 1, y, z)) {
            return false;
        }
        if (this.field_147845_a.func_147437_c(x - 1, y, z)) {
            return false;
        }
        if (this.field_147845_a.func_147437_c(x, y, z + 1)) {
            return false;
        }
        if (this.field_147845_a.func_147437_c(x, y, z - 1)) {
            return false;
        }
        if (y == 255 || this.field_147845_a.func_147437_c(x, y + 1, z)) {
            return false;
        }
        return y != 0 && !this.field_147845_a.func_147437_c(x, y - 1, z);
    }
}

