/*
 * Decompiled with CFR 0.152.
 */
package ichun.common.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ichun.common.core.util.ObfHelper;
import ichun.common.iChunUtil;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityHelperBase {
    public static MovingObjectPosition getEntityLook(EntityLivingBase ent, double d) {
        return EntityHelperBase.getEntityLook(ent, d, false);
    }

    public static MovingObjectPosition getEntityLook(EntityLivingBase ent, double d, boolean ignoreEntities) {
        return EntityHelperBase.getEntityLook(ent, d, ignoreEntities, 1.0f);
    }

    public static MovingObjectPosition getEntityLook(EntityLivingBase ent, double d, boolean ignoreEntities, float renderTick) {
        double dd2;
        if (ent == null) {
            return null;
        }
        double d1 = d;
        MovingObjectPosition mop = EntityHelperBase.rayTrace(ent, d, renderTick);
        Vec3 vec3d = EntityHelperBase.getPosition((Entity)ent, renderTick);
        if (mop != null) {
            d1 = mop.field_72307_f.func_72438_d(vec3d);
        }
        if (d1 > (dd2 = d)) {
            d1 = dd2;
        }
        d = d1;
        Vec3 vec3d1 = ent.func_70676_i(renderTick);
        Vec3 vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d);
        if (!ignoreEntities) {
            Entity entity1 = null;
            float f1 = 1.0f;
            List list = ent.field_70170_p.func_72839_b((Entity)ent, ent.field_70121_D.func_72321_a(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d).func_72314_b((double)f1, (double)f1, (double)f1));
            double d2 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d3;
                Entity entity = (Entity)list.get(i);
                if (!entity.func_70067_L()) continue;
                float f2 = entity.func_70111_Y();
                AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b((double)f2, (double)f2, (double)f2);
                MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(vec3d, vec3d2);
                if (axisalignedbb.func_72318_a(vec3d)) {
                    if (!(0.0 < d2) && d2 != 0.0) continue;
                    entity1 = entity;
                    d2 = 0.0;
                    continue;
                }
                if (movingobjectposition == null || !((d3 = vec3d.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
                entity1 = entity;
                d2 = d3;
            }
            if (entity1 != null) {
                mop = new MovingObjectPosition(entity1);
            }
        }
        return mop;
    }

    public static Vec3 getPosition(Entity ent, float par1) {
        return EntityHelperBase.getPosition(ent, par1, false);
    }

    public static Vec3 getPosition(Entity ent, float par1, boolean midPoint) {
        if (par1 == 1.0f) {
            return ent.field_70170_p.func_82732_R().func_72345_a(ent.field_70165_t, midPoint ? (ent.field_70121_D.field_72338_b + ent.field_70121_D.field_72337_e) / 2.0 : ent.field_70163_u + (ent.field_70170_p.field_72995_K ? 0.0 : (double)ent.func_70047_e() - 0.09), ent.field_70161_v);
        }
        double var2 = ent.field_70169_q + (ent.field_70165_t - ent.field_70169_q) * (double)par1;
        double var4 = midPoint ? (ent.field_70121_D.field_72338_b + ent.field_70121_D.field_72337_e) / 2.0 : ent.field_70167_r + (ent.field_70170_p.field_72995_K ? 0.0 : (double)ent.func_70047_e() - 0.09) + (ent.field_70163_u - ent.field_70167_r) * (double)par1;
        double var6 = ent.field_70166_s + (ent.field_70161_v - ent.field_70166_s) * (double)par1;
        return ent.field_70170_p.func_82732_R().func_72345_a(var2, var4, var6);
    }

    public static MovingObjectPosition rayTrace(EntityLivingBase ent, double distance, float par3) {
        return EntityHelperBase.rayTrace(ent, distance, par3, false);
    }

    public static MovingObjectPosition rayTrace(EntityLivingBase ent, double distance, float par3, boolean midPoint) {
        Vec3 var4 = EntityHelperBase.getPosition((Entity)ent, par3, midPoint);
        Vec3 var5 = ent.func_70676_i(par3);
        Vec3 var6 = var4.func_72441_c(var5.field_72450_a * distance, var5.field_72448_b * distance, var5.field_72449_c * distance);
        return ent.field_70170_p.func_147447_a(var4, var6, false, false, true);
    }

    public static MovingObjectPosition rayTrace(World world, Vec3 vec3d, Vec3 vec3d1, boolean flag, boolean flag1, boolean goThroughTransparentBlocks) {
        return EntityHelperBase.rayTrace(world, vec3d, vec3d1, flag, flag1, goThroughTransparentBlocks, 200);
    }

    public static MovingObjectPosition rayTrace(World world, Vec3 vec3d, Vec3 vec3d1, boolean flag, boolean flag1, boolean goThroughTransparentBlocks, int distance) {
        MovingObjectPosition movingobjectposition;
        if (Double.isNaN(vec3d.field_72450_a) || Double.isNaN(vec3d.field_72448_b) || Double.isNaN(vec3d.field_72449_c)) {
            return null;
        }
        if (Double.isNaN(vec3d1.field_72450_a) || Double.isNaN(vec3d1.field_72448_b) || Double.isNaN(vec3d1.field_72449_c)) {
            return null;
        }
        int i = MathHelper.func_76128_c((double)vec3d1.field_72450_a);
        int j = MathHelper.func_76128_c((double)vec3d1.field_72448_b);
        int k = MathHelper.func_76128_c((double)vec3d1.field_72449_c);
        int l = MathHelper.func_76128_c((double)vec3d.field_72450_a);
        int i1 = MathHelper.func_76128_c((double)vec3d.field_72448_b);
        int j1 = MathHelper.func_76128_c((double)vec3d.field_72449_c);
        int i2 = world.func_72805_g(l, i1, j1);
        Block block = world.func_147439_a(l, i1, j1);
        if ((!flag1 || block.func_149668_a(world, l, i1, j1) != null) && block.func_149678_a(i2, flag) && (movingobjectposition = block.func_149731_a(world, l, i1, j1, vec3d, vec3d1)) != null) {
            return movingobjectposition;
        }
        int l1 = distance;
        while (l1-- >= 0) {
            MovingObjectPosition movingobjectposition1;
            if (Double.isNaN(vec3d.field_72450_a) || Double.isNaN(vec3d.field_72448_b) || Double.isNaN(vec3d.field_72449_c)) {
                return null;
            }
            if (l == i && i1 == j && j1 == k) {
                return null;
            }
            boolean flag2 = true;
            boolean flag3 = true;
            boolean flag4 = true;
            double d = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d = (double)l + 1.0;
            } else if (i < l) {
                d = (double)l + 0.0;
            } else {
                flag2 = false;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            } else if (j < i1) {
                d1 = (double)i1 + 0.0;
            } else {
                flag3 = false;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            } else if (k < j1) {
                d2 = (double)j1 + 0.0;
            } else {
                flag4 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = vec3d1.field_72450_a - vec3d.field_72450_a;
            double d7 = vec3d1.field_72448_b - vec3d.field_72448_b;
            double d8 = vec3d1.field_72449_c - vec3d.field_72449_c;
            if (flag2) {
                d3 = (d - vec3d.field_72450_a) / d6;
            }
            if (flag3) {
                d4 = (d1 - vec3d.field_72448_b) / d7;
            }
            if (flag4) {
                d5 = (d2 - vec3d.field_72449_c) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = i > l ? 4 : 5;
                vec3d.field_72450_a = d;
                vec3d.field_72448_b += d7 * d3;
                vec3d.field_72449_c += d8 * d3;
            } else if (d4 < d5) {
                byte0 = j > i1 ? 0 : 1;
                vec3d.field_72450_a += d6 * d4;
                vec3d.field_72448_b = d1;
                vec3d.field_72449_c += d8 * d4;
            } else {
                byte0 = k > j1 ? 2 : 3;
                vec3d.field_72450_a += d6 * d5;
                vec3d.field_72448_b += d7 * d5;
                vec3d.field_72449_c = d2;
            }
            Vec3 vec3d2 = world.func_82732_R().func_72345_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            vec3d2.field_72450_a = MathHelper.func_76128_c((double)vec3d.field_72450_a);
            l = (int)vec3d2.field_72450_a;
            if (byte0 == 5) {
                --l;
                vec3d2.field_72450_a += 1.0;
            }
            vec3d2.field_72448_b = MathHelper.func_76128_c((double)vec3d.field_72448_b);
            i1 = (int)vec3d2.field_72448_b;
            if (byte0 == 1) {
                --i1;
                vec3d2.field_72448_b += 1.0;
            }
            vec3d2.field_72449_c = MathHelper.func_76128_c((double)vec3d.field_72449_c);
            j1 = (int)vec3d2.field_72449_c;
            if (byte0 == 3) {
                --j1;
                vec3d2.field_72449_c += 1.0;
            }
            Block block1 = world.func_147439_a(l, i1, j1);
            if (goThroughTransparentBlocks && EntityHelperBase.isTransparent(block1)) continue;
            int k2 = world.func_72805_g(l, i1, j1);
            if (flag1 && block1.func_149668_a(world, l, i1, j1) == null || !block1.func_149678_a(k2, flag) || (movingobjectposition1 = block1.func_149731_a(world, l, i1, j1, vec3d, vec3d1)) == null) continue;
            return movingobjectposition1;
        }
        return null;
    }

    public static boolean hasFuel(InventoryPlayer inventory, Item item, int damage, int amount) {
        if (amount <= 0) {
            return true;
        }
        int amountFound = 0;
        for (int var3 = 0; var3 < inventory.field_70462_a.length; ++var3) {
            if (inventory.field_70462_a[var3] == null || inventory.field_70462_a[var3].func_77973_b() != item || inventory.field_70462_a[var3].func_77960_j() != damage || (amountFound += inventory.field_70462_a[var3].field_77994_a) < amount) continue;
            return true;
        }
        return false;
    }

    public static boolean isTransparent(Block block) {
        return block.func_149717_k() != 255;
    }

    public static boolean isLookingAtMoon(World world, EntityLivingBase ent, float renderTick, boolean goThroughTransparentBlocks) {
        float f3;
        if (ent.field_71093_bK == -1 || ent.field_71093_bK == 1) {
            return false;
        }
        double de = 2.71828183;
        float f = world.func_72826_c(1.0f);
        if (!((double)f >= 0.26) || !((double)f <= 0.74)) {
            return false;
        }
        float f2 = f > 0.5f ? f - 0.5f : 0.5f - f;
        float f4 = f3 = ent.field_70177_z > 0.0f ? 270.0f : -90.0f;
        f3 = f > 0.5f ? (ent.field_70177_z > 0.0f ? 90.0f : -270.0f) : f3;
        float f5 = f = f > 0.5f ? 1.0f - f : f;
        if ((double)f <= 0.475) {
            de = 2.71828183;
        } else if ((double)f <= 0.4875) {
            de = 3.88377;
        } else if ((double)f <= 0.4935) {
            de = 4.91616;
        } else if ((double)f <= 0.4965) {
            de = 5.40624;
        } else if ((double)f <= 0.5) {
            de = 9.8;
        }
        boolean yawCheck = (double)(ent.field_70177_z % 360.0f) <= Math.pow(de, 4.92574 * (double)world.func_72826_c(1.0f)) + (double)f3 && (double)(ent.field_70177_z % 360.0f) >= -Math.pow(de, 4.92574 * (double)world.func_72826_c(1.0f)) + (double)f3;
        float ff = world.func_72826_c(1.0f);
        ff = ff > 0.5f ? 1.0f - ff : ff;
        ff -= 0.26f;
        ff = ff / 0.26f * -94.0f - 4.0f;
        boolean pitchCheck = ent.field_70125_A <= ff + 2.5f && ent.field_70125_A >= ff - 2.5f;
        Vec3 vec3d = EntityHelperBase.getPosition((Entity)ent, renderTick);
        Vec3 vec3d1 = ent.func_70676_i(renderTick);
        Vec3 vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * 500.0, vec3d1.field_72448_b * 500.0, vec3d1.field_72449_c * 500.0);
        boolean mopCheck = EntityHelperBase.rayTrace(ent.field_70170_p, vec3d, vec3d2, true, false, goThroughTransparentBlocks, 500) == null;
        return yawCheck && pitchCheck && mopCheck;
    }

    public static boolean consumeInventoryItem(InventoryPlayer inventory, Item item, int damage, int amount) {
        int var3;
        if (amount <= 0) {
            return true;
        }
        int amountFound = 0;
        for (var3 = 0; var3 < inventory.field_70462_a.length && (inventory.field_70462_a[var3] == null || inventory.field_70462_a[var3].func_77973_b() != item || inventory.field_70462_a[var3].func_77960_j() != damage || (amountFound += inventory.field_70462_a[var3].field_77994_a) < amount); ++var3) {
        }
        if (amountFound >= amount) {
            for (var3 = 0; var3 < inventory.field_70462_a.length; ++var3) {
                if (inventory.field_70462_a[var3] == null || inventory.field_70462_a[var3].func_77973_b() != item || inventory.field_70462_a[var3].func_77960_j() != damage) continue;
                while (amount > 0 && inventory.field_70462_a[var3] != null && inventory.field_70462_a[var3].field_77994_a > 0) {
                    --amount;
                    --inventory.field_70462_a[var3].field_77994_a;
                    if (inventory.field_70462_a[var3].field_77994_a <= 0) {
                        inventory.field_70462_a[var3] = null;
                    }
                    if (amount > 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void forceJump(EntityLivingBase ent) {
        try {
            Method m = EntityLivingBase.class.getDeclaredMethod(ObfHelper.obfuscation ? "func_70664_aZ" : "jump", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)ent, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            ent.field_70181_x = 0.42f;
            if (ent.func_70644_a(Potion.field_76430_j)) {
                ent.field_70181_x += (double)((float)(ent.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
            }
            if (ent.func_70051_ag()) {
                float var1 = ent.field_70177_z * ((float)Math.PI / 180);
                ent.field_70159_w -= (double)(MathHelper.func_76126_a((float)var1) * 0.2f);
                ent.field_70179_y += (double)(MathHelper.func_76134_b((float)var1) * 0.2f);
            }
            ent.field_70160_al = true;
            ForgeHooks.onLivingJump((EntityLivingBase)ent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getDeathSound(Class clz, EntityLivingBase ent) {
        try {
            Method m = clz.getDeclaredMethod(ObfHelper.obfuscation ? "func_70673_aS" : "getDeathSound", new Class[0]);
            m.setAccessible(true);
            return (String)m.invoke((Object)ent, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if (clz != EntityLivingBase.class) {
                return EntityHelperBase.getDeathSound(clz.getSuperclass(), ent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "game.neutral.die";
    }

    public static String getHurtSound(Class clz, EntityLivingBase ent) {
        try {
            Method m = clz.getDeclaredMethod(ObfHelper.obfuscation ? "func_70621_aR" : "getHurtSound", new Class[0]);
            m.setAccessible(true);
            return (String)m.invoke((Object)ent, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if (clz != EntityLivingBase.class) {
                return EntityHelperBase.getHurtSound(clz.getSuperclass(), ent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "game.neutral.hurt";
    }

    @SideOnly(value=Side.CLIENT)
    public static void invokeRenderHand(EntityRenderer renderer, float renderTick) {
        try {
            Method m = EntityRenderer.class.getDeclaredMethod(ObfHelper.obfuscation ? "func_78476_b" : "renderHand", Float.TYPE, Integer.TYPE);
            m.setAccessible(true);
            m.invoke((Object)renderer, Float.valueOf(renderTick), 0);
        }
        catch (NoSuchMethodException e) {
            iChunUtil.console("Cannot find render hand method!", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static float updateRotation(float oriRot, float intendedRot, float maxChange) {
        float var4 = MathHelper.func_76142_g((float)(intendedRot - oriRot));
        if (var4 > maxChange) {
            var4 = maxChange;
        }
        if (var4 < -maxChange) {
            var4 = -maxChange;
        }
        return oriRot + var4;
    }

    public static float interpolateRotation(float prevRotation, float nextRotation, float partialTick) {
        float f3;
        for (f3 = nextRotation - prevRotation; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return prevRotation + partialTick * f3;
    }

    public static float interpolateValues(float prevVal, float nextVal, float partialTick) {
        return prevVal + partialTick * (nextVal - prevVal);
    }

    public static void faceEntity(Entity facer, Entity faced, float maxYaw, float maxPitch) {
        double d2;
        double d0 = faced.field_70165_t - facer.field_70165_t;
        double d1 = faced.field_70161_v - facer.field_70161_v;
        if (faced instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)faced;
            d2 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (facer.field_70163_u + (double)facer.func_70047_e());
        } else {
            d2 = (faced.field_70121_D.field_72338_b + faced.field_70121_D.field_72337_e) / 2.0 - (facer.field_70163_u + (double)facer.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        facer.field_70125_A = EntityHelperBase.updateRotation(facer.field_70125_A, f3, maxPitch);
        facer.field_70177_z = EntityHelperBase.updateRotation(facer.field_70177_z, f2, maxYaw);
    }

    public static void setVelocity(Entity entity, double d, double d1, double d2) {
        if (entity == null) {
            return;
        }
        entity.field_70159_w = d;
        entity.field_70181_x = d1;
        entity.field_70179_y = d2;
    }

    public static boolean destroyBlocksInAABB(Entity ent, AxisAlignedBB aabb) {
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int k = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int l = MathHelper.func_76128_c((double)aabb.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)aabb.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)aabb.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    Block block = ent.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block == null) continue;
                    if (block.func_149712_f(ent.field_70170_p, k1, l1, i2) >= 0.0f && block.canEntityDestroy((IBlockAccess)ent.field_70170_p, k1, l1, i2, ent) && ent.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag1 = ent.field_70170_p.field_72995_K ? true : ent.field_70170_p.func_147468_f(k1, l1, i2) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d0 = aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * (double)ent.field_70170_p.field_73012_v.nextFloat();
            double d1 = aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * (double)ent.field_70170_p.field_73012_v.nextFloat();
            double d2 = aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * (double)ent.field_70170_p.field_73012_v.nextFloat();
            ent.field_70170_p.func_72869_a("largeexplode", d0, d1, d2, 0.0, 0.0, 0.0);
        }
        return flag;
    }

    public static void addPosition(Entity living, double offset, boolean subtract, int axis) {
        if (axis == 0) {
            if (subtract) {
                living.field_70142_S -= offset;
                living.field_70169_q -= offset;
                living.field_70165_t -= offset;
            } else {
                living.field_70142_S += offset;
                living.field_70169_q += offset;
                living.field_70165_t += offset;
            }
        } else if (axis == 1) {
            if (subtract) {
                living.field_70137_T -= offset;
                living.field_70167_r -= offset;
                living.field_70163_u -= offset;
            } else {
                living.field_70137_T += offset;
                living.field_70167_r += offset;
                living.field_70163_u += offset;
            }
        } else if (axis == 2) {
            if (subtract) {
                living.field_70136_U -= offset;
                living.field_70166_s -= offset;
                living.field_70161_v -= offset;
            } else {
                living.field_70136_U += offset;
                living.field_70166_s += offset;
                living.field_70161_v += offset;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static Render getEntityClassRenderObject(Class par1Class) {
        Render render = (Render)RenderManager.field_78727_a.field_78729_o.get(par1Class);
        if (render == null && par1Class != Entity.class) {
            render = EntityHelperBase.getEntityClassRenderObject(par1Class.getSuperclass());
        }
        return render;
    }

    public static NBTTagCompound getPlayerPersistentData(EntityPlayer player) {
        NBTTagCompound persistentTag = player.getEntityData().func_74775_l("PlayerPersisted");
        player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
        return persistentTag;
    }
}

