/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.data.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dmillerw.menu.data.click.ClickAction;
import dmillerw.menu.data.click.ClickActionCategory;
import dmillerw.menu.data.click.ClickActionCommand;
import dmillerw.menu.data.click.ClickActionKey;
import dmillerw.menu.data.click.ClickActionUseItem;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class ClickActionSerializer
implements JsonSerializer<ClickAction.IClickAction>,
JsonDeserializer<ClickAction.IClickAction> {
    public JsonElement serialize(ClickAction.IClickAction src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        if (src instanceof ClickActionCommand) {
            object.add("command", (JsonElement)new JsonPrimitive(((ClickActionCommand)src).command));
        } else if (src instanceof ClickActionKey) {
            JsonObject object1 = new JsonObject();
            object1.add("key", (JsonElement)new JsonPrimitive(((ClickActionKey)src).key));
            object1.add("toggle", (JsonElement)new JsonPrimitive(Boolean.valueOf(((ClickActionKey)src).toggle)));
            object.add("key", (JsonElement)object1);
        } else if (src instanceof ClickActionUseItem) {
            object.add("item", context.serialize((Object)((ClickActionUseItem)src).item));
        } else if (src instanceof ClickActionCategory) {
            object.add("category", (JsonElement)new JsonPrimitive(((ClickActionCategory)src).category));
        }
        return object;
    }

    public ClickAction.IClickAction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return null;
        }
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (key.equals("command")) {
                return new ClickActionCommand(element.getAsString());
            }
            if (key.equals("key")) {
                if (element.isJsonPrimitive()) {
                    return new ClickActionKey(element.getAsString(), false);
                }
                String keybind = "";
                boolean toggle = false;
                for (Map.Entry entry1 : element.getAsJsonObject().entrySet()) {
                    if (((String)entry1.getKey()).equals("key")) {
                        keybind = ((JsonElement)entry1.getValue()).getAsString();
                        continue;
                    }
                    if (!((String)entry1.getKey()).equals("toggle")) continue;
                    toggle = ((JsonElement)entry1.getValue()).getAsBoolean();
                }
                return new ClickActionKey(keybind, toggle);
            }
            if (key.equals("item")) {
                return new ClickActionUseItem((ItemStack)context.deserialize(element, ItemStack.class));
            }
            if (!key.equals("category")) continue;
            return new ClickActionCategory(element.getAsString());
        }
        return null;
    }
}

