/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.gui.menu;

import dmillerw.menu.data.session.EditSessionData;
import dmillerw.menu.gui.GuiStack;
import dmillerw.menu.helper.GuiRenderHelper;
import dmillerw.menu.helper.ItemRenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiPickIcon
extends GuiScreen {
    private static final int MAX_COLUMN = 14;
    private static final int MAX_ROW = 4;
    private GuiTextField textSearch;
    private GuiButton buttonCancel;
    private List<ItemStack> stacks;
    private int listScrollIndex = 0;

    public void func_73876_c() {
        this.textSearch.func_146178_a();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.stacks = new ArrayList<ItemStack>();
        for (Item item : Item.field_150901_e) {
            if (item == null || item.func_77640_w() == null) continue;
            item.func_150895_a(item, null, this.stacks);
        }
        this.field_146292_n.clear();
        this.buttonCancel = new GuiButton(0, this.field_146294_l / 2 - 75, this.field_146295_m - 60 + 12, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonCancel);
        this.textSearch = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 150, 40, 300, 20);
        this.textSearch.func_146203_f(Short.MAX_VALUE);
        this.textSearch.func_146195_b(true);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l && button.field_146127_k == 0) {
            GuiStack.pop();
        }
    }

    protected void func_73869_a(char key, int keycode) {
        if (this.textSearch.func_146201_a(key, keycode)) {
            this.listScrollIndex = 0;
            if (!this.textSearch.func_146179_b().trim().isEmpty()) {
                this.stacks.clear();
                ArrayList temp = new ArrayList();
                for (Object anItemRegistry : Item.field_150901_e) {
                    Item item = (Item)anItemRegistry;
                    if (item == null || item.func_77640_w() == null) continue;
                    item.func_150895_a(item, null, temp);
                }
                for (ItemStack stack : temp) {
                    if (stack == null || !stack.func_82833_r().toLowerCase().contains(this.textSearch.func_146179_b().toLowerCase())) continue;
                    this.stacks.add(stack);
                }
            } else {
                this.stacks.clear();
                for (Object anItemRegistry : Item.field_150901_e) {
                    Item item = (Item)anItemRegistry;
                    if (item == null || item.func_77640_w() == null) continue;
                    item.func_150895_a(item, null, this.stacks);
                }
            }
        }
        if (keycode != 28 && keycode != 156 && keycode == 1) {
            this.func_146284_a(this.buttonCancel);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        ItemStack clicked = this.getClickedStack(this.field_146294_l / 2, this.field_146295_m / 2 - 40, mouseX, mouseY);
        if (clicked != null) {
            EditSessionData.icon = clicked;
            GuiStack.pop();
        }
        if (this.buttonCancel.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) {
            EditSessionData.icon = null;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partial) {
        this.onWheelScrolled(mouseX, mouseY, Mouse.getDWheel());
        this.func_146276_q_();
        this.textSearch.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partial);
        GuiRenderHelper.renderHeaderAndFooter(this, 25, 20, 5, "Select an Icon:");
        this.drawList(this, this.field_146294_l / 2, this.field_146295_m / 2 - 40, mouseX, mouseY);
    }

    public void onWheelScrolled(int x, int y, int wheel) {
        if ((wheel = -wheel) < 0) {
            this.listScrollIndex -= 2;
            if (this.listScrollIndex < 0) {
                this.listScrollIndex = 0;
            }
        }
        if (wheel > 0) {
            this.listScrollIndex += 2;
            if (this.listScrollIndex > Math.max(0, this.stacks.size() / 14) - 4) {
                this.listScrollIndex = Math.max(0, this.stacks.size() / 14 - 4);
            }
        }
    }

    private void drawList(GuiPickIcon gui, int x, int y, int mx, int my) {
        ItemStack highlighted = null;
        float highlightedX = 0.0f;
        float highlightedY = 0.0f;
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            if ((i - 14 * this.listScrollIndex) / 14 > 4) break;
            GL11.glPushMatrix();
            boolean scaled = false;
            float actualDrawX = x + drawX * 20 - 140 + 10;
            float actualDrawY = y + drawY * 20;
            actualDrawY -= (float)(20 * this.listScrollIndex);
            if ((float)mx > actualDrawX - 8.0f && (float)mx < actualDrawX + 20.0f - 8.0f && (float)my > actualDrawY - 8.0f && (float)my < actualDrawY + 20.0f - 8.0f) {
                scaled = true;
                highlighted = this.stacks.get(i);
                highlightedX = actualDrawX / 2.0f;
                highlightedY = actualDrawY / 2.0f;
            }
            if (!scaled) {
                ItemRenderHelper.renderItem(actualDrawX, actualDrawY, gui.field_73735_i, this.stacks.get(i));
            }
            GL11.glPopMatrix();
        }
        if (highlighted != null) {
            GL11.glPushMatrix();
            GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
            ItemRenderHelper.renderItem(highlightedX, highlightedY, gui.field_73735_i, highlighted);
            GL11.glPopMatrix();
        }
    }

    private ItemStack getClickedStack(int x, int y, int mx, int my) {
        for (int i = 14 * this.listScrollIndex; i < this.stacks.size(); ++i) {
            int drawX = i % 14;
            int drawY = i / 14;
            if ((i - 14 * this.listScrollIndex) / 14 > 4) continue;
            float actualDrawX = x + drawX * 20 - 140 + 10;
            float actualDrawY = y + drawY * 20;
            actualDrawY -= (float)(20 * this.listScrollIndex);
            if (!((float)mx > actualDrawX - 8.0f) || !((float)mx < actualDrawX + 20.0f - 8.0f) || !((float)my > actualDrawY - 8.0f) || !((float)my < actualDrawY + 20.0f - 8.0f)) continue;
            return this.stacks.get(i);
        }
        return null;
    }
}

