/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.menu.handler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import dmillerw.menu.data.menu.MenuItem;
import dmillerw.menu.data.menu.RadialMenu;
import dmillerw.menu.data.session.ActionSessionData;
import dmillerw.menu.gui.CompatibleScaledResolution;
import dmillerw.menu.gui.GuiRadialMenu;
import dmillerw.menu.helper.AngleHelper;
import dmillerw.menu.helper.ItemRenderHelper;
import dmillerw.menu.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class ClientTickHandler {
    public static final double ANGLE_PER_ITEM = 36.0;
    public static final int ITEM_RENDER_ANGLE_OFFSET = -2;
    private static final double OUTER_RADIUS = 80.0;
    private static final double INNER_RADIUS = 60.0;
    private static final float Z_LEVEL = 0.05f;

    public static void register() {
        ClientTickHandler clientTickHandler = new ClientTickHandler();
        FMLCommonHandler.instance().bus().register((Object)clientTickHandler);
        MinecraftForge.EVENT_BUS.register((Object)clientTickHandler);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            RadialMenu.tickTimer();
            Minecraft mc = Minecraft.func_71410_x();
            if ((mc.field_71441_e == null || mc.func_147113_T()) && GuiRadialMenu.active) {
                GuiRadialMenu.deactivate();
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            double zLevel = 0.05;
            if (mc.field_71441_e != null && !mc.field_71474_y.field_74319_N && !mc.func_147113_T() && GuiRadialMenu.active) {
                CompatibleScaledResolution resolution = new CompatibleScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                this.renderGui(resolution, zLevel);
                this.renderItems(resolution, zLevel);
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && GuiRadialMenu.active) {
            event.setCanceled(true);
        }
        if (!(event instanceof RenderGameOverlayEvent.Post) || event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && !mc.field_71474_y.field_74319_N && !mc.func_147113_T() && GuiRadialMenu.active) {
            this.renderText(event.resolution, 0.05f);
        }
    }

    private void renderGui(CompatibleScaledResolution resolution, double zLevel) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        Tessellator tessellator = Tessellator.field_78398_a;
        double mouseAngle = AngleHelper.getMouseAngle();
        mouseAngle -= 270.0;
        mouseAngle = AngleHelper.correctAngle(mouseAngle);
        for (int i = 0; i < 10; ++i) {
            MenuItem item = RadialMenu.getActiveArray()[i];
            boolean disabled = item != null && !ActionSessionData.availableActions.contains((Object)item.clickAction.getClickAction());
            double currAngle = 36.0 * (double)i;
            double nextAngle = currAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            boolean mouseIn = mouseAngle > currAngle && mouseAngle < nextAngle;
            currAngle = Math.toRadians(currAngle);
            nextAngle = Math.toRadians(nextAngle);
            double innerRadius = (60.0 - (double)RadialMenu.animationTimer - (double)(mouseIn ? 2 : 0)) / 100.0 * (double)(257.0f / (float)resolution.getScaledHeight());
            double outerRadius = (80.0 - (double)RadialMenu.animationTimer + (double)(mouseIn ? 2 : 0)) / 100.0 * (double)(257.0f / (float)resolution.getScaledHeight());
            tessellator.func_78382_b();
            if (mouseIn) {
                if (disabled) {
                    tessellator.func_78369_a(0.78431374f, 0.78431374f, 0.78431374f, (float)ClientProxy.selectAlpha / 255.0f);
                } else {
                    tessellator.func_78369_a((float)ClientProxy.selectRed / 255.0f, (float)ClientProxy.selectGreen / 255.0f, (float)ClientProxy.selectBlue / 255.0f, (float)ClientProxy.selectAlpha / 255.0f);
                }
            } else {
                tessellator.func_78369_a((float)ClientProxy.menuRed / 255.0f, (float)ClientProxy.menuGreen / 255.0f, (float)ClientProxy.menuBlue / 255.0f, (float)ClientProxy.menuAlpha / 255.0f);
            }
            tessellator.func_78377_a(Math.cos(currAngle) * resolution.getScaledHeight_double() / resolution.getScaledWidth_double() * innerRadius, Math.sin(currAngle) * innerRadius, 0.0);
            tessellator.func_78377_a(Math.cos(currAngle) * resolution.getScaledHeight_double() / resolution.getScaledWidth_double() * outerRadius, Math.sin(currAngle) * outerRadius, 0.0);
            tessellator.func_78377_a(Math.cos(nextAngle) * resolution.getScaledHeight_double() / resolution.getScaledWidth_double() * outerRadius, Math.sin(nextAngle) * outerRadius, 0.0);
            tessellator.func_78377_a(Math.cos(nextAngle) * resolution.getScaledHeight_double() / resolution.getScaledWidth_double() * innerRadius, Math.sin(nextAngle) * innerRadius, 0.0);
            tessellator.func_78381_a();
        }
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    private void renderItems(CompatibleScaledResolution resolution, double zLevel) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(resolution.getScaledWidth_double() / 2.0), (double)(resolution.getScaledHeight_double() / 2.0), (double)0.0);
        RenderHelper.func_74520_c();
        for (int i = 0; i < 10; ++i) {
            MenuItem item = RadialMenu.getActiveArray()[i];
            ItemStack stack = item != null && item.icon != null ? item.icon : new ItemStack(Blocks.field_150348_b);
            switch (stack.func_94608_d()) {
                case 1: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110576_c);
                    break;
                }
                default: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                }
            }
            double angle = 36.0 * (double)i + -72.0 - 18.0;
            double drawOffset = 1.5;
            double drawX = 60.0 - (double)RadialMenu.animationTimer + drawOffset;
            double drawY = 60.0 - (double)RadialMenu.animationTimer + drawOffset;
            double length = Math.sqrt(drawX * drawX + drawY * drawY);
            drawX = length * Math.cos(StrictMath.toRadians(angle));
            drawY = length * Math.sin(StrictMath.toRadians(angle));
            ItemRenderHelper.renderItem((float)drawX, (float)drawY, 0.05f, stack);
        }
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
    }

    private void renderText(ScaledResolution resolution, double zLevel) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        double mouseAngle = AngleHelper.getMouseAngle();
        mouseAngle -= 18.0;
        mouseAngle = 360.0 - mouseAngle;
        mouseAngle = AngleHelper.correctAngle(mouseAngle);
        for (int i = 0; i < 10; ++i) {
            String string;
            boolean mouseIn;
            double currAngle = 36.0 * (double)i;
            double nextAngle = currAngle + 36.0;
            currAngle = AngleHelper.correctAngle(currAngle);
            nextAngle = AngleHelper.correctAngle(nextAngle);
            boolean bl = mouseIn = mouseAngle > currAngle && mouseAngle < nextAngle;
            if (!mouseIn) continue;
            MenuItem item = RadialMenu.getActiveArray()[i];
            String string2 = string = item == null ? "Add Item" : item.title;
            if (GuiRadialMenu.func_146272_n() && item != null) {
                string = EnumChatFormatting.RED + "EDIT: " + EnumChatFormatting.WHITE + string;
            }
            int drawX = resolution.func_78326_a() / 2 - fontRenderer.func_78256_a(string) / 2;
            int drawY = resolution.func_78328_b() / 2;
            int drawWidth = mc.field_71466_p.func_78256_a(string);
            int drawHeight = mc.field_71466_p.field_78288_b;
            float padding = 5.0f;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3553);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78369_a((float)ClientProxy.menuRed / 255.0f, (float)ClientProxy.menuGreen / 255.0f, (float)ClientProxy.menuBlue / 255.0f, (float)ClientProxy.menuAlpha / 255.0f);
            tessellator.func_78377_a((double)((float)drawX - padding), (double)((float)(drawY + drawHeight) + padding), 0.0);
            tessellator.func_78377_a((double)((float)(drawX + drawWidth) + padding), (double)((float)(drawY + drawHeight) + padding), 0.0);
            tessellator.func_78377_a((double)((float)(drawX + drawWidth) + padding), (double)((float)drawY - padding), 0.0);
            tessellator.func_78377_a((double)((float)drawX - padding), (double)((float)drawY - padding), 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            fontRenderer.func_78261_a(string, drawX, drawY, 0xFFFFFF);
        }
    }
}

