/*
 * Decompiled with CFR 0.152.
 */
package grim3212.mc.backpacks;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import grim3212.mc.backpacks.BackpackInventory;
import grim3212.mc.backpacks.BackpackRecipeHandler;
import grim3212.mc.backpacks.ContainerBackpack;
import grim3212.mc.backpacks.ContainerCustomWorkbench;
import grim3212.mc.backpacks.GuiBackpack;
import grim3212.mc.backpacks.GuiPortable;
import grim3212.mc.backpacks.ItemBackpack;
import grim3212.mc.backpacks.ItemPortableWorkbench;
import grim3212.mc.core.Grim3212Core;
import grim3212.mc.core.GrimModule;
import grim3212.mc.core.util.VersionChecker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.oredict.RecipeSorter;

@Mod(modid="grim3212backpacks", name="Grim3212 Backpacks", version="V0.1 - 1.7.2", dependencies="required-after:grim3212core")
public class Backpack
extends GrimModule {
    @Mod.Instance(value="grim3212backpacks")
    public static Backpack instance;
    public static final String modID = "grim3212backpacks";
    public static final String modName = "Grim3212 Backpacks";
    public static final String modVersion = "V0.1 - 1.7.2";
    public static final String modURL = "http://grim3212.wikispaces.com/Backpacks";
    private static VersionChecker versionChecker;
    public static boolean canVersionCheck;
    public static Item backpack;
    public static Item portableWorkbench;
    public static int backpackGUI_ID;
    public static int workbenchGUI_ID;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModMetadata data = event.getModMetadata();
        data.autogenerated = false;
        data.version = modVersion;
        data.name = modName;
        data.description = "My take on minecraft backpacks.";
        data.authorList.add("Grim3212");
        data.url = modURL;
        data.credits = "Thanks to ME for the original mod.";
        data.logoFile = "assets/grim3212-logo-texture/grimLogo.png";
        backpack = new ItemBackpack().func_77655_b("backpack").func_77637_a(Grim3212Core.tabsGrimItems);
        portableWorkbench = new ItemPortableWorkbench().func_77655_b("portableWorkbench").func_77637_a(Grim3212Core.tabsGrimItems).func_111206_d("grim3212backpacks:portableWorkbench");
        GameRegistry.registerItem((Item)backpack, (String)backpack.func_77658_a(), (String)modID);
        GameRegistry.registerItem((Item)portableWorkbench, (String)portableWorkbench.func_77658_a(), (String)modID);
        GameRegistry.addRecipe((ItemStack)new ItemStack(backpack, 1, 0), (Object[])new Object[]{"LLS", "LIS", "LLL", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('S'), Items.field_151007_F, Character.valueOf('I'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(portableWorkbench, 1), (Object[])new Object[]{"III", "IWI", "III", Character.valueOf('W'), Blocks.field_150462_ai, Character.valueOf('I'), Items.field_151042_j});
        CraftingManager.func_77594_a().func_77592_b().add(new BackpackRecipeHandler());
        RecipeSorter.register((String)"Backpack_Recipes", BackpackRecipeHandler.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:grim3212core");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        if (Grim3212Core.doUpdateCheck) {
            versionChecker = new VersionChecker(modName, modVersion, this.versionUrl, modURL);
            versionChecker.checkVersionWithLoggingBySubStringAsFloat(1, 4);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)this);
    }

    public String getModID() {
        return modID;
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (FMLClientHandler.instance().getClient().field_71462_r == null && Grim3212Core.doUpdateCheck) {
            if (canVersionCheck && !versionChecker.isCurrentVersionBySubStringAsFloatNewer(1, 4)) {
                for (String msg : versionChecker.getInGameMessage()) {
                    FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(msg));
                }
                canVersionCheck = false;
            }
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == backpackGUI_ID) {
            BackpackInventory backpackInventory = new BackpackInventory(player.field_71071_by.func_70448_g(), player, 0);
            return new ContainerBackpack(backpackInventory, player.field_71071_by);
        }
        if (ID == workbenchGUI_ID) {
            return new ContainerCustomWorkbench(player.field_71071_by, world, x, y, z);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == backpackGUI_ID) {
            BackpackInventory backpackInventory = new BackpackInventory(player.field_71071_by.func_70448_g(), player, 0);
            return new GuiBackpack(backpackInventory, player.field_71071_by);
        }
        if (ID == workbenchGUI_ID) {
            return new GuiPortable(player, world, x, y, z);
        }
        return null;
    }

    static {
        canVersionCheck = true;
        backpackGUI_ID = 0;
        workbenchGUI_ID = 1;
    }
}

