/*
 * Decompiled with CFR 0.152.
 */
package mods.core.PaneInTheGlass;

import cpw.mods.fml.common.FMLLog;
import mods.core.PaneInTheGlass.BlockPaneOverrides;
import mods.core.PaneInTheGlass.BlockRenderer;
import mods.util.registry.NameRegistry;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    private NameRegistry nameRegistry;
    private String blockPaneClassName;
    private String blockStairsClassName;
    private String worldRendererClassName;

    public ClassTransformer() {
        try {
            this.nameRegistry = new NameRegistry();
            this.nameRegistry.RegisterSrgName("CL: net/minecraft/block/BlockPane amm");
            this.nameRegistry.RegisterSrgName("MD: net/minecraft/block/BlockPane/canPaneConnectToBlock (Lnet/minecraft/block/Block;)Z amm/a (Lahu;)Z");
            this.nameRegistry.RegisterSrgName("CL: net/minecraft/block/BlockStairs ame");
            this.nameRegistry.RegisterSrgName("MD: net/minecraft/block/BlockStairs/getRenderBlockPass ()I ame/w ()I");
            this.nameRegistry.RegisterSrgName("MD: net/minecraft/block/BlockStairs/getRenderType ()I ame/b ()I");
            this.nameRegistry.RegisterSrgName("CL: net/minecraft/client/renderer/WorldRenderer blg");
            this.nameRegistry.RegisterSrgName("MD: net/minecraft/client/renderer/WorldRenderer/preRenderBlocks (I)V blg/b (I)V");
            FMLLog.info((String)"Getting class names", (Object[])new Object[0]);
            this.blockPaneClassName = this.nameRegistry.getClassName("net/minecraft/block/BlockPane").replace('/', '.');
            this.blockStairsClassName = this.nameRegistry.getClassName("net/minecraft/block/BlockStairs").replace('/', '.');
            this.worldRendererClassName = this.nameRegistry.getClassName("net/minecraft/client/renderer/WorldRenderer").replace('/', '.');
        }
        catch (Exception e) {
            FMLLog.severe((String)("UH OH: " + e.toString()), (Object[])new Object[0]);
        }
    }

    public byte[] transform(String className, String transformedName, byte[] basicClass) {
        if (className.equals(this.blockPaneClassName) || className.equals(this.blockStairsClassName) || className.equals(this.worldRendererClassName)) {
            return this.patchClass(className, basicClass);
        }
        return basicClass;
    }

    private byte[] patchClass(String className, byte[] classData) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classData);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (className.equals(this.blockPaneClassName) && this.nameRegistry.MethodIs(m, "net/minecraft/block/BlockPane/canPaneConnectToBlock (Lnet/minecraft/block/Block;)Z")) {
                this.patchBlockPane_canPaneConnectToBlock(m);
                continue;
            }
            if (className.equals(this.blockStairsClassName) && this.nameRegistry.MethodIs(m, "net/minecraft/block/BlockStairs/getRenderBlockPass ()I")) {
                this.patchBlockStairs_getRenderBlockPass(m);
                continue;
            }
            if (className.equals(this.blockStairsClassName) && this.nameRegistry.MethodIs(m, "net/minecraft/block/BlockStairs/getRenderType ()I")) {
                this.patchBlockStairs_getRenderType(m);
                continue;
            }
            if (!className.equals(this.worldRendererClassName) || !this.nameRegistry.MethodIs(m, "net/minecraft/client/renderer/WorldRenderer/preRenderBlocks (I)V")) continue;
            this.patchWorldRenderer_preRenderBlocks(m);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void patchBlockPane_canPaneConnectToBlock(MethodNode m) {
        Type targetClass = Type.getType(BlockPaneOverrides.class);
        String targetSig = this.nameRegistry.getMethodSignature("net/minecraft/block/BlockPane/canPaneConnectToBlock", "(Lnet/minecraft/block/Block;)Z");
        m.instructions.clear();
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, targetClass.getInternalName(), "canPaneConnectToBlock", targetSig));
        m.instructions.add((AbstractInsnNode)new InsnNode(172));
    }

    private void patchBlockStairs_getRenderBlockPass(MethodNode m) {
        m.instructions.clear();
        m.instructions.add((AbstractInsnNode)new InsnNode(4));
        m.instructions.add((AbstractInsnNode)new InsnNode(172));
    }

    private void patchBlockStairs_getRenderType(MethodNode m) {
        Type modBlockRenderer = Type.getType(BlockRenderer.class);
        m.instructions.clear();
        m.instructions.add((AbstractInsnNode)new FieldInsnNode(178, modBlockRenderer.getInternalName(), "newBlockStairsRenderType", "I"));
        m.instructions.add((AbstractInsnNode)new InsnNode(172));
    }

    private void patchWorldRenderer_preRenderBlocks(MethodNode m) {
        Type modBlockRenderer = Type.getType(BlockRenderer.class);
        InsnList payload = new InsnList();
        payload.add((AbstractInsnNode)new VarInsnNode(21, 1));
        payload.add((AbstractInsnNode)new FieldInsnNode(179, modBlockRenderer.getInternalName(), "renderPass", "I"));
        m.instructions.insert(payload);
    }
}

