/*
 * Decompiled with CFR 0.152.
 */
package mods.util.registry;

import cpw.mods.fml.common.FMLLog;
import java.util.HashMap;
import net.minecraft.block.Block;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class NameRegistry {
    private boolean isObfuscated = false;
    private HashMap<String, SeargeData> m_NameList = new HashMap();

    public NameRegistry() {
        FMLLog.info((String)"NameRegistry is testing for obfuscation", (Object[])new Object[0]);
        this.isObfuscated = true;
        FMLLog.info((String)("NameRegistry: isObfuscated=" + this.isObfuscated), (Object[])new Object[0]);
    }

    private void TestForBlock() throws ClassNotFoundException {
        Type testType = Type.getType(Block.class);
    }

    public String getClassName(String className) {
        String indexer = this.normalizeName(className);
        SeargeData srg = this.m_NameList.get(indexer);
        return srg == null ? null : (this.isObfuscated ? srg.objectNameObfuscated : srg.objectName);
    }

    public String getMethodNameWithClass(String methodName, String methodSignature) {
        String indexer = this.normalizeName(methodName + " " + methodSignature);
        SeargeData srg = this.m_NameList.get(indexer);
        return srg == null ? null : (this.isObfuscated ? srg.objectNameObfuscated : srg.objectName);
    }

    public String getMethodName(String methodName, String methodSignature) {
        int slash;
        String nameWithClass = this.getMethodNameWithClass(methodName, methodSignature);
        if (nameWithClass != null && (slash = nameWithClass.lastIndexOf(47)) > -1) {
            nameWithClass = nameWithClass.substring(slash + 1);
        }
        return nameWithClass;
    }

    public String getMethodSignature(String methodName, String methodSignature) {
        String indexer = this.normalizeName(methodName + " " + methodSignature);
        SeargeData srg = this.m_NameList.get(indexer);
        return srg == null ? null : (this.isObfuscated ? srg.objectSignatureObfuscated : srg.objectSignature);
    }

    public boolean MethodIs(MethodNode methodNode, String methodNameWithSignature) {
        String indexer = this.normalizeName(methodNameWithSignature);
        SeargeData srg = this.m_NameList.get(indexer);
        String methodName = "/" + this.normalizeName(methodNode.name);
        String methodSig = this.normalizeName(methodNode.desc);
        if (srg != null) {
            if (!this.isObfuscated) {
                return srg.objectName.endsWith(methodName) && methodSig.equals(srg.objectSignature);
            }
            return srg.objectNameObfuscated.endsWith(methodName) && methodSig.equals(srg.objectSignatureObfuscated);
        }
        return false;
    }

    public void RegisterSrgName(String data) {
        SeargeData item = new SeargeData(data);
        this.m_NameList.put(item.uniqueName, item);
    }

    private String normalizeName(String name) {
        return name.replace('.', '/');
    }

    private class SeargeData {
        public String uniqueName;
        public String objectName;
        public String objectNameObfuscated;
        public String objectSignature;
        public String objectSignatureObfuscated;

        public SeargeData(String src) {
            String[] srcToken = src.split("\\s+");
            if (!srcToken[0].equals("PK:")) {
                if (srcToken[0].equals("CL:")) {
                    if (srcToken.length == 3) {
                        this.objectName = srcToken[1];
                        this.objectNameObfuscated = srcToken[2];
                        this.uniqueName = this.objectName;
                    }
                } else if (srcToken[0].equals("MD:") && srcToken.length == 5) {
                    this.objectName = srcToken[1];
                    this.objectNameObfuscated = srcToken[3];
                    this.objectSignature = srcToken[2];
                    this.objectSignatureObfuscated = srcToken[4];
                    this.uniqueName = this.objectName + " " + this.objectSignature;
                }
            }
        }
    }
}

