/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import twilightforest.TFMagicMapData;
import twilightforest.item.ItemTFMagicMap;
import twilightforest.item.TFItems;

public class TFMagicMapRenderer
implements IItemRenderer {
    private static final ResourceLocation vanillaMapIcons = new ResourceLocation("textures/map/map_icons.png");
    private static final ResourceLocation twilightMapIcons = new ResourceLocation("twilightforest:textures/gui/mapicons.png");
    private static final ResourceLocation mapBackgroundTextures = new ResourceLocation("textures/map/map_background.png");
    private int[] intArray = new int[16384];
    private DynamicTexture bufferedImage;
    private GameSettings gameSettings;
    private FontRenderer fontRenderer;
    private final ResourceLocation textureLoc;

    public TFMagicMapRenderer(GameSettings par1GameSettings, TextureManager par2TextureManager) {
        this.gameSettings = par1GameSettings;
        this.bufferedImage = new DynamicTexture(128, 128);
        this.textureLoc = par2TextureManager.func_110578_a("map", this.bufferedImage);
        this.intArray = this.bufferedImage.func_110565_c();
        for (int i = 0; i < this.intArray.length; ++i) {
            this.intArray[i] = 0;
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return item.func_77973_b() == TFItems.magicMap && (type == IItemRenderer.ItemRenderType.FIRST_PERSON_MAP || RenderItem.field_82407_g && type == IItemRenderer.ItemRenderType.ENTITY);
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.FIRST_PERSON_MAP) {
            EntityPlayer player = (EntityPlayer)data[0];
            TextureManager renderEngine = (TextureManager)data[1];
            MapData mapData = (MapData)data[2];
            if (mapData != null && mapData instanceof TFMagicMapData) {
                this.renderMap(player, renderEngine, (TFMagicMapData)mapData);
            }
        } else if (RenderItem.field_82407_g) {
            RenderBlocks renderBlocks = (RenderBlocks)data[0];
            EntityItem entity = (EntityItem)data[1];
            TFMagicMapData mapData = ((ItemTFMagicMap)TFItems.magicMap).getMapData(item, entity.field_70170_p);
            if (mapData != null) {
                this.renderMapInFrame(item, RenderManager.field_78727_a, mapData);
            }
        }
    }

    public void renderMap(EntityPlayer par1EntityPlayer, TextureManager par2TextureManager, TFMagicMapData par3MapData) {
        float var24;
        float var22;
        float var23;
        float var21;
        TFMagicMapData magicMapData = par3MapData;
        for (int i = 0; i < 16384; ++i) {
            int colorByte = par3MapData.field_76198_e[i] & 0xFF;
            if (colorByte == 0) {
                this.intArray[i] = (i + i / 128 & 1) * 8 + 16 << 24;
                continue;
            }
            int biomeID = colorByte - 1;
            BiomeGenBase biome = BiomeGenBase.func_150565_n()[biomeID];
            if (biome == null) continue;
            this.intArray[i] = 0xFF000000 | biome.field_76790_z;
        }
        this.bufferedImage.func_110564_a();
        int var15 = 0;
        int var16 = 0;
        Tessellator tesselator = Tessellator.field_78398_a;
        float var18 = 0.0f;
        par2TextureManager.func_110577_a(this.textureLoc);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
        GL11.glDisable((int)3008);
        tesselator.func_78382_b();
        tesselator.func_78374_a((double)((float)(var15 + 0) + var18), (double)((float)(var16 + 128) - var18), (double)-0.01f, 0.0, 1.0);
        tesselator.func_78374_a((double)((float)(var15 + 128) - var18), (double)((float)(var16 + 128) - var18), (double)-0.01f, 1.0, 1.0);
        tesselator.func_78374_a((double)((float)(var15 + 128) - var18), (double)((float)(var16 + 0) + var18), (double)-0.01f, 1.0, 0.0);
        tesselator.func_78374_a((double)((float)(var15 + 0) + var18), (double)((float)(var16 + 0) + var18), (double)-0.01f, 0.0, 0.0);
        tesselator.func_78381_a();
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        par2TextureManager.func_110577_a(vanillaMapIcons);
        for (MapData.MapCoord mapCoord : par3MapData.field_76203_h.values()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)var15 + (float)mapCoord.field_76214_b / 2.0f + 64.0f), (float)((float)var16 + (float)mapCoord.field_76215_c / 2.0f + 64.0f), (float)-0.04f);
            GL11.glRotatef((float)((float)(mapCoord.field_76212_d * 360) / 16.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)4.0f, (float)4.0f, (float)3.0f);
            GL11.glTranslatef((float)-0.125f, (float)0.125f, (float)0.0f);
            var21 = (float)(mapCoord.field_76216_a % 4 + 0) / 4.0f;
            var23 = (float)(mapCoord.field_76216_a / 4 + 0) / 4.0f;
            var22 = (float)(mapCoord.field_76216_a % 4 + 1) / 4.0f;
            var24 = (float)(mapCoord.field_76216_a / 4 + 1) / 4.0f;
            tesselator.func_78382_b();
            tesselator.func_78374_a(-1.0, 1.0, 0.0, (double)var21, (double)var23);
            tesselator.func_78374_a(1.0, 1.0, 0.0, (double)var22, (double)var23);
            tesselator.func_78374_a(1.0, -1.0, 0.0, (double)var22, (double)var24);
            tesselator.func_78374_a(-1.0, -1.0, 0.0, (double)var21, (double)var24);
            tesselator.func_78381_a();
            GL11.glPopMatrix();
        }
        par2TextureManager.func_110577_a(twilightMapIcons);
        for (MapData.MapCoord mapCoord : magicMapData.featuresVisibleOnMap) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)var15 + (float)mapCoord.field_76214_b / 2.0f + 64.0f), (float)((float)var16 + (float)mapCoord.field_76215_c / 2.0f + 64.0f), (float)-0.02f);
            GL11.glRotatef((float)((float)(mapCoord.field_76212_d * 360) / 16.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)4.0f, (float)4.0f, (float)3.0f);
            GL11.glTranslatef((float)-0.125f, (float)0.125f, (float)0.0f);
            var21 = (float)(mapCoord.field_76216_a % 8 + 0) / 8.0f;
            var23 = (float)(mapCoord.field_76216_a / 8 + 0) / 8.0f;
            var22 = (float)(mapCoord.field_76216_a % 8 + 1) / 8.0f;
            var24 = (float)(mapCoord.field_76216_a / 8 + 1) / 8.0f;
            tesselator.func_78382_b();
            tesselator.func_78374_a(-1.0, 1.0, 0.0, (double)var21, (double)var23);
            tesselator.func_78374_a(1.0, 1.0, 0.0, (double)var22, (double)var23);
            tesselator.func_78374_a(1.0, -1.0, 0.0, (double)var22, (double)var24);
            tesselator.func_78374_a(-1.0, -1.0, 0.0, (double)var21, (double)var24);
            tesselator.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    private void renderMapInFrame(ItemStack item, RenderManager renderManager, TFMagicMapData mapData) {
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
        GL11.glTranslatef((float)-65.0f, (float)-111.0f, (float)-3.0f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        renderManager.field_78724_e.func_110577_a(mapBackgroundTextures);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        int b0 = 7;
        tessellator.func_78374_a((double)(0 - b0), (double)(128 + b0), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)(128 + b0), (double)(128 + b0), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(128 + b0), (double)(0 - b0), 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)(0 - b0), (double)(0 - b0), 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
        this.renderMap(null, renderManager.field_78724_e, mapData);
    }
}

