/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.world.MapGenTFMajorFeature;
import twilightforest.world.TFGenCaves;
import twilightforest.world.TFGenRavine;
import twilightforest.world.TFWorld;

public class ChunkProviderTwilightForest
implements IChunkProvider {
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private double[] landMap;
    private double[] stoneNoise;
    private TFGenCaves caveGenerator;
    private TFGenRavine ravineGenerator;
    private BiomeGenBase[] biomesForGeneration;
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    float[] squareTable;
    int[][] unusedIntArray32x32;
    private WorldType field_147435_p;
    private NoiseGeneratorOctaves field_147431_j;
    private NoiseGeneratorOctaves field_147432_k;
    private NoiseGeneratorOctaves field_147429_l;
    private NoiseGeneratorPerlin field_147430_m;
    private final double[] terrainCalcs;
    private final float[] parabolicField;
    double[] field_147427_d;
    double[] field_147428_e;
    double[] field_147425_f;
    double[] field_147426_g;
    int[][] field_73219_j = new int[32][32];
    private MapGenTFMajorFeature majorFeatureGenerator;

    public ChunkProviderTwilightForest(World world, long l, boolean flag) {
        this.stoneNoise = new double[256];
        this.caveGenerator = new TFGenCaves();
        this.majorFeatureGenerator = new MapGenTFMajorFeature();
        this.ravineGenerator = new TFGenRavine();
        this.unusedIntArray32x32 = new int[32][32];
        this.worldObj = world;
        this.rand = new Random(l);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_147435_p = world.func_72912_H().func_76067_t();
        this.field_147431_j = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_147432_k = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_147429_l = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_147430_m = new NoiseGeneratorPerlin(this.rand, 4);
        this.terrainCalcs = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    public Chunk func_73154_d(int cx, int cz) {
        this.rand.setSeed((long)cx * 341873128712L + (long)cz * 132897987541L);
        Block[] blockStorage = new Block[256 * TFWorld.CHUNKHEIGHT];
        byte[] metaStorage = new byte[256 * TFWorld.CHUNKHEIGHT];
        this.generateTerrain2(cx, cz, blockStorage);
        this.squishTerrain(blockStorage);
        this.addDarkForestCanopy2(cx, cz, blockStorage, metaStorage);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, cx * 16, cz * 16, 16, 16);
        this.addGlaciers(cx, cz, blockStorage, metaStorage, this.biomesForGeneration);
        this.deformTerrainForFeature(cx, cz, blockStorage);
        this.replaceBlocksForBiome(cx, cz, blockStorage, this.biomesForGeneration);
        this.caveGenerator.func_151539_a(this, this.worldObj, cx, cz, blockStorage);
        this.ravineGenerator.func_151539_a(this, this.worldObj, cx, cz, blockStorage);
        Block[] fake = new Block[]{};
        this.majorFeatureGenerator.func_151539_a(this, this.worldObj, cx, cz, fake);
        Chunk chunk = new Chunk(this.worldObj, blockStorage, metaStorage, cx, cz);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)this.biomesForGeneration[i].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(int cx, int cz, Block[] blockStorage) {
        int four = 4;
        int eight = 8;
        byte seaLevel = (byte)TFWorld.SEALEVEL;
        int five = four + 1;
        int nine = 9;
        int fife = four + 1;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, cx * 4 - 2, cz * 4 - 2, five + 5, fife + 5);
        this.landMap = this.makeLandPerBiome(this.landMap, cx * four, 0, cz * four, five, nine, fife);
        for (int k = 0; k < four; ++k) {
            for (int l = 0; l < four; ++l) {
                for (int i1 = 0; i1 < eight; ++i1) {
                    double d = 0.125;
                    double d1 = this.landMap[((k + 0) * fife + (l + 0)) * nine + (i1 + 0)];
                    double d2 = this.landMap[((k + 0) * fife + (l + 1)) * nine + (i1 + 0)];
                    double d3 = this.landMap[((k + 1) * fife + (l + 0)) * nine + (i1 + 0)];
                    double d4 = this.landMap[((k + 1) * fife + (l + 1)) * nine + (i1 + 0)];
                    double d5 = (this.landMap[((k + 0) * fife + (l + 0)) * nine + (i1 + 1)] - d1) * d;
                    double d6 = (this.landMap[((k + 0) * fife + (l + 1)) * nine + (i1 + 1)] - d2) * d;
                    double d7 = (this.landMap[((k + 1) * fife + (l + 0)) * nine + (i1 + 1)] - d3) * d;
                    double d8 = (this.landMap[((k + 1) * fife + (l + 1)) * nine + (i1 + 1)] - d4) * d;
                    for (int j1 = 0; j1 < 8; ++j1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k1 = 0; k1 < 4; ++k1) {
                            int l1 = k1 + k * 4 << 11 | 0 + l * 4 << 7 | i1 * 8 + j1;
                            int c = 128;
                            l1 -= c;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            d15 -= d16;
                            for (int i2 = 0; i2 < 4; ++i2) {
                                double d17;
                                d15 += d16;
                                blockStorage[l1 += c] = d17 > 0.0 ? Blocks.field_150348_b : (i1 * 8 + j1 < seaLevel ? Blocks.field_150355_j : Blocks.field_150350_a);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void generateTerrain2(int chunkX, int chunkZ, Block[] blockStorage) {
        int seaLevel = 63;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.makeLandPerBiome2(chunkX * 4, 0, chunkZ * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double d0 = 0.125;
                    double d1 = this.terrainCalcs[k1 + k2];
                    double d2 = this.terrainCalcs[l1 + k2];
                    double d3 = this.terrainCalcs[i2 + k2];
                    double d4 = this.terrainCalcs[j2 + k2];
                    double d5 = (this.terrainCalcs[k1 + k2 + 1] - d1) * d0;
                    double d6 = (this.terrainCalcs[l1 + k2 + 1] - d2) * d0;
                    double d7 = (this.terrainCalcs[i2 + k2 + 1] - d3) * d0;
                    double d8 = (this.terrainCalcs[j2 + k2 + 1] - d4) * d0;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            int j3 = i3 + k * 4 << 12 | 0 + j1 * 4 << 8 | k2 * 8 + l2;
                            int short1 = 256;
                            j3 -= short1;
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int k3 = 0; k3 < 4; ++k3) {
                                double d;
                                d15 += d16;
                                blockStorage[j3 += short1] = d > 0.0 ? Blocks.field_150348_b : (k2 * 8 + l2 < seaLevel ? Blocks.field_150355_j : null);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void makeLandPerBiome2(int x, int zero, int z) {
        this.field_147426_g = this.noiseGen6.func_76305_a(this.field_147426_g, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.field_147427_d = this.field_147429_l.func_76304_a(this.field_147427_d, x, zero, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.field_147428_e = this.field_147431_j.func_76304_a(this.field_147428_e, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.field_147425_f = this.field_147432_k.func_76304_a(this.field_147425_f, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[ax + 2 + (az + 2) * 10];
                for (int ox = -two; ox <= two; ++ox) {
                    for (int oz = -two; oz <= two; ++oz) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biomegenbase1.field_76748_D;
                        float heightVariation = biomegenbase1.field_76749_E;
                        if (this.field_147435_p == WorldType.field_151360_e && rootHeight > 0.0f) {
                            rootHeight = 1.0f + rootHeight * 2.0f;
                            heightVariation = 1.0f + heightVariation * 4.0f;
                        }
                        float heightFactor = this.parabolicField[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.field_147426_g[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = totalVariation;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.field_147428_e[terrainIndex] / 512.0;
                    double d8 = this.field_147425_f[terrainIndex] / 512.0;
                    double d9 = (this.field_147427_d[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d11 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d11) + -10.0 * d11;
                    }
                    this.terrainCalcs[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    private double[] makeLandPerBiome(double[] ad, int xx, int zero, int zz, int five, int nine, int fi5e) {
        if (ad == null) {
            ad = new double[five * nine * fi5e];
        }
        if (this.squareTable == null) {
            this.squareTable = new float[25];
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -2; l1 <= 2; ++l1) {
                    float f;
                    this.squareTable[k1 + 2 + (l1 + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(k1 * k1 + l1 * l1) + 0.2f));
                }
            }
        }
        double d = 684.412;
        double d1 = 684.412;
        this.noise5 = this.noiseGen5.func_76305_a(this.noise5, xx, zz, five, fi5e, 1.121, 1.121, 0.5);
        this.noise6 = this.noiseGen6.func_76305_a(this.noise6, xx, zz, five, fi5e, 200.0, 200.0, 0.5);
        this.noise3 = this.noiseGen3.func_76304_a(this.noise3, xx, zero, zz, five, nine, fi5e, d / 80.0, d1 / 160.0, d / 80.0);
        this.noise1 = this.noiseGen1.func_76304_a(this.noise1, xx, zero, zz, five, nine, fi5e, d, d1, d);
        this.noise2 = this.noiseGen2.func_76304_a(this.noise2, xx, zero, zz, five, nine, fi5e, d, d1, d);
        zz = 0;
        xx = 0;
        int i2 = 0;
        int j2 = 0;
        for (int k2 = 0; k2 < five; ++k2) {
            for (int l2 = 0; l2 < fi5e; ++l2) {
                float f1 = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                int two = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[k2 + 2 + (l2 + 2) * (five + 5)];
                for (int i3 = -two; i3 <= two; ++i3) {
                    for (int j3 = -two; j3 <= two; ++j3) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[k2 + i3 + 2 + (l2 + j3 + 2) * (five + 5)];
                        float f4 = this.squareTable[i3 + 2 + (j3 + 2) * 5] / (biomegenbase1.field_76748_D + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            f4 /= 2.0f;
                        }
                        f1 += biomegenbase1.field_76749_E * f4;
                        f2 += biomegenbase1.field_76748_D * f4;
                        f3 += f4;
                    }
                }
                f1 /= f3;
                f2 /= f3;
                f1 = f1 * 0.9f + 0.1f;
                f2 = (f2 * 4.0f - 1.0f) / 8.0f;
                double d2 = this.noise6[j2] / 8000.0;
                if (d2 < 0.0) {
                    d2 = -d2 * 0.3;
                }
                if ((d2 = d2 * 3.0 - 2.0) < 0.0) {
                    if ((d2 /= 2.0) < -1.0) {
                        d2 = -1.0;
                    }
                    d2 /= 1.4;
                    d2 /= 2.0;
                } else {
                    if (d2 > 1.0) {
                        d2 = 1.0;
                    }
                    d2 /= 8.0;
                }
                ++j2;
                for (int k3 = 0; k3 < nine; ++k3) {
                    double d3 = f2;
                    double d4 = f1;
                    d3 += d2 * 0.2;
                    d3 = d3 * (double)nine / 16.0;
                    double d5 = (double)nine / 2.0 + d3 * 4.0;
                    double d6 = 0.0;
                    double d7 = ((double)k3 - d5) * 12.0 * 128.0 / (double)TFWorld.CHUNKHEIGHT / d4;
                    if (d7 < 0.0) {
                        d7 *= 4.0;
                    }
                    double d8 = this.noise1[i2] / 512.0;
                    double d9 = this.noise2[i2] / 512.0;
                    double d10 = (this.noise3[i2] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k3 > nine - 4) {
                        double d11 = (float)(k3 - (nine - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    ad[i2] = d6;
                    ++i2;
                }
            }
        }
        return ad;
    }

    private void squishTerrain(Block[] blockStorage) {
        int squishHeight = TFWorld.MAXHEIGHT / 2;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < TFWorld.CHUNKHEIGHT; ++y) {
                    int index = x * TFWorld.CHUNKHEIGHT * 16 | z * TFWorld.CHUNKHEIGHT | y;
                    if (y < squishHeight) {
                        int twiceIndex = x * TFWorld.CHUNKHEIGHT * 16 | z * TFWorld.CHUNKHEIGHT | y * 2;
                        blockStorage[index] = blockStorage[twiceIndex];
                        continue;
                    }
                    blockStorage[index] = Blocks.field_150350_a;
                }
            }
        }
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, Block[] blockArray4096, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        byte sealevel = (byte)TFWorld.SEALEVEL;
        double d = 0.03125;
        this.stoneNoise = this.noiseGen4.func_76304_a(this.stoneNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                BiomeGenBase biomegenbase = par4ArrayOfBiomeGenBase[j + i * 16];
                if (biomegenbase == null) {
                    biomegenbase = TFBiomeBase.twilightForest;
                }
                int k = (int)(this.stoneNoise[i + j * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int l = -1;
                Block top = biomegenbase.field_76752_A;
                Block filler = biomegenbase.field_76753_B;
                for (int currentY = 127; currentY >= 0; --currentY) {
                    int blockIndex = j * TFWorld.CHUNKHEIGHT * 16 | i * TFWorld.CHUNKHEIGHT | currentY;
                    if (currentY <= 0 + this.rand.nextInt(5)) {
                        blockArray4096[blockIndex] = Blocks.field_150357_h;
                        continue;
                    }
                    Block currentBlock = blockArray4096[blockIndex];
                    if (currentBlock != Blocks.field_150348_b) continue;
                    if (l == -1) {
                        if (k <= 0) {
                            top = Blocks.field_150350_a;
                            filler = Blocks.field_150348_b;
                        } else if (currentY >= sealevel - 4 && currentY <= sealevel + 1) {
                            top = biomegenbase.field_76752_A;
                            filler = biomegenbase.field_76753_B;
                        }
                        if (currentY < sealevel && top == Blocks.field_150350_a) {
                            top = biomegenbase.func_150564_a(chunkX, currentY, chunkZ) < 0.15f ? Blocks.field_150432_aD : Blocks.field_150355_j;
                        }
                        l = k;
                        if (currentY >= sealevel - 1) {
                            blockArray4096[blockIndex] = top;
                            continue;
                        }
                        blockArray4096[blockIndex] = filler;
                        continue;
                    }
                    if (l <= 0) continue;
                    blockArray4096[blockIndex] = filler;
                    if (--l != 0 || filler != Blocks.field_150354_m) continue;
                    l = this.rand.nextInt(4);
                    filler = Blocks.field_150322_A;
                }
            }
        }
    }

    public Chunk func_73158_c(int i, int j) {
        return this.func_73154_d(i, j);
    }

    public void deformTerrainForFeature(int cx, int cz, Block[] blockStorage) {
        TFFeature nearFeature = TFFeature.getNearestFeature(cx, cz, this.worldObj);
        if (!nearFeature.isTerrainAltered) {
            return;
        }
        int[] nearCenter = TFFeature.getNearestCenter(cx, cz, this.worldObj);
        int hx = nearCenter[0];
        int hz = nearCenter[1];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int dx = x - hx;
                int dz = z - hz;
                if (nearFeature == TFFeature.hill1 || nearFeature == TFFeature.hill2 || nearFeature == TFFeature.hill3 || nearFeature == TFFeature.hydraLair) {
                    int hdiam = (nearFeature.size * 2 + 1) * 16;
                    int dist = (int)Math.sqrt(dx * dx + dz * dz);
                    int hheight = (int)(Math.cos((double)((float)dist / (float)hdiam) * Math.PI) * (double)((float)hdiam / 3.0f));
                    this.raiseHills(blockStorage, nearFeature, hdiam, x, z, dx, dz, hheight);
                    continue;
                }
                if (nearFeature == TFFeature.hedgeMaze || nearFeature == TFFeature.nagaLair || nearFeature == TFFeature.questGrove) {
                    this.flattenTerrainForFeature(blockStorage, nearFeature, x, z, dx, dz);
                    continue;
                }
                if (nearFeature != TFFeature.yetiCave) continue;
                this.deformTerrainForYetiLair(blockStorage, nearFeature, x, z, dx, dz);
            }
        }
    }

    private void raiseHills(Block[] storage, TFFeature nearFeature, int hdiam, int x, int z, int dx, int dz, int hillHeight) {
        int newGround = -1;
        boolean foundGroundLevel = false;
        for (int y = 0; y < TFWorld.CHUNKHEIGHT; ++y) {
            int index = x * TFWorld.CHUNKHEIGHT * 16 | z * TFWorld.CHUNKHEIGHT | y;
            Block currentTerrain = storage[index];
            if (currentTerrain != Blocks.field_150348_b && !foundGroundLevel) {
                newGround = y + hillHeight;
                foundGroundLevel = true;
            }
            if (!foundGroundLevel || y > newGround) continue;
            storage[index] = Blocks.field_150348_b;
        }
        int hollow = hillHeight - 4 - nearFeature.size;
        if (nearFeature == TFFeature.hydraLair) {
            int mx = dx + 16;
            int mz = dz + 16;
            int mdist = (int)Math.sqrt(mx * mx + mz * mz);
            int mheight = (int)(Math.cos((double)mdist / ((double)hdiam / 1.5) * Math.PI) * ((double)hdiam / 1.5));
            hollow = Math.max(mheight - 4, hollow);
        }
        if (hollow < 0) {
            hollow = 0;
        }
        for (int y = 0; y < TFWorld.CHUNKHEIGHT; ++y) {
            int index = x * TFWorld.CHUNKHEIGHT * 16 | z * TFWorld.CHUNKHEIGHT | y;
            if (hillHeight > 0 && y < TFWorld.SEALEVEL && storage[index] != Blocks.field_150348_b) {
                storage[index] = Blocks.field_150348_b;
            }
            int hollowFloor = TFWorld.SEALEVEL - 3 - hollow / 8;
            if (nearFeature == TFFeature.hydraLair) {
                hollowFloor = TFWorld.SEALEVEL;
            }
            if (y <= hollowFloor || y >= hollowFloor + hollow) continue;
            storage[index] = Blocks.field_150350_a;
        }
    }

    private void flattenTerrainForFeature(Block[] storage, TFFeature nearFeature, int x, int z, int dx, int dz) {
        int index;
        int y;
        float squishfactor = 0.0f;
        int mazeheight = TFWorld.SEALEVEL + 1;
        int FEATUREBOUNDRY = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -FEATUREBOUNDRY) {
            squishfactor = (float)(-dx - FEATUREBOUNDRY) / 8.0f;
        }
        if (dx >= FEATUREBOUNDRY) {
            squishfactor = (float)(dx - FEATUREBOUNDRY) / 8.0f;
        }
        if (dz <= -FEATUREBOUNDRY) {
            squishfactor = Math.max(squishfactor, (float)(-dz - FEATUREBOUNDRY) / 8.0f);
        }
        if (dz >= FEATUREBOUNDRY) {
            squishfactor = Math.max(squishfactor, (float)(dz - FEATUREBOUNDRY) / 8.0f);
        }
        if (squishfactor > 0.0f) {
            int newGround = -1;
            for (y = 0; y <= 127; ++y) {
                index = (x * 16 + z) * TFWorld.CHUNKHEIGHT + y;
                Block currentTerrain = storage[index];
                if (currentTerrain == Blocks.field_150348_b || newGround != -1) continue;
                int oldGround = y;
                mazeheight = (int)((float)mazeheight + (float)(oldGround - mazeheight) * squishfactor);
                newGround = oldGround;
            }
        }
        for (y = 0; y <= 127; ++y) {
            index = (x * 16 + z) * TFWorld.CHUNKHEIGHT + y;
            if (y < mazeheight && (storage[index] == Blocks.field_150350_a || storage[index] == Blocks.field_150355_j)) {
                storage[index] = Blocks.field_150348_b;
            }
            if (y < mazeheight || storage[index] == Blocks.field_150355_j) continue;
            storage[index] = Blocks.field_150350_a;
        }
    }

    private void deformTerrainForYetiLair(Block[] storage, TFFeature nearFeature, int x, int z, int dx, int dz) {
        int index;
        int y;
        float squishfactor = 0.0f;
        int topHeight = TFWorld.SEALEVEL + 24;
        int outerBoundry = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -outerBoundry) {
            squishfactor = (float)(-dx - outerBoundry) / 8.0f;
        }
        if (dx >= outerBoundry) {
            squishfactor = (float)(dx - outerBoundry) / 8.0f;
        }
        if (dz <= -outerBoundry) {
            squishfactor = Math.max(squishfactor, (float)(-dz - outerBoundry) / 8.0f);
        }
        if (dz >= outerBoundry) {
            squishfactor = Math.max(squishfactor, (float)(dz - outerBoundry) / 8.0f);
        }
        int caveBoundry = nearFeature.size * 2 * 8 - 8;
        int hollowCeiling = TFWorld.SEALEVEL + 16;
        int offset = Math.min(Math.abs(dx), Math.abs(dz));
        hollowCeiling = TFWorld.SEALEVEL + 40 - offset * 4;
        if (dx >= -caveBoundry && dz >= -caveBoundry && dx <= caveBoundry && dz <= caveBoundry) {
            hollowCeiling = TFWorld.SEALEVEL + 16;
        }
        hollowCeiling -= offset / 6;
        hollowCeiling = Math.min(hollowCeiling, TFWorld.SEALEVEL + 16);
        int hollowFloor = TFWorld.SEALEVEL - 1 + offset / 6;
        if (squishfactor > 0.0f) {
            int newGround = -1;
            for (y = 0; y <= 127; ++y) {
                index = (x * 16 + z) * TFWorld.CHUNKHEIGHT + y;
                Block currentTerrain = storage[index];
                if (currentTerrain == Blocks.field_150348_b || newGround != -1) continue;
                int oldGround = y;
                topHeight = (int)((float)topHeight + (float)(oldGround - topHeight) * squishfactor);
                hollowFloor = (int)((float)hollowFloor + (float)(oldGround - hollowFloor) * squishfactor);
                newGround = oldGround;
            }
        }
        for (y = 0; y <= 127; ++y) {
            index = (x * 16 + z) * TFWorld.CHUNKHEIGHT + y;
            if (y < topHeight && (storage[index] == null || storage[index] == Blocks.field_150350_a || storage[index] == Blocks.field_150355_j)) {
                storage[index] = Blocks.field_150348_b;
            }
            if (y > hollowFloor && y < hollowCeiling) {
                storage[index] = Blocks.field_150350_a;
            }
            if (y != hollowFloor || y >= hollowCeiling || y >= TFWorld.SEALEVEL + 3) continue;
            storage[index] = Blocks.field_150403_cj;
        }
    }

    public void addGlaciers(int chunkX, int chunkZ, Block[] blocks, byte[] meta, BiomeGenBase[] biomes) {
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                BiomeGenBase biome = biomes[x & 0xF | (z & 0xF) << 4];
                if (biome != TFBiomeBase.glacier) continue;
                int topLevel = -1;
                for (int y = 127; y >= 0; --y) {
                    int index = x * TFWorld.CHUNKHEIGHT * 16 | z * TFWorld.CHUNKHEIGHT | y;
                    Block currentBlock = blocks[index];
                    if (currentBlock != Blocks.field_150348_b) continue;
                    topLevel = y;
                    blocks[index] = Blocks.field_150351_n;
                    break;
                }
                int gHeight = 32;
                int gTop = topLevel + gHeight + 1;
                for (int y = topLevel + 1; y <= gTop && y < 128; ++y) {
                    int index = x * TFWorld.CHUNKHEIGHT * 16 | z * TFWorld.CHUNKHEIGHT | y;
                    blocks[index] = Blocks.field_150432_aD;
                }
            }
        }
    }

    public void addDarkForestCanopy(int chunkX, int chunkZ, Block[] blocks, byte[] meta, BiomeGenBase[] biomes) {
        double d = 0.03125;
        this.stoneNoise = this.noiseGen4.func_76304_a(this.stoneNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                int index;
                Block currentBlock;
                int hz;
                int dz;
                int[] nearCenter;
                int hx;
                int dx;
                int dist;
                BiomeGenBase biome = biomes[x & 0xF | (z & 0xF) << 4];
                boolean generateForest = biome == TFBiomeBase.darkForest || biome == TFBiomeBase.darkForestCenter;
                TFFeature nearFeature = TFFeature.getNearestFeature(chunkX, chunkZ, this.worldObj);
                if (nearFeature == TFFeature.darkTower && (dist = (int)Math.sqrt((dx = x - (hx = (nearCenter = TFFeature.getNearestCenter(chunkX, chunkZ, this.worldObj))[0])) * dx + (dz = z - (hz = nearCenter[1])) * dz)) < 20) {
                    generateForest = false;
                }
                if (!generateForest) continue;
                int topLevel = -1;
                for (int y = 127; y >= 0 && (currentBlock = blocks[index = x * TFWorld.CHUNKHEIGHT * 16 | z * TFWorld.CHUNKHEIGHT | y]) != Blocks.field_150355_j; --y) {
                    if (currentBlock != Blocks.field_150348_b) continue;
                    topLevel = y;
                    break;
                }
                if (topLevel == -1) continue;
                int noise = Math.min(3, (int)(this.stoneNoise[z & 0xF | (x & 0xF) << 4] / 1.25));
                int treeBottom = topLevel + 7 - noise;
                int treeTop = treeBottom + 11;
                for (int y = treeBottom; y <= treeTop; ++y) {
                    int index2 = x * TFWorld.CHUNKHEIGHT * 16 | z * TFWorld.CHUNKHEIGHT | y;
                    blocks[index2] = TFBlocks.hedge;
                    meta[index2] = 1;
                }
            }
        }
    }

    public void addDarkForestCanopy2(int chunkX, int chunkZ, Block[] blocks, byte[] meta) {
        int x;
        int z;
        int[] thicks = new int[25];
        for (z = 0; z < 5; ++z) {
            for (x = 0; x < 5; ++x) {
                for (int bx = -1; bx <= 1; ++bx) {
                    for (int bz = -1; bz <= 1; ++bz) {
                        BiomeGenBase biome = this.biomesForGeneration[x + bx + 2 + (z + bz + 2) * 10];
                        if (biome != TFBiomeBase.darkForest && biome != TFBiomeBase.darkForestCenter) continue;
                        int n = x + z * 5;
                        thicks[n] = thicks[n] + 1;
                    }
                }
            }
        }
        for (z = 0; z < 16; ++z) {
            for (x = 0; x < 16; ++x) {
                int index;
                Block currentBlock;
                boolean generateForest;
                int hz;
                int dz;
                int[] nearCenter;
                int hx;
                int dx;
                int dist;
                int qx = x / 4;
                int qz = z / 4;
                float xweight = (float)(x % 4) * 0.25f + 0.125f;
                float zweight = (float)(z % 4) * 0.25f + 0.125f;
                float thickness = 0.0f;
                thickness += (float)thicks[qx + qz * 5] * (1.0f - xweight) * (1.0f - zweight);
                thickness += (float)thicks[qx + 1 + qz * 5] * xweight * (1.0f - zweight);
                thickness += (float)thicks[qx + (qz + 1) * 5] * (1.0f - xweight) * zweight;
                thickness += (float)thicks[qx + 1 + (qz + 1) * 5] * xweight * zweight;
                thickness -= 4.0f;
                TFFeature nearFeature = TFFeature.getNearestFeature(chunkX, chunkZ, this.worldObj);
                if (nearFeature == TFFeature.darkTower && (dist = (int)Math.sqrt((dx = x - (hx = (nearCenter = TFFeature.getNearestCenter(chunkX, chunkZ, this.worldObj))[0])) * dx + (dz = z - (hz = nearCenter[1])) * dz)) < 24) {
                    thickness -= (float)(24 - dist);
                }
                boolean bl = generateForest = thickness > 1.0f;
                if (!generateForest) continue;
                double d = 0.03125;
                this.stoneNoise = this.noiseGen4.func_76304_a(this.stoneNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
                int topLevel = -1;
                for (int y = 127; y >= 0 && (currentBlock = blocks[index = x * TFWorld.CHUNKHEIGHT * 16 | z * TFWorld.CHUNKHEIGHT | y]) != Blocks.field_150355_j; --y) {
                    if (currentBlock != Blocks.field_150348_b) continue;
                    topLevel = y;
                    break;
                }
                if (topLevel == -1) continue;
                int noise = Math.min(3, (int)(this.stoneNoise[z & 0xF | (x & 0xF) << 4] / 1.25));
                int treeBottom = topLevel + 12 - (int)(thickness * 0.5f);
                int treeTop = treeBottom + (int)(thickness * 1.5f);
                for (int y = treeBottom -= noise; y < treeTop; ++y) {
                    int index2 = x * TFWorld.CHUNKHEIGHT * 16 | z * TFWorld.CHUNKHEIGHT | y;
                    blocks[index2] = TFBlocks.hedge;
                    meta[index2] = 1;
                }
            }
        }
    }

    public boolean func_73149_a(int i, int j) {
        return true;
    }

    public void func_73153_a(IChunkProvider ichunkprovider, int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int mapX = chunkX * 16;
        int mapY = chunkZ * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(mapX + 16, mapY + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * l1 + (long)chunkZ * l2 ^ this.worldObj.func_72905_C());
        boolean disableFeatures = false;
        disableFeatures |= this.majorFeatureGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
        if (!(disableFeatures |= !TFFeature.getNearestFeature((int)chunkX, (int)chunkZ, (World)this.worldObj).areChunkDecorationsEnabled) && this.rand.nextInt(4) == 0) {
            int i1 = mapX + this.rand.nextInt(16) + 8;
            int i2 = this.rand.nextInt(TFWorld.CHUNKHEIGHT);
            int i3 = mapY + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a(this.worldObj, this.rand, i1, i2, i3);
        }
        if (!disableFeatures && this.rand.nextInt(32) == 0) {
            int j1 = mapX + this.rand.nextInt(16) + 8;
            int j2 = this.rand.nextInt(this.rand.nextInt(TFWorld.CHUNKHEIGHT - 8) + 8);
            int j3 = mapY + this.rand.nextInt(16) + 8;
            if (j2 < TFWorld.SEALEVEL || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a(this.worldObj, this.rand, j1, j2, j3);
            }
        }
        for (int k1 = 0; k1 < 8; ++k1) {
            int k2 = mapX + this.rand.nextInt(16) + 8;
            int k3 = this.rand.nextInt(TFWorld.CHUNKHEIGHT);
            int l3 = mapY + this.rand.nextInt(16) + 8;
            new WorldGenDungeons().func_76484_a(this.worldObj, this.rand, k2, k3, l3);
        }
        biomegenbase.func_76728_a(this.worldObj, this.rand, mapX, mapY);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomegenbase, (int)(mapX + 8), (int)(mapY + 8), (int)16, (int)16, (Random)this.rand);
        mapX += 8;
        mapY += 8;
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                int j4 = this.worldObj.func_72874_g(mapX + i2, mapY + j3);
                if (this.worldObj.func_72884_u(i2 + mapX, j4 - 1, j3 + mapY)) {
                    this.worldObj.func_147465_d(i2 + mapX, j4 - 1, j3 + mapY, Blocks.field_150432_aD, 0, 2);
                }
                if (!this.worldObj.func_147478_e(i2 + mapX, j4, j3 + mapY, true)) continue;
                this.worldObj.func_147465_d(i2 + mapX, j4, j3 + mapY, Blocks.field_150431_aC, 0, 2);
            }
        }
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "TwilightLevelSource";
    }

    public List<BiomeGenBase.SpawnListEntry> func_73155_a(EnumCreatureType creatureType, int mapX, int mapY, int mapZ) {
        int spawnListIndex;
        TFFeature nearestFeature = TFFeature.getFeatureForRegion(mapX >> 4, mapZ >> 4, this.worldObj);
        if (nearestFeature != TFFeature.nothing && (spawnListIndex = this.majorFeatureGenerator.getSpawnListIndexAt(mapX, mapY, mapZ)) >= 0) {
            return nearestFeature.getSpawnableList(creatureType, spawnListIndex);
        }
        if (mapY < TFWorld.SEALEVEL && creatureType == EnumCreatureType.monster) {
            return TFFeature.underground.getSpawnableList(creatureType);
        }
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(mapX, mapZ);
        if (biomegenbase == null) {
            return null;
        }
        return biomegenbase.func_76747_a(creatureType);
    }

    public ChunkPosition findClosestStructure(World par1World, String par2Str, int par3, int par4, int par5) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int var1, int var2) {
        this.majorFeatureGenerator.func_151539_a(this, this.worldObj, var1, var2, null);
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }

    public ChunkPosition func_147416_a(World var1, String var2, int var3, int var4, int var5) {
        return null;
    }
}

