/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.world.BlockEvent;
import twilightforest.TFAchievementPage;
import twilightforest.TFEnchantment;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFCharmEffect;
import twilightforest.entity.EntityTFPinchBeetle;
import twilightforest.item.TFItems;

public class TFEventListener {
    protected HashMap<String, InventoryPlayer> playerKeepsMap = new HashMap();

    @SubscribeEvent
    public void pickupItem(EntityItemPickupEvent event) {
        if (event.item.func_92059_d().func_77973_b() == TFItems.scepterTwilight || event.item.func_92059_d().func_77973_b() == TFItems.scepterLifeDrain || event.item.func_92059_d().func_77973_b() == TFItems.scepterZombie) {
            this.checkPlayerForScepterMastery(event.entityPlayer);
        }
    }

    private void checkPlayerForScepterMastery(EntityPlayer player) {
        boolean scepterTwilight = false;
        boolean scepterLifeDrain = false;
        boolean scepterZombie = false;
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack != null && stack.func_77973_b() == TFItems.scepterTwilight) {
                scepterTwilight = true;
            }
            if (stack != null && stack.func_77973_b() == TFItems.scepterLifeDrain) {
                scepterLifeDrain = true;
            }
            if (stack == null || stack.func_77973_b() != TFItems.scepterZombie) continue;
            scepterZombie = true;
        }
        if (scepterTwilight && scepterLifeDrain && scepterZombie) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightLichScepters);
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        System.out.println("Getting item crafted event");
        ItemStack itemStack = event.crafting;
        EntityPlayer player = event.player;
        if (itemStack.func_77973_b() == TFItems.plateNaga || itemStack.func_77973_b() == TFItems.legsNaga) {
            this.checkPlayerForNagaArmorer(player);
        }
        if (itemStack.func_77973_b() == TFItems.magicMapFocus) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightMagicMapFocus);
        }
        if (itemStack.func_77973_b() == TFItems.emptyMagicMap) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightMagicMap);
        }
        if (itemStack.func_77973_b() == TFItems.emptyMazeMap) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightMazeMap);
        }
        if (itemStack.func_77973_b() == TFItems.emptyOreMap) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightOreMap);
        }
    }

    private void checkPlayerForNagaArmorer(EntityPlayer player) {
        boolean nagaScale = false;
        boolean legsNaga = false;
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack != null && stack.func_77973_b() == TFItems.nagaScale) {
                nagaScale = true;
            }
            if (stack == null || stack.func_77973_b() != TFItems.legsNaga) continue;
            legsNaga = true;
        }
        if (nagaScale && legsNaga) {
            player.func_71029_a((StatBase)TFAchievementPage.twilightNagaArmors);
        }
    }

    @SubscribeEvent
    public void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester != null && event.harvester.field_71071_by.func_70448_g() != null && event.harvester.field_71071_by.func_70448_g().func_77973_b().func_150897_b(event.block) && event.harvester.field_71071_by.func_70448_g().func_77973_b() == TFItems.fieryPick) {
            ArrayList<ItemStack> removeThese = new ArrayList<ItemStack>(1);
            ArrayList<ItemStack> addThese = new ArrayList<ItemStack>(1);
            for (ItemStack input : event.drops) {
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(input);
                if (result == null) continue;
                addThese.add(new ItemStack(result.func_77973_b(), input.field_77994_a));
                removeThese.add(input);
                this.spawnSpeltXP(result, event.world, event.x, event.y, event.z);
            }
            event.drops.removeAll(removeThese);
            event.drops.addAll(addThese);
        }
    }

    private void spawnSpeltXP(ItemStack smelted, World world, int x, int y, int z) {
        int smeltXP;
        float floatXP = FurnaceRecipes.func_77602_a().func_151398_b(smelted);
        if (floatXP > (float)(smeltXP = (int)floatXP) && world.field_73012_v.nextFloat() < floatXP - (float)smeltXP) {
            ++smeltXP;
        }
        while (smeltXP > 0) {
            int splitXP = EntityXPOrb.func_70527_a((int)smeltXP);
            smeltXP -= splitXP;
            world.func_72838_d((Entity)new EntityXPOrb(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, splitXP));
        }
    }

    @SubscribeEvent
    public void entityHurts(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.entityLiving instanceof EntityPlayer && event.source.field_76373_n.equals("mob") && event.source.func_76346_g() != null) {
            player = (EntityPlayer)event.entityLiving;
            int fireLevel = TFEnchantment.getReactFireLevel(player.field_71071_by, event.source);
            if (fireLevel > 0 && player.func_70681_au().nextInt(25) < fireLevel) {
                event.source.func_76346_g().func_70015_d(fireLevel / 2);
            }
        }
        if (event.entityLiving instanceof EntityPlayer && this.willEntityDie(event)) {
            player = (EntityPlayer)event.entityLiving;
            boolean charm1 = false;
            boolean charm2 = player.field_71071_by.func_146026_a(TFItems.charmOfLife2);
            if (!charm2) {
                charm1 = player.field_71071_by.func_146026_a(TFItems.charmOfLife1);
            }
            if (charm2 || charm1) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
                event.ammount = 0.0f;
                if (charm1) {
                    player.func_70606_j(8.0f);
                    player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 100, 0));
                }
                if (charm2) {
                    player.func_70606_j((float)player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
                    player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 600, 3));
                    player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 600, 0));
                    player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 600, 0));
                }
                EntityTFCharmEffect effect = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, charm1 ? TFItems.charmOfLife1 : TFItems.charmOfLife2);
                player.field_70170_p.func_72838_d((Entity)effect);
                EntityTFCharmEffect effect2 = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, charm1 ? TFItems.charmOfLife1 : TFItems.charmOfLife2);
                effect2.offset = (float)Math.PI;
                player.field_70170_p.func_72838_d((Entity)effect2);
                player.field_70170_p.func_72908_a(player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, "mob.zombie.unfect", 1.5f, 1.0f);
            }
        }
    }

    public boolean willEntityDie(LivingHurtEvent event) {
        float amount = event.ammount;
        DamageSource source = event.source;
        EntityLivingBase living = event.entityLiving;
        if (!source.func_76363_c()) {
            int armor = 25 - living.func_70658_aO();
            amount = amount * (float)armor / 25.0f;
        }
        if (living.func_70644_a(Potion.field_76429_m)) {
            int resistance = 25 - (living.func_70660_b(Potion.field_76429_m).func_76458_c() + 1) * 5;
            amount = amount * (float)resistance / 25.0f;
        }
        return Math.ceil(amount) >= (double)living.func_110143_aJ();
    }

    @SubscribeEvent
    public void bonemealUsed(BonemealEvent event) {
        if (event.block == TFBlocks.sapling && !event.world.field_72995_K) {
            ((BlockSapling)TFBlocks.sapling).func_149878_d(event.world, event.x, event.y, event.z, event.world.field_73012_v);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void livingDies(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayer && !event.entityLiving.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            int i;
            InventoryPlayer keepInventory;
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (player.field_71071_by.func_146026_a(TFItems.charmOfKeeping3)) {
                FMLLog.info((String)"[TwilightForest] Player died with charm of keeping III!  Keep it all!", (Object[])new Object[0]);
                keepInventory = new InventoryPlayer(null);
                this.keepAllArmor(player, keepInventory);
                for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                    keepInventory.field_70462_a[i] = ItemStack.func_77944_b((ItemStack)player.field_71071_by.field_70462_a[i]);
                    player.field_71071_by.field_70462_a[i] = null;
                }
                keepInventory.func_70437_b(new ItemStack(TFItems.charmOfKeeping3));
                this.playerKeepsMap.put(player.func_70005_c_(), keepInventory);
            } else if (player.field_71071_by.func_146026_a(TFItems.charmOfKeeping2)) {
                FMLLog.info((String)"[TwilightForest] Player died with charm of keeping II!  Keep armor and hotbar!", (Object[])new Object[0]);
                keepInventory = new InventoryPlayer(null);
                this.keepAllArmor(player, keepInventory);
                for (i = 0; i < 9; ++i) {
                    keepInventory.field_70462_a[i] = ItemStack.func_77944_b((ItemStack)player.field_71071_by.field_70462_a[i]);
                    player.field_71071_by.field_70462_a[i] = null;
                }
                keepInventory.func_70437_b(new ItemStack(TFItems.charmOfKeeping2));
                this.playerKeepsMap.put(player.func_70005_c_(), keepInventory);
            } else if (player.field_71071_by.func_146026_a(TFItems.charmOfKeeping1)) {
                FMLLog.info((String)"[TwilightForest] Player died with charm of keeping I!  Keep armor and current item!", (Object[])new Object[0]);
                keepInventory = new InventoryPlayer(null);
                this.keepAllArmor(player, keepInventory);
                if (player.field_71071_by.func_70448_g() != null) {
                    keepInventory.field_70462_a[player.field_71071_by.field_70461_c] = ItemStack.func_77944_b((ItemStack)player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c]);
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                }
                keepInventory.func_70437_b(new ItemStack(TFItems.charmOfKeeping1));
                this.playerKeepsMap.put(player.func_70005_c_(), keepInventory);
            }
            if (player.field_71071_by.func_146028_b(TFItems.towerKey)) {
                keepInventory = this.retrieveOrMakeKeepInventory(player);
                for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                    if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != TFItems.towerKey) continue;
                    keepInventory.field_70462_a[i] = ItemStack.func_77944_b((ItemStack)player.field_71071_by.field_70462_a[i]);
                    player.field_71071_by.field_70462_a[i] = null;
                }
                this.playerKeepsMap.put(player.func_70005_c_(), keepInventory);
            }
        }
        if (this.playerKeepsMap.size() > 1) {
            FMLLog.warning((String)"[TwilightForest] Twilight Forest mod is keeping track of a lot of dead player inventories.  Has there been an apocalypse?", (Object[])new Object[0]);
        }
    }

    private InventoryPlayer retrieveOrMakeKeepInventory(EntityPlayer player) {
        if (this.playerKeepsMap.containsKey(player.func_70005_c_())) {
            return this.playerKeepsMap.get(player.func_70005_c_());
        }
        return new InventoryPlayer(null);
    }

    private void keepAllArmor(EntityPlayer player, InventoryPlayer keepInventory) {
        for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
            keepInventory.field_70460_b[i] = ItemStack.func_77944_b((ItemStack)player.field_71071_by.field_70460_b[i]);
            player.field_71071_by.field_70460_b[i] = null;
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        if (this.playerKeepsMap.containsKey(player.func_70005_c_())) {
            int i;
            FMLLog.info((String)"[TwilightForest] Player %s respawned and recieved items held in storage", (Object[])new Object[]{player.func_70005_c_()});
            InventoryPlayer keepInventory = this.playerKeepsMap.get(player.func_70005_c_());
            for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                if (keepInventory.field_70460_b[i] == null) continue;
                player.field_71071_by.field_70460_b[i] = keepInventory.field_70460_b[i];
            }
            for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                if (keepInventory.field_70462_a[i] == null) continue;
                player.field_71071_by.field_70462_a[i] = keepInventory.field_70462_a[i];
            }
            if (keepInventory.func_70445_o() != null) {
                EntityTFCharmEffect effect = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, keepInventory.func_70445_o().func_77973_b());
                player.field_70170_p.func_72838_d((Entity)effect);
                EntityTFCharmEffect effect2 = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, keepInventory.func_70445_o().func_77973_b());
                effect2.offset = (float)Math.PI;
                player.field_70170_p.func_72838_d((Entity)effect2);
                player.field_70170_p.func_72908_a(player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, "mob.zombie.unfect", 1.5f, 1.0f);
            }
            this.playerKeepsMap.remove(player.func_70005_c_());
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        if (this.playerKeepsMap.containsKey(player.func_70005_c_())) {
            FMLLog.warning((String)"[TwilightForest] Mod was keeping inventory items in reserve for player %s but they logged out!  Items are being dropped.", (Object[])new Object[]{player.func_70005_c_()});
            InventoryPlayer keepInventory = this.playerKeepsMap.get(player.func_70005_c_());
            keepInventory.field_70458_d = player;
            keepInventory.func_70436_m();
            this.playerKeepsMap.remove(player.func_70005_c_());
        }
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public boolean preOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HEALTHMOUNT && this.isRidingUnfriendly((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public boolean livingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer && event.entity.func_70093_af() && this.isRidingUnfriendly(event.entityLiving)) {
            event.entity.func_70095_a(false);
        }
        return true;
    }

    private boolean isRidingUnfriendly(EntityLivingBase entity) {
        return entity.func_70115_ae() && entity.field_70154_o instanceof EntityTFPinchBeetle;
    }
}

