/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.storage.MapData;
import twilightforest.TFFeature;
import twilightforest.TFMagicMapData;
import twilightforest.TFMapPacketHandler;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.world.TFWorldChunkManager;

public class ItemTFMagicMap
extends ItemMap {
    public static final String STR_ID = "magicmap";

    protected ItemTFMagicMap() {
    }

    @SideOnly(value=Side.CLIENT)
    public static TFMagicMapData getMPMapData(int par0, World par1World) {
        String mapName = "magicmap_" + par0;
        TFMagicMapData mapData = (TFMagicMapData)par1World.func_72943_a(TFMagicMapData.class, mapName);
        if (mapData == null) {
            mapData = new TFMagicMapData(mapName);
            par1World.func_72823_a(mapName, (WorldSavedData)mapData);
        }
        return mapData;
    }

    public TFMagicMapData getMapData(ItemStack par1ItemStack, World par2World) {
        String mapName = "magicmap_" + par1ItemStack.func_77960_j();
        TFMagicMapData mapData = (TFMagicMapData)par2World.func_72943_a(TFMagicMapData.class, mapName);
        if (mapData == null && !par2World.field_72995_K) {
            par1ItemStack.func_77964_b(par2World.func_72841_b(STR_ID));
            mapName = "magicmap_" + par1ItemStack.func_77960_j();
            mapData = new TFMagicMapData(mapName);
            mapData.field_76201_a = par2World.func_72912_H().func_76079_c();
            mapData.field_76199_b = par2World.func_72912_H().func_76074_e();
            mapData.field_76197_d = (byte)4;
            mapData.field_76200_c = par2World.field_73011_w.field_76574_g;
            mapData.func_76185_a();
            par2World.func_72823_a(mapName, (WorldSavedData)mapData);
        }
        return mapData;
    }

    public void updateMapData(World par1World, Entity par2Entity, TFMagicMapData par3MapData) {
        if (par1World.field_73011_w.field_76574_g == par3MapData.field_76200_c && par2Entity instanceof EntityPlayer) {
            int xSize = 128;
            int zSize = 128;
            int scaleFactor = 1 << par3MapData.field_76197_d;
            int xCenter = par3MapData.field_76201_a;
            int zCenter = par3MapData.field_76199_b;
            int xDraw = MathHelper.func_76128_c((double)(par2Entity.field_70165_t - (double)xCenter)) / scaleFactor + xSize / 2;
            int zDraw = MathHelper.func_76128_c((double)(par2Entity.field_70161_v - (double)zCenter)) / scaleFactor + zSize / 2;
            int drawSize = 1024 / scaleFactor;
            MapData.MapInfo mapInfo = par3MapData.func_82568_a((EntityPlayer)par2Entity);
            ++mapInfo.field_82569_d;
            for (int xStep = xDraw - drawSize + 1; xStep < xDraw + drawSize; ++xStep) {
                if ((xStep & 0xF) != (mapInfo.field_82569_d & 0xF)) continue;
                int highNumber = 255;
                int lowNumber = 0;
                double lastElevation = 0.0;
                for (int zStep = zDraw - drawSize - 1; zStep < zDraw + drawSize; ++zStep) {
                    byte existingColor;
                    if (xStep < 0 || zStep < -1 || xStep >= xSize || zStep >= zSize) continue;
                    int xOffset = xStep - xDraw;
                    int zOffset = zStep - zDraw;
                    boolean var20 = xOffset * xOffset + zOffset * zOffset > (drawSize - 2) * (drawSize - 2);
                    int xDraw2 = (xCenter / scaleFactor + xStep - xSize / 2) * scaleFactor;
                    int zDraw2 = (zCenter / scaleFactor + zStep - zSize / 2) * scaleFactor;
                    int[] biomeFrequencies = new int[256];
                    for (int xStep2 = 0; xStep2 < scaleFactor; ++xStep2) {
                        for (int zStep2 = 0; zStep2 < scaleFactor; ++zStep2) {
                            TFWorldChunkManager tfManager;
                            int biomeID;
                            int n = biomeID = par1World.func_72807_a((int)(xDraw2 + xStep2), (int)(zDraw2 + zStep2)).field_76756_M;
                            biomeFrequencies[n] = biomeFrequencies[n] + 1;
                            if (biomeID == BiomeGenBase.field_76781_i.field_76756_M || biomeID == TFBiomeBase.stream.field_76756_M) {
                                int n2 = biomeID;
                                biomeFrequencies[n2] = biomeFrequencies[n2] + 2;
                            }
                            if (!(par1World.func_72959_q() instanceof TFWorldChunkManager) || !(tfManager = (TFWorldChunkManager)par1World.func_72959_q()).isInFeatureChunk(par1World, xDraw2 + xStep2, zDraw2 + zStep2) || zStep < 0 || xOffset * xOffset + zOffset * zOffset >= drawSize * drawSize) continue;
                            par3MapData.addFeatureToMap(TFFeature.getNearestFeature(xDraw2 + xStep2 >> 4, zDraw2 + zStep2 >> 4, par1World), xDraw2, zDraw2);
                        }
                    }
                    byte biomeIDToShow = 0;
                    int highestFrequency = 0;
                    for (int i = 0; i < 256; ++i) {
                        if (biomeFrequencies[i] <= highestFrequency) continue;
                        biomeIDToShow = (byte)i;
                        highestFrequency = biomeFrequencies[i];
                    }
                    biomeIDToShow = (byte)(biomeIDToShow + 1);
                    if (zStep < 0 || xOffset * xOffset + zOffset * zOffset >= drawSize * drawSize || var20 && (xStep + zStep & 1) == 0 || (existingColor = par3MapData.field_76198_e[xStep + zStep * xSize]) == biomeIDToShow) continue;
                    if (highNumber > zStep) {
                        highNumber = zStep;
                    }
                    if (lowNumber < zStep) {
                        lowNumber = zStep;
                    }
                    par3MapData.field_76198_e[xStep + zStep * xSize] = biomeIDToShow;
                }
                if (highNumber > lowNumber) continue;
                par3MapData.func_76194_a(xStep, highNumber, lowNumber);
            }
        }
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!par2World.field_72995_K) {
            TFMagicMapData mapData = this.getMapData(par1ItemStack, par2World);
            if (par3Entity instanceof EntityPlayer) {
                EntityPlayer var7 = (EntityPlayer)par3Entity;
                mapData.func_76191_a(var7, par1ItemStack);
            }
            if (par5) {
                this.updateMapData(par2World, par3Entity, mapData);
            }
        }
    }

    public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.uncommon;
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }

    public Packet func_150911_c(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        byte[] mapBytes = this.getMapData(par1ItemStack, par2World).func_76193_a(par1ItemStack, par2World, par3EntityPlayer);
        if (mapBytes == null) {
            return null;
        }
        if (mapBytes[0] == 1 && par2World.field_73012_v.nextInt(4) == 0) {
            this.getMapData(par1ItemStack, par2World).checkExistingFeatures(par2World);
            mapBytes = this.getMapData(par1ItemStack, par2World).makeFeatureStorageArray();
        }
        short uniqueID = (short)par1ItemStack.func_77960_j();
        return TFMapPacketHandler.makeMagicMapPacket(STR_ID, uniqueID, mapBytes);
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        return ("" + StatCollector.func_74838_a((String)(this.func_77657_g(par1ItemStack) + ".name")) + " #" + par1ItemStack.func_77960_j()).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("TwilightForest:" + this.func_77658_a().substring(5));
    }
}

