/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import dynamicswordskills.CommonProxy;
import dynamicswordskills.DSSCombatEvents;
import dynamicswordskills.entity.EntityLeapingBlow;
import dynamicswordskills.item.CombatSkillsTab;
import dynamicswordskills.item.ItemSkillOrb;
import dynamicswordskills.lib.Config;
import dynamicswordskills.network.PacketPipeline;
import dynamicswordskills.skills.SkillBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="dynamicswordskills", version="1.7.2-1.1")
public class DynamicSwordSkills {
    @Mod.Instance(value="dynamicswordskills")
    public static DynamicSwordSkills instance;
    @SidedProxy(clientSide="dynamicswordskills.ClientProxy", serverSide="dynamicswordskills.CommonProxy")
    public static CommonProxy proxy;
    public static final PacketPipeline dispatcher;
    public static CreativeTabs tabSkills;
    public static Item skillOrb;
    private boolean shouldLoad;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        boolean bl = this.shouldLoad = !Loader.isModLoaded((String)"zeldaswordskills");
        if (this.shouldLoad) {
            Config.init(event);
            tabSkills = new CombatSkillsTab(CreativeTabs.getNextID(), "dssTab");
            skillOrb = new ItemSkillOrb().func_77655_b("dss.skillorb");
            GameRegistry.registerItem((Item)skillOrb, (String)skillOrb.func_77658_a().substring(5));
            EntityRegistry.registerModEntity(EntityLeapingBlow.class, (String)"leapingblow", (int)0, (Object)this, (int)64, (int)10, (boolean)true);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (this.shouldLoad) {
            proxy.registerRenderers();
            dispatcher.initialise();
            MinecraftForge.EVENT_BUS.register((Object)new DSSCombatEvents());
            DSSCombatEvents.initializeDrops();
            if (Config.getLootWeight() > 0) {
                DynamicSwordSkills.registerDungeonLoot();
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (this.shouldLoad) {
            dispatcher.postInitialise();
        }
    }

    private static void registerDungeonLoot() {
        for (int i = 0; i < 16; ++i) {
            if (SkillBase.getSkillList()[i] == null) continue;
            WeightedRandomChestContent orbLoot = new WeightedRandomChestContent(new ItemStack(skillOrb, 1, i), 1, 1, Config.getLootWeight());
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(orbLoot);
            ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(orbLoot);
            ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem(orbLoot);
            ChestGenHooks.getInfo((String)"strongholdCorridor").addItem(orbLoot);
            ChestGenHooks.getInfo((String)"strongholdLibrary").addItem(orbLoot);
            ChestGenHooks.getInfo((String)"strongholdCrossing").addItem(orbLoot);
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(orbLoot);
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(orbLoot);
        }
    }

    static {
        dispatcher = new PacketPipeline();
    }
}

