/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.lib.Config;
import dynamicswordskills.skills.Dash;
import dynamicswordskills.skills.Dodge;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.Parry;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.SpinAttack;
import dynamicswordskills.skills.SwordBasic;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class TargetingTickHandler {
    private Minecraft mc;
    private EntityPlayer player = null;
    private Entity target = null;

    public TargetingTickHandler(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            DSSPlayerInfo skills;
            ILockOnTarget skill;
            this.player = this.mc.field_71439_g;
            if (this.player != null && DSSPlayerInfo.get(this.player) != null && (skill = (skills = DSSPlayerInfo.get(this.player)).getTargetingSkill()) != null) {
                boolean flag = false;
                if (skills.isSkillActive(SkillBase.dodge)) {
                    flag = ((Dodge)skills.getPlayerSkill(SkillBase.dodge)).onRenderTick(this.player);
                } else if (skills.isSkillActive(SkillBase.spinAttack)) {
                    flag = ((SpinAttack)skills.getPlayerSkill(SkillBase.spinAttack)).onRenderTick(this.player);
                }
                if (!flag && skill.isLockedOn()) {
                    this.target = skill.getCurrentTarget();
                    this.updatePlayerView();
                }
                if (skill instanceof SwordBasic && skill.isLockedOn()) {
                    if (skills.hasSkill(SkillBase.leapingBlow) && !skills.isSkillActive(SkillBase.leapingBlow) && this.isVanillaKeyPressed(this.mc.field_71474_y.field_74314_A) && this.mc.field_71439_g.func_70632_aY()) {
                        skills.activateSkill((World)this.mc.field_71441_e, SkillBase.leapingBlow);
                        KeyBinding.func_74510_a((int)this.mc.field_71474_y.field_74313_G.func_151463_i(), (boolean)false);
                        KeyBinding.func_74510_a((int)DSSKeyHandler.keys[6].func_151463_i(), (boolean)false);
                        if (skills.hasSkill(SkillBase.dash)) {
                            ((Dash)skills.getPlayerSkill(SkillBase.dash)).keyPressed(false);
                        }
                    } else if (Config.allowVanillaControls()) {
                        if (this.isVanillaKeyPressed(this.mc.field_71474_y.field_74370_x) || this.isVanillaKeyPressed(this.mc.field_71474_y.field_74366_z)) {
                            if (skills.hasSkill(SkillBase.spinAttack) && this.mc.field_71474_y.field_74370_x.func_151470_d() && this.mc.field_71474_y.field_74366_z.func_151470_d()) {
                                ((SpinAttack)skills.getPlayerSkill(SkillBase.spinAttack)).keyPressed(this.mc.field_71474_y.field_74370_x, (EntityPlayer)this.mc.field_71439_g);
                            } else if (skills.hasSkill(SkillBase.dodge)) {
                                ((Dodge)skills.getPlayerSkill(SkillBase.dodge)).keyPressed(this.mc.field_71474_y.field_74370_x.func_151470_d() ? this.mc.field_71474_y.field_74370_x : this.mc.field_71474_y.field_74366_z, this.player);
                            }
                        } else if (this.isVanillaKeyPressed(this.mc.field_71474_y.field_74368_y) && skills.hasSkill(SkillBase.parry)) {
                            ((Parry)skills.getPlayerSkill(SkillBase.parry)).keyPressed(this.player);
                        }
                    }
                }
            }
        } else {
            this.player = null;
            this.target = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isVanillaKeyPressed(KeyBinding key) {
        return key.func_151468_f() && key.func_151470_d();
    }

    private void updatePlayerView() {
        float rYaw;
        double dx = this.player.field_70165_t - this.target.field_70165_t;
        double dz = this.player.field_70161_v - this.target.field_70161_v;
        double angle = Math.atan2(dz, dx) * 180.0 / Math.PI;
        double pitch = Math.atan2(this.player.field_70163_u - (this.target.field_70163_u + (double)(this.target.field_70131_O / 2.0f)), Math.sqrt(dx * dx + dz * dz)) * 180.0 / Math.PI;
        double distance = this.player.func_70032_d(this.target);
        for (rYaw = (float)(angle - (double)this.player.field_70177_z); rYaw > 180.0f; rYaw -= 360.0f) {
        }
        while (rYaw < -180.0f) {
            rYaw += 360.0f;
        }
        float rPitch = (float)pitch - (float)(10.0 / Math.sqrt(distance)) + (float)(distance * Math.PI / 90.0);
        this.player.func_70082_c(rYaw += 90.0f, -(rPitch - this.player.field_70125_A));
    }
}

