/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.CommonProxy;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.lib.Config;
import dynamicswordskills.network.SyncPlayerInfoPacket;
import dynamicswordskills.skills.ICombo;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class DSSPlayerInfo
implements IExtendedEntityProperties {
    private static final String EXT_PROP_NAME = "DSSPlayerInfo";
    private final EntityPlayer player;
    private final Map<Byte, SkillBase> skills = new HashMap<Byte, SkillBase>(16);
    private int currentActiveSkillId = -1;
    private boolean receivedGear = false;

    public DSSPlayerInfo(EntityPlayer player) {
        this.player = player;
        this.initSkills();
    }

    private void initSkills() {
        for (int i = 0; i < 16; ++i) {
            if (SkillBase.getSkillList()[i] == null) continue;
            this.skills.put(SkillBase.getSkillList()[i].id, SkillBase.getSkillList()[i].newInstance());
        }
    }

    public void resetSkills() {
        this.skills.clear();
        this.initSkills();
        this.validateSkills();
        DynamicSwordSkills.dispatcher.sendTo(new SyncPlayerInfoPacket(this).setReset(), (EntityPlayerMP)this.player);
    }

    public boolean hasSkill(SkillBase skill) {
        return this.hasSkill(skill.id);
    }

    private boolean hasSkill(byte id) {
        return this.getSkillLevel(id) > 0;
    }

    public byte getSkillLevel(SkillBase skill) {
        return this.getSkillLevel(skill.id);
    }

    public byte getSkillLevel(byte id) {
        if (this.skills.containsKey(id)) {
            return this.skills.get(id).getLevel();
        }
        return 0;
    }

    public boolean canUseSkill(SkillBase skill) {
        return this.hasSkill(skill) && (!(skill instanceof SkillActive) || ((SkillActive)this.getPlayerSkill(skill)).canUse(this.player));
    }

    public boolean isSkillActive(SkillBase skill) {
        if (this.skills.containsKey(skill.id) && this.skills.get(skill.id) instanceof SkillActive) {
            return this.getSkillLevel(skill) > 0 && ((SkillActive)this.skills.get(skill.id)).isActive();
        }
        return false;
    }

    public void setCurrentActiveSkill(SkillBase skill) {
        this.currentActiveSkillId = skill.id;
    }

    public boolean canInteract() {
        if (this.currentActiveSkillId > -1 && !this.isSkillActive(SkillBase.getSkillList()[this.currentActiveSkillId])) {
            this.currentActiveSkillId = -1;
        }
        return this.currentActiveSkillId == -1 && this.player.field_70724_aR == 0;
    }

    public SkillBase getPlayerSkill(SkillBase skill) {
        return this.getPlayerSkill(skill.id);
    }

    public SkillBase getPlayerSkill(byte id) {
        if (this.skills.containsKey(id)) {
            return this.skills.get(id);
        }
        return null;
    }

    public ICombo getComboSkill() {
        for (SkillBase skill : this.skills.values()) {
            if (!(skill instanceof ICombo) || ((ICombo)((Object)skill)).getCombo() == null && (!(skill instanceof SkillActive) || !((SkillActive)skill).isActive())) continue;
            return (ICombo)((Object)skill);
        }
        return null;
    }

    public ILockOnTarget getTargetingSkill() {
        ILockOnTarget planB = null;
        for (SkillBase skill : this.skills.values()) {
            if (!(skill instanceof ILockOnTarget) || !(skill instanceof SkillActive)) continue;
            if (((SkillActive)skill).isActive()) {
                return (ILockOnTarget)((Object)skill);
            }
            planB = (ILockOnTarget)((Object)skill);
        }
        return planB;
    }

    public boolean grantSkill(SkillBase skill) {
        return this.grantSkill(skill.id, (byte)(this.getSkillLevel(skill) + 1));
    }

    public boolean grantSkill(byte id, byte targetLevel) {
        SkillBase skill;
        SkillBase skillBase = skill = this.skills.containsKey(id) ? this.skills.get(id) : SkillBase.getSkillList()[id].newInstance();
        if (skill.grantSkill(this.player, targetLevel)) {
            this.skills.put(id, skill);
            return true;
        }
        return false;
    }

    public boolean activateSkill(World world, SkillBase skill) {
        return this.activateSkill(world, skill.id);
    }

    public boolean activateSkill(World world, byte id) {
        if (this.skills.containsKey(id) && this.skills.get(id) instanceof SkillActive) {
            return ((SkillActive)this.skills.get(id)).activate(world, this.player);
        }
        return false;
    }

    public boolean triggerSkill(World world, SkillBase skill) {
        return this.triggerSkill(world, skill.id);
    }

    public boolean triggerSkill(World world, byte id) {
        if (this.skills.containsKey(id) && this.skills.get(id) instanceof SkillActive) {
            return ((SkillActive)this.skills.get(id)).trigger(world, this.player);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void syncClientSideSkill(byte id, NBTTagCompound compound) {
        if (id < 16 && SkillBase.getSkillList()[id] != null) {
            this.skills.put(id, SkillBase.getSkillList()[id].newInstance().loadFromNBT(compound));
        }
    }

    public void onUpdate() {
        for (SkillBase skill : this.skills.values()) {
            skill.onUpdate(this.player);
        }
        if (this.player.field_70170_p.field_72995_K && DSSKeyHandler.keys[6].func_151470_d() && this.isSkillActive(SkillBase.swordBasic) && this.player.func_70694_bm() != null) {
            Minecraft.func_71410_x().field_71442_b.func_78769_a(this.player, this.player.field_70170_p, this.player.func_70694_bm());
        }
    }

    public void verifyStartingGear() {
        if (!this.receivedGear && Config.giveBonusOrb()) {
            this.receivedGear = this.player.field_71071_by.func_70441_a(new ItemStack(DynamicSwordSkills.skillOrb, 1, (int)SkillBase.swordBasic.id));
        }
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new DSSPlayerInfo(player));
    }

    public static final DSSPlayerInfo get(EntityPlayer player) {
        return (DSSPlayerInfo)player.getExtendedProperties(EXT_PROP_NAME);
    }

    private static final String getSaveKey(EntityPlayer player) {
        return player.func_70005_c_() + ":" + EXT_PROP_NAME;
    }

    public static final void saveProxyData(EntityPlayer player) {
        NBTTagCompound tag = new NBTTagCompound();
        DSSPlayerInfo.get(player).saveNBTData(tag);
        CommonProxy.storeEntityData(DSSPlayerInfo.getSaveKey(player), tag);
    }

    public static final void loadProxyData(EntityPlayer player) {
        DSSPlayerInfo info = DSSPlayerInfo.get(player);
        NBTTagCompound tag = CommonProxy.getEntityData(DSSPlayerInfo.getSaveKey(player));
        if (tag != null) {
            info.loadNBTData(tag);
        }
        info.validateSkills();
        DynamicSwordSkills.dispatcher.sendTo(new SyncPlayerInfoPacket(info), (EntityPlayerMP)player);
    }

    public final void validateSkills() {
        for (SkillBase skill : this.skills.values()) {
            skill.validateSkill(this.player);
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList taglist = new NBTTagList();
        for (SkillBase skill : this.skills.values()) {
            NBTTagCompound skillTag = new NBTTagCompound();
            skill.writeToNBT(skillTag);
            taglist.func_74742_a((NBTBase)skillTag);
        }
        compound.func_74782_a("DynamicSwordSkills", (NBTBase)taglist);
        compound.func_74757_a("receivedGear", this.receivedGear);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagList taglist = compound.func_150295_c("DynamicSwordSkills", 10);
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound skill = taglist.func_150305_b(i);
            byte id = skill.func_74771_c("id");
            this.skills.put(id, SkillBase.getSkillList()[id].loadFromNBT(skill));
        }
        this.receivedGear = compound.func_74767_n("receivedGear");
    }

    public void init(Entity entity, World world) {
    }
}

