/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.lib;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import dynamicswordskills.skills.SkillBase;
import java.io.File;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static boolean allowVanillaControls;
    private static boolean doubleTap;
    private static boolean autoTarget;
    private static int hitsToDisplay;
    private static boolean enableBonusOrb;
    private static int chestLootWeight;
    private static boolean enablePlayerDrops;
    private static int playerDropFactor;
    private static int randomDropChance;
    private static int genericMobDropChance;
    private static int[] orbDropChance;

    public static void init(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(new File(event.getModConfigurationDirectory().getAbsolutePath() + "/dynamicswordskills.cfg"));
        config.load();
        allowVanillaControls = config.get("General", "Allow vanilla controls to activate skills", true).getBoolean(true);
        autoTarget = config.get("General", "Enable auto-targeting of next opponent", true).getBoolean(true);
        doubleTap = config.get("General", "Require double tap activation", true).getBoolean(true);
        hitsToDisplay = config.get("General", "Max hits to display in Combo HUD [0-12]", 3).getInt();
        enableBonusOrb = config.get("General", "Whether all players should start with a Basic Skill orb", true).getBoolean(true);
        chestLootWeight = config.get("General", "Weight for skill orbs when added to vanilla chest loot (0 to disable) [0-10]", 1).getInt();
        enablePlayerDrops = config.get("Drops", "[Player] Enable skill orbs to drop from players when killed in PvP", true).getBoolean(true);
        playerDropFactor = config.get("Drops", "[Player] Factor by which to multiply chance for skill orb to drop by slain players [1-20]", 5).getInt();
        randomDropChance = config.get("Drops", "Chance (as a percent) for specified mobs to drop a random orb [0-100]", 10).getInt();
        genericMobDropChance = config.get("Drops", "Chance (as a percent) for random mobs to drop a random orb [0-100]", 1).getInt();
        for (int i = 0; i < orbDropChance.length; ++i) {
            if (SkillBase.getSkillList()[i] == null || !SkillBase.getSkillList()[i].canDrop()) continue;
            Config.orbDropChance[i] = config.get("Drops", "Chance (in tenths of a percent) for " + SkillBase.getSkillList()[i].name + " [0-10]", 5).getInt();
        }
        config.save();
    }

    public static boolean giveBonusOrb() {
        return enableBonusOrb;
    }

    public static int getLootWeight() {
        return MathHelper.func_76125_a((int)chestLootWeight, (int)0, (int)10);
    }

    public static boolean allowVanillaControls() {
        return allowVanillaControls;
    }

    public static boolean requiresDoubleTap() {
        return doubleTap;
    }

    public static boolean autoTargetEnabled() {
        return autoTarget;
    }

    public static boolean toggleAutoTarget() {
        autoTarget = !autoTarget;
        return autoTarget;
    }

    public static int getHitsToDisplay() {
        return Math.max(hitsToDisplay, 0);
    }

    public static boolean arePlayerDropsEnabled() {
        return enablePlayerDrops;
    }

    public static float getPlayerDropFactor() {
        return MathHelper.func_76125_a((int)playerDropFactor, (int)1, (int)20);
    }

    public static float getChanceForRandomDrop() {
        return MathHelper.func_76131_a((float)((float)randomDropChance * 0.01f), (float)0.0f, (float)1.0f);
    }

    public static float getRandomMobDropChance() {
        return MathHelper.func_76131_a((float)((float)genericMobDropChance * 0.0f), (float)0.0f, (float)1.0f);
    }

    public static float getDropChance(int orbID) {
        return MathHelper.func_76131_a((float)((float)orbDropChance[orbID] * 0.001f), (float)0.0f, (float)0.01f);
    }

    static {
        orbDropChance = new int[16];
    }
}

