/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractPacket;
import dynamicswordskills.skills.SkillBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class SyncSkillPacket
extends AbstractPacket {
    private byte id;
    private NBTTagCompound compound;

    public SyncSkillPacket() {
    }

    public SyncSkillPacket(SkillBase skill) {
        this.id = skill.id;
        this.compound = new NBTTagCompound();
        skill.writeToNBT(this.compound);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeByte((int)this.id);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.compound);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.id = buffer.readByte();
        this.compound = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        DSSPlayerInfo.get(player).syncClientSideSkill(this.id, this.compound);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

