/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.AbstractPacket;
import dynamicswordskills.skills.Combo;
import dynamicswordskills.skills.ICombo;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class UpdateComboPacket
extends AbstractPacket {
    private NBTTagCompound compound;

    public UpdateComboPacket() {
    }

    public UpdateComboPacket(Combo combo) {
        this.compound = combo.writeToNBT();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.compound);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.compound = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        Combo combo = Combo.readFromNBT(this.compound);
        try {
            ICombo skill = (ICombo)((Object)DSSPlayerInfo.get(player).getPlayerSkill(combo.getSkill()));
            if (skill != null) {
                skill.setCombo(combo);
            }
        }
        catch (ClassCastException e) {
            System.err.println("Class Cast Exception from invalid Combo skill id of " + combo.getSkill());
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

