/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.lib.Config;
import dynamicswordskills.network.ActivateSkillPacket;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SwordBasic;
import dynamicswordskills.util.DamageUtils;
import dynamicswordskills.util.PlayerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ArmorBreak
extends SkillActive {
    private int activeTimer = 0;
    private int charge = 0;

    public ArmorBreak(String name, byte id) {
        super(name, id);
        this.addDescription(Arrays.asList("armorbreak.desc.0", "armorbreak.desc.1"));
        this.disableUserActivation();
        this.setDisablesLMB();
    }

    private int getChargeTime(EntityPlayer player) {
        return 20 - this.level;
    }

    public boolean isCharging() {
        return this.charge > 0;
    }

    private ArmorBreak(ArmorBreak skill) {
        super(skill);
    }

    @Override
    public ArmorBreak newInstance() {
        return new ArmorBreak(this);
    }

    @Override
    public List<String> getDescription(EntityPlayer player) {
        ArrayList<String> desc = new ArrayList<String>(this.tooltip);
        desc.add(StatCollector.func_74837_a((String)"skill.dss.armorbreak.desc.2", (Object[])new Object[]{this.getChargeTime(player)}));
        desc.add(StatCollector.func_74837_a((String)"skill.dss.armorbreak.desc.3", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getExhaustion()))}));
        return desc;
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && DSSPlayerInfo.get(player).isSkillActive(swordBasic) && PlayerUtils.isHoldingSword(player);
    }

    @Override
    protected float getExhaustion() {
        return 1.2f - (float)this.level * 0.06f;
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressed(EntityPlayer player) {
        this.charge = this.getChargeTime(player);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isKeyPressed() {
        return DSSKeyHandler.keys[2].func_151470_d() || Config.allowVanillaControls() && Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d() && !Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151468_f();
    }

    @Override
    public boolean trigger(World world, EntityPlayer player) {
        if (super.trigger(world, player)) {
            this.activeTimer = 1;
            ILockOnTarget skill = DSSPlayerInfo.get(player).getTargetingSkill();
            if (skill != null && skill.isLockedOn()) {
                player.func_71059_n(skill.getCurrentTarget());
            }
        }
        return this.isActive();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isCharging()) {
            if (this.isKeyPressed() && PlayerUtils.isHoldingSword(player)) {
                if (!player.field_82175_bq) {
                    if (this.charge < this.getChargeTime(player) - 1) {
                        Minecraft.func_71410_x().field_71442_b.func_78769_a(player, player.field_70170_p, player.func_70694_bm());
                    }
                    --this.charge;
                }
                if (this.charge == 0) {
                    player.field_70724_aR = 4;
                    player.func_71038_i();
                    SwordBasic skill = (SwordBasic)DSSPlayerInfo.get(player).getPlayerSkill(swordBasic);
                    if (skill != null && skill.onAttack(player)) {
                        DynamicSwordSkills.dispatcher.sendToServer(new ActivateSkillPacket(this, true));
                    }
                }
            } else {
                this.charge = 0;
            }
        }
        if (this.isActive()) {
            --this.activeTimer;
        }
    }

    public void onImpact(EntityPlayer player, LivingHurtEvent event) {
        this.activeTimer = 0;
        player.field_70170_p.func_72956_a((Entity)player, "dynamicswordskills:armorbreak", player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f, 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.5f));
        DirtyEntityAccessor.damageEntity(event.entityLiving, DamageUtils.causeArmorBreakDamage((Entity)player), event.ammount);
        event.ammount = 0.0f;
    }
}

