/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.entity.EntityLeapingBlow;
import dynamicswordskills.network.AddExhaustionPacket;
import dynamicswordskills.network.SpawnLeapingBlowPacket;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SwordBasic;
import dynamicswordskills.util.PlayerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class LeapingBlow
extends SkillActive {
    private boolean isActive = false;

    public LeapingBlow(String name, byte id) {
        super(name, id);
        this.setDisablesLMB();
        this.addDescription(Arrays.asList("leapingblow.desc.0", "leapingblow.desc.1", "leapingblow.desc.2"));
    }

    private LeapingBlow(LeapingBlow skill) {
        super(skill);
    }

    @Override
    public LeapingBlow newInstance() {
        return new LeapingBlow(this);
    }

    @Override
    public List<String> getDescription(EntityPlayer player) {
        ArrayList<String> desc = new ArrayList<String>(4);
        desc.add((String)this.tooltip.get(0));
        desc.add(StatCollector.func_74837_a((String)"skill.dss.leapingblow.desc.3", (Object[])new Object[]{this.level}));
        desc.add(StatCollector.func_74837_a((String)"skill.dss.leapingblow.desc.4", (Object[])new Object[]{this.getPotionDuration(player) / 20}));
        desc.add(StatCollector.func_74837_a((String)"skill.dss.leapingblow.desc.5", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getExhaustion()))}));
        return desc;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    private float getDamage(EntityPlayer player) {
        return (float)((double)this.level + player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }

    private int getPotionDuration(EntityPlayer player) {
        return 50 + this.level * 10;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && !player.field_70122_E && DSSPlayerInfo.get(player).isSkillActive(swordBasic) && PlayerUtils.isHoldingSword(player);
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        this.isActive = this.canUse(player);
        if (this.isActive()) {
            DSSPlayerInfo.get(player).setCurrentActiveSkill(this);
        }
        return this.isActive();
    }

    @SideOnly(value=Side.CLIENT)
    public void onImpact(EntityPlayer player, float distance) {
        SwordBasic swordSkill = (SwordBasic)DSSPlayerInfo.get(player).getPlayerSkill(swordBasic);
        if (this.isActive() && swordSkill != null && swordSkill.isActive() && PlayerUtils.isHoldingSword(player)) {
            player.func_71038_i();
            this.isActive = false;
            if (distance < 1.0f) {
                if (swordSkill.onAttack(player)) {
                    Minecraft.func_71410_x().field_71442_b.func_78764_a(player, (Entity)swordSkill.getCurrentTarget());
                }
            } else {
                DynamicSwordSkills.dispatcher.sendToServer(new AddExhaustionPacket(this.getExhaustion()));
                DynamicSwordSkills.dispatcher.sendToServer(new SpawnLeapingBlowPacket());
            }
        }
    }

    public void spawnLeapingBlowEntity(World world, EntityPlayer player) {
        EntityLeapingBlow entity = new EntityLeapingBlow(world, (EntityLivingBase)player).setDamage(this.getDamage(player)).setLevel(this.level);
        world.func_72838_d((Entity)entity);
        world.func_72956_a((Entity)player, "dynamicswordskills:leapingblow", world.field_73012_v.nextFloat() * 0.4f + 0.5f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.5f));
    }
}

